unit fSuspense;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ORDtTm, ORCtrls, ORNet, ORFn, ExtCtrls;

type
  TfrmSuspense = class(TForm)
    ORDateTimeDlg1: TORDateTimeDlg;
    lblHx: TLabel;
    lbHx: TORListBox;
    memHx: TMemo;
    btnHx: TButton;
    btnHDet: TButton;
    btnHEdit: TButton;
    btnHComp: TButton;
    pnlSusp: TPanel;
    lblAction: TLabel;
    lblDate: TLabel;
    dbSuspense: TORDateBox;
    cbAction: TORComboBox;
    Label1: TLabel;
    memSuspense: TMemo;
    btnEnter: TButton;
    btnCanc: TButton;
    btnDel: TButton;
    lblName: TLabel;
    lblProc: TLabel;
    procedure btnCancClick(Sender: TObject);
    procedure btnEnterClick(Sender: TObject);
    procedure GetHistory;
    procedure lbHxClick(Sender: TObject);
    procedure btnHxClick(Sender: TObject);
    procedure btnHDetClick(Sender: TObject);
    procedure btnHCompClick(Sender: TObject);
    procedure EnableHistory;
    procedure DisableHistory;
    procedure btnHEditClick(Sender: TObject);
    procedure cbActionClick(Sender: TObject);
    procedure dbSuspenseChange(Sender: TObject);
    procedure cbActionChange(Sender: TObject);
    procedure EditReset;
    procedure ClearFields;
    procedure lbHxDblClick(Sender: TObject);
    procedure btnDelClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmSuspense: TfrmSuspense;
  SuspAction, SuspActIFN, SuspFMDate, SuspDt, SuspIFN: string;
  Edit, Change: integer;

procedure CreateSuspense;

implementation

{$R *.dfm}

uses SCMMain, fCurrentWait;

procedure CreateSuspense;
begin
  frmSuspense := TfrmSuspense.Create(Application);
  try
  with frmSuspense do
    begin
      Edit    := 0;
      Change  := 0;
      lblName.Caption := PtName;
      lblProc.Caption := PtProc;
      CallV('APTWL GET SUSP ACTION', []);
      cbAction.Items := RPCBrokerV.Results;
      GetHistory;
      ShowModal;
    end;
  finally
    frmSuspense.Release;
  end;
end;

procedure TfrmSuspense.btnCancClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmSuspense.btnEnterClick(Sender: TObject);
var
  Success: string;
begin
  if Edit = 1 then
    begin
      if Change = 0 then
        begin
          MessageDlg('No changes were made!', mtinformation, [mbOK], 0);
          EditReset;
          Exit;
        end;
      Success := sCallV('APTWL SAVE SUSPENSE', [SpecIFN, wlIFN, SuspIFN, SuspActIFN, SuspFMDate, memSuspense.Lines]);
      if Success = '1' then
        begin
          MessageDlg('The edit for ' + PtName + ' for ' + dbSuspense.Text + ' was successful.', mtinformation, [mbOK], 0);
          GetHistory;
        end;
      EditReset;
      Exit;
    end;
  SuspActIFN := IntToStr(cbAction.ItemIEN);
  SuspFMDate := FloatToStr(dbSuspense.FMDateTime);
  Success    := sCallV('APTWL PUT SUSPENSE', [SpecIFN, wlIFN, SuspActIFN, SuspFMDate, memSuspense.Lines]);
  if Success = '1' then
    begin
      MessageDlg('New suspense created for ' + PtName + ' for ' + dbSuspense.Text, mtinformation, [mbOK], 0);
      GetHistory;
      ClearFields;
      Exit;
    end;
  if Success = '0' then
    begin
      MessageDlg('Could not create new suspense for ' + PtName, mtwarning, [mbOK], 0);
      Exit;
    end;
end;

procedure TfrmSuspense.GetHistory;
begin
  CallV('APTWL GET SUSPENSE HX', [SpecIFN, wlIFN]);
  lbHx.Items := RPCBrokerV.Results;
end;

procedure TfrmSuspense.lbHxClick(Sender: TObject);
begin
  SuspIFN    := piece(lbHx.Items[lbHx.ItemIndex], '^', 1);
  SuspDt     := piece(lbHx.Items[lbHx.ItemIndex], '^', 2);
  SuspAction := piece(lbHx.Items[lbHx.ItemIndex], '^', 3);
  SuspActIFN := piece(lbHx.Items[lbHx.ItemIndex], '^', 5);
  SuspFMDate := piece(lbHx.Items[lbHx.ItemIndex], '^', 6);
  EnableHistory;
end;

procedure TfrmSuspense.btnHxClick(Sender: TObject);
begin
  memHx.Visible := False;
  btnHx.Visible := False;
  DisableHistory;
  lbHx.ItemIndex := -1;
end;

procedure TfrmSuspense.btnHDetClick(Sender: TObject);
begin
  memHx.Visible := True;
  btnHx.Visible := True;
  memHx.BringToFront;
  btnHx.BringToFront;
  CallV('APTWL GET HX DETAILS', [SpecIFN, wlIFN, SuspIFN]);
  memHx.Lines := RPCBrokerV.Results;
end;

procedure TfrmSuspense.btnHCompClick(Sender: TObject);
var
  Success: string;
begin
  if piece(lbHx.Items[lbHx.ItemIndex], '^', 4) = 'COMPLETED' then
    begin
      MessageDlg('Suspense already completed!', mtwarning, [mbOK], 0);
      Exit;
    end;
  if MessageDlg('OK to complete the ' + SuspDt + ' suspense for ' + PtName + '?', mtinformation, [mbYes, mbNo], 0) = mrNo then Exit;
  Success := sCallV('APTWL COMPLETE SUSPENSE', [SpecIFN, wlIFN, SuspIFN]);
  GetHistory;
  DisableHistory;
end;

procedure TfrmSuspense.EnableHistory;
begin
  btnHDet.Enabled  := True;
  btnHEdit.Enabled := True;
  btnHComp.Enabled := True;
  btnDel.Enabled   := True;
end;

procedure TfrmSuspense.DisableHistory;
begin
  btnHDet.Enabled  := False;
  btnHEdit.Enabled := False;
  btnHComp.Enabled := False;
  btnDel.Enabled   := False;
end;

procedure TfrmSuspense.btnHEditClick(Sender: TObject);
begin
  if piece(lbHx.Items[lbHx.ItemIndex], '^', 4) = 'COMPLETED' then
    begin
      MessageDlg('Suspense already completed.  No editing allowed.', mtwarning, [mbOK], 0);
      Exit;
    end;
  CallV('APTWL GET SUSP COMM', [SpecIFN, wlIFN, SuspIFN]);
  memSuspense.Lines := RPCBrokerV.Results;
  cbAction.Text     := SuspAction;
  dbSuspense.Text   := SuspDt;
  Edit := 1;
  frmSuspense.Caption := 'Edit Suspense';
  btnEnter.Caption    := 'Submit Edit';
end;

procedure TfrmSuspense.cbActionClick(Sender: TObject);
begin
  SuspActIFN := IntToStr(cbAction.ItemIEN);
end;

procedure TfrmSuspense.dbSuspenseChange(Sender: TObject);
begin
  if Edit = 1 then Change := 1;
  SuspFMDate := FloatToStr(dbSuspense.FMDateTime);
end;

procedure TfrmSuspense.cbActionChange(Sender: TObject);
begin
  if Edit = 1 then Change := 1;
end;

procedure TfrmSuspense.EditReset;
begin
  Edit := 0;
  Change := 0;
  frmSuspense.Caption := 'Create/Complete Suspense';
  btnEnter.Caption    := 'Submit Suspense';
  ClearFields;
  DisableHistory;
end;

procedure TfrmSuspense.ClearFields;
begin
  cbAction.Text   := '';
  dbSuspense.Text := '';
  memSuspense.Clear;
  lbHx.ItemIndex := -1;
end;

procedure TfrmSuspense.lbHxDblClick(Sender: TObject);
begin
  btnHDetClick(Self);
  DisableHistory;
end;

procedure TfrmSuspense.btnDelClick(Sender: TObject);
var
  Success: string;
begin
  if MessageDlg('Are you sure you want to delete the ' + SuspDt + ' suspense for ' + PtName + '?', mtwarning, [mbYes, mbNo], 0) = mrNo then Exit;
  Success := sCallV('APTWL DELETE SUSPENSE', [SpecIFN, wlIFN, SuspIFN]);
  if Success = '1' then
    begin
      MessageDlg('Deleting ' + SuspDt + ' suspense was successful.', mtinformation, [mbOK], 0);
      GetHistory;
      Exit;
    end;
end;

end.
