unit fProcedure;
//  ptld/jit   6-6-08

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ORCtrls, ORNet, ORFn, ExtCtrls, Buttons;

type
  TfrmProcedure = class(TForm)
    lbProc: TORListBox;
    lblProc: TLabel;
    btnPAdd: TButton;
    btnPEdit: TButton;
    btnPDel: TButton;
    btnPExit: TButton;
    pnlSel: TPanel;
    lblProc2: TLabel;
    lblProc1: TLabel;
    cbProc: TORComboBox;
    edProc: TEdit;
    btnOK: TButton;
    btnUp: TBitBtn;
    btnDown: TBitBtn;
    procedure DisableSel;
    procedure EnableSel;
    procedure lbProcClick(Sender: TObject);
    procedure btnPDelClick(Sender: TObject);
    procedure btnPEditClick(Sender: TObject);
    procedure btnPAddClick(Sender: TObject);
    procedure btnOKClick(Sender: TObject);
    procedure btnPExitClick(Sender: TObject);
    procedure cbProcChange(Sender: TObject);
    procedure cbProcClick(Sender: TObject);
    procedure edProcChange(Sender: TObject);
    procedure RefreshProcList;
    procedure DisableMenu;
    procedure btnUpClick(Sender: TObject);
    procedure btnDownClick(Sender: TObject);
    procedure SavePList;
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmProcedure: TfrmProcedure;
  PrEdit, ProcIFN, PrChange, New: integer;
  LProcIFN, LProcName: string;

procedure GetProcedures;

implementation

{$R *.dfm}

uses fParam, SCMMain, fSubGroup;

procedure GetProcedures;
begin
  frmProcedure := TfrmProcedure.Create(Application);
  try
  with frmProcedure do
    begin
      if GroupType = 'S' then lblProc.Caption := 'Procedures for SubGroup ' + SGroupName
      else lblProc.Caption := 'Procedures for ' + GroupName;
      if UsePTLD = 0 then
        begin
          lblProc2.Visible := False;
          cbProc.Visible   := False;
        end;
      if UsePTLD = 1 then
        begin
          CallV('APTWL GET PROC', []);
          cbProc.Items := RPCBrokerV.Results;
        end;
      PrEdit  := 0;
      PrChange := 0;
      DisableSel;
      DisableMenu;
      RefreshProcList;
      ShowModal;
    end;
  finally
    frmProcedure.Release;
  end;
end;

procedure TfrmProcedure.DisableSel;
begin
  lblProc2.Enabled := False;
  cbProc.Enabled   := False;
  lblProc1.Enabled := False;
  edProc.Enabled   := False;
  btnOK.Enabled    := False;
  pnlSel.Enabled   := False;
end;

procedure TfrmProcedure.EnableSel;
begin
  lblProc2.Enabled := True;
  cbProc.Enabled   := True;
  lblProc1.Enabled := True;
  edProc.Enabled   := True;
  btnOK.Enabled    := True;
  pnlSel.Enabled   := True;
end;

procedure TfrmProcedure.lbProcClick(Sender: TObject);
begin
  if lbProc.Items.Count = 0 then Exit;
  LProcIFN         := piece(lbProc.Items[lbProc.ItemIndex], '^', 3);
  ProcIFN          := lbProc.ItemIEN;
  btnPEdit.Enabled := True;
  btnPDel.Enabled  := True;
  btnUp.Enabled    := True;
  btnDown.Enabled  := True;
end;

procedure TfrmProcedure.btnPDelClick(Sender: TObject);
begin
  cbProc.Text := '';
  edProc.Text := '';
  if MessageDlg('Are you sure you want to delete ' + piece(lbProc.Items[lbProc.ItemIndex], '^', 2), mtInformation, [mbYes,mbNo],0) = mrYes then
    begin
      CallV('APTWL DEL SPEC GRP PROC', [SpecIFN, GroupIFN, SGroupIFN, ProcIFN, LProcIFN]);
      RefreshProcList;
    end;
  DisableSel;
  DisableMenu;
end;

procedure TfrmProcedure.btnPEditClick(Sender: TObject);
begin
  btnOK.Enabled    := True;
  pnlSel.Enabled   := True;
  btnPAdd.Enabled  := False;
  if LProcIFN <> '' then // ptld local procedure
    begin
      lblProc2.Enabled := True;
      cbProc.Enabled   := True;
      cbProc.Text      := piece(lbProc.Items[lbProc.ItemIndex], '^', 2);
      cbProc.SetFocus;
    end
  else                   // free text procedure
    begin
      lblProc1.Enabled := True;
      edProc.Enabled   := True;
      lblProc1.Caption := 'Edit Procedure Name:';
      edProc.Text      := piece(lbProc.Items[lbProc.ItemIndex], '^', 2);
      edProc.SetFocus;
    end;
  PrEdit := 1;
end;

procedure TfrmProcedure.btnPAddClick(Sender: TObject);
begin
  EnableSel;
  PrEdit      := 0;
  cbProc.Text := '';
  LProcIFN    := '';
  ProcIFN     := 0;
  edProc.Text := '';
  lblProc1.Caption := 'Enter Procedure Name:';
  if UsePTLD = 1 then cbProc.SetFocus
  else edProc.SetFocus;
end;

procedure TfrmProcedure.btnOKClick(Sender: TObject);
begin
  if (edProc.Text = '') and (cbProc.Text = '') then
    begin
      DisableSel;
      Exit;
    end;
  if PrEdit = 1 then
    begin
      if PrChange = 0 then
        begin
          DisableSel;
          Exit;
        end;
      CallV('APTWL EDIT SPEC GRP PROC', [SpecIFN, GroupIFN, SGroupIFN, ProcIFN, edProc.Text, LProcIFN]);
      RefreshProcList;
      PrEdit  := 0;
      PrChange := 0;
      edProc.Text := '';
      cbProc.Text := '';
      LProcIFN    := '';
    end
  else
    begin
      CallV('APTWL PUT SPEC GRP PROC', [SpecIFN, GroupIFN, SGroupIFN, LProcIFN, edProc.Text]);
      RefreshProcList;
    end;
  edProc.Text := '';
  cbProc.Text := '';
  LProcIFN    := '';
  btnOK.Default := False;
  DisableSel;
  DisableMenu;
end;

procedure TfrmProcedure.btnPExitClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmProcedure.cbProcChange(Sender: TObject);
begin
  if cbProc.Text = '' then
    begin
      cbProc.DroppedDown := False;
      Exit;
    end;
  cbProc.Items.Clear;
  CallV('APTWL GET PROC', [cbProc.Text]);
  cbProc.Items := RPCBrokerV.Results;
  cbProc.DroppedDown := True;
  btnOK.Default := True;
  PrChange := 1;
end;

procedure TfrmProcedure.cbProcClick(Sender: TObject);
begin
  LProcIFN  := IntToStr(cbProc.ItemIEN);
  LProcName := cbProc.Text;
end;

procedure TfrmProcedure.edProcChange(Sender: TObject);
begin
  PrChange := 1;
  btnOK.Default := True;
end;

procedure TfrmProcedure.RefreshProcList;
begin
  if GroupType = 'G' then CallV('APTWL GET SPEC GRP PROC', [SpecIFN, GroupIFN])
  else CallV('APTWL GET SPEC SGRP PROC', [SpecIFN, GroupIFN, SGroupIFN]);
  lbProc.Items := RPCBrokerV.Results;
end;

procedure TfrmProcedure.DisableMenu;
begin
  btnPEdit.Enabled := False;
  btnPDel.Enabled  := False;
  btnPAdd.Enabled  := True;
end;

procedure TfrmProcedure.btnUpClick(Sender: TObject);
begin
  New := lbProc.ItemIndex - 1;
  SavePList;
end;

procedure TfrmProcedure.btnDownClick(Sender: TObject);
begin
  New := lbProc.ItemIndex + 1;
  SavePList;
end;

procedure TfrmProcedure.SavePList;
var
  Node: integer;
begin
  lbProc.Items.Move(lbProc.ItemIndex, New);
  lbProc.ItemIndex := New;
  if LProcIFN <> '' then
    if SGroupIFN <> '' then Node := 1
    else Node := 2;
  if LProcIFN = '' then
    if SGroupIFN <> '' then Node := 2
    else Node := 3;
  if SGroupIFN = '' then CallV('APTWL PUT SPEC PROC LST', [SpecIFN, GroupIFN, Node, lbProc.Items])
  else CallV('APTWL PUT SPEC PROC SG LST', [SpecIFN, GroupIFN, SGroupIFN, Node, lbProc.Items]);
end;

end.
