unit fParam;
    //  John Thomas
    //  1-10-07
interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, ORCtrls, ORFn, ORNet, Buttons, ComCtrls;

type
  TfrmSpecParam = class(TForm)
    pnl1: TPanel;
    btnSave: TButton;
    btnExit: TBitBtn;
    pcParam: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    lbSurg: TORListBox;
    lblSurg: TLabel;
    btnAdd: TButton;
    btnPos: TButton;
    btnInact: TButton;
    lblAbb: TLabel;
    edAbb: TEdit;
    lblBlock: TLabel;
    lblColor: TLabel;
    ColorBox1: TColorBox;
    lblTitle: TLabel;
    cbTitle: TORComboBox;
    btnColor: TButton;
    lblFac: TLabel;
    lblCare: TLabel;
    cbFac: TORComboBox;
    cbCare: TORComboBox;
    cbCode: TORComboBox;
    pnlSel: TPanel;
    lblSurg1: TLabel;
    cbSurg: TORComboBox;
    rgPos: TRadioGroup;
    btnOK: TButton;
    btnCanc: TButton;
    TabSheet3: TTabSheet;
    lbConsult: TORListBox;
    lblConsult: TLabel;
    pnlCSel: TPanel;
    lblCSel: TLabel;
    cbCSel: TORComboBox;
    btnCCanc: TButton;
    btnCAdd: TButton;
    btnCInac: TButton;
    TabSheet4: TTabSheet;
    lbGroup: TORListBox;
    lblGroup: TLabel;
    btnPGAdd: TButton;
    btnPGEdit: TButton;
    btnPGDel: TButton;
    btnAProc: TButton;
    btnADiag: TButton;
    btnASymp: TButton;
    pnlGroup: TPanel;
    lblPGEdit: TLabel;
    edGroup: TEdit;
    btnGOK: TButton;
    lblSRM: TLabel;
    cbxYes: TCheckBox;
    cbxNo: TCheckBox;
    btnASub: TButton;
    btnATree: TButton;
    TabSheet5: TTabSheet;
    lblQues: TLabel;
    cbQues1: TCheckBox;
    cbQues2: TCheckBox;
    cbQues3: TCheckBox;
    cbQues4: TCheckBox;
    cbQues5: TCheckBox;
    cbQues6: TCheckBox;
    cbQues7: TCheckBox;
    cbQues8: TCheckBox;
    cbQues9: TCheckBox;
    cbQues10: TCheckBox;
    cbQues11: TCheckBox;
    cbQues12: TCheckBox;
    TabSheet6: TTabSheet;
    btnUp: TBitBtn;
    btnDown: TBitBtn;
    cbxReq1: TCheckBox;
    cbxReq2: TCheckBox;
    cbxReq3: TCheckBox;
    cbxReq4: TCheckBox;
    cbxReq5: TCheckBox;
    cbxReq6: TCheckBox;
    cbxReq7: TCheckBox;
    cbxReq8: TCheckBox;
    cbxReq9: TCheckBox;
    cbxReq10: TCheckBox;
    cbxReq11: TCheckBox;
    cbxReq12: TCheckBox;
    cbxReq13: TCheckBox;
    cbxReq14: TCheckBox;
    cbxReq15: TCheckBox;
    cbxReq16: TCheckBox;
    cbxReq17: TCheckBox;
    cbxReq18: TCheckBox;
    cbxReq19: TCheckBox;
    cbxReq20: TCheckBox;
    procedure btnExitClick(Sender: TObject);
    procedure btnSaveClick(Sender: TObject);
    procedure btnAddClick(Sender: TObject);
    procedure cbTitleClick(Sender: TObject);
    procedure cbSurgClick(Sender: TObject);
    procedure lbSurgClick(Sender: TObject);
    procedure btnInactClick(Sender: TObject);
    procedure cbTitleChange(Sender: TObject);
    procedure ColorBox1Change(Sender: TObject);
    procedure edAbbChange(Sender: TObject);
    procedure lbSurgChange(Sender: TObject);
    procedure btnPosClick(Sender: TObject);
    procedure btnColorClick(Sender: TObject);
    procedure cbSurgChange(Sender: TObject);
    procedure cbFacChange(Sender: TObject);
    procedure cbCareChange(Sender: TObject);
    procedure cbFacClick(Sender: TObject);
    procedure cbCareClick(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure cbCodeChange(Sender: TObject);
    procedure DisplaySurg;
    procedure HideSurg;
    procedure btnCancClick(Sender: TObject);
    procedure btnOKClick(Sender: TObject);
    procedure btnCCancClick(Sender: TObject);
    procedure btnCAddClick(Sender: TObject);
    procedure lbConsultClick(Sender: TObject);
    procedure cbCSelClick(Sender: TObject);
    procedure btnCInacClick(Sender: TObject);
    procedure cbxYesClick(Sender: TObject);
    procedure cbxNoClick(Sender: TObject);
    procedure btnASubClick(Sender: TObject);
    procedure DisablePMenu;
    procedure EnablePMenu;
    procedure btnPGAddClick(Sender: TObject);
    procedure btnGOKClick(Sender: TObject);
    procedure lbGroupClick(Sender: TObject);
    procedure btnPGEditClick(Sender: TObject);
    procedure pcParamChange(Sender: TObject);
    procedure btnPGDelClick(Sender: TObject);
    procedure DisablePGroup;
    procedure EnablePGroup;
    procedure btnAProcClick(Sender: TObject);
    procedure btnADiagClick(Sender: TObject);
    procedure edGroupChange(Sender: TObject);
    procedure lbGroupChange(Sender: TObject);
    procedure btnASympClick(Sender: TObject);
    procedure RefreshGroupList;
    procedure btnATreeClick(Sender: TObject);
    procedure cbQues1Click(Sender: TObject);
    procedure cbQues2Click(Sender: TObject);
    procedure cbQues3Click(Sender: TObject);
    procedure cbQues4Click(Sender: TObject);
    procedure cbQues5Click(Sender: TObject);
    procedure cbQues6Click(Sender: TObject);
    procedure cbQues7Click(Sender: TObject);
    procedure cbQues8Click(Sender: TObject);
    procedure cbQues9Click(Sender: TObject);
    procedure DisableGMenu;
    procedure btnUpClick(Sender: TObject);
    procedure btnDownClick(Sender: TObject);
    procedure cbxReq1Click(Sender: TObject);
    procedure cbxReq2Click(Sender: TObject);
    procedure cbxReq3Click(Sender: TObject);
    procedure cbxReq4Click(Sender: TObject);
    procedure cbxReq5Click(Sender: TObject);
    procedure cbxReq6Click(Sender: TObject);
    procedure cbxReq7Click(Sender: TObject);
    procedure cbxReq8Click(Sender: TObject);
    procedure cbxReq9Click(Sender: TObject);
    procedure cbxReq10Click(Sender: TObject);
    procedure cbxReq11Click(Sender: TObject);
    procedure cbxReq12Click(Sender: TObject);
    procedure cbxReq13Click(Sender: TObject);
    procedure cbxReq14Click(Sender: TObject);
    procedure cbxReq15Click(Sender: TObject);
    procedure cbxReq16Click(Sender: TObject);
    procedure cbxReq17Click(Sender: TObject);
    procedure cbxReq18Click(Sender: TObject);
    procedure SaveGList;
  private
    { Private declarations }
  public
    { Public declarations }
    frmSpecParam: TfrmSpecParam;
  end;

var
  frmSpecParam: TfrmSpecParam;
  TitleIFN, FacIFN, CareIFN, GroupIFN, GroupName, GroupType: string;
  SGroupIFN, SGroupName: string;
  Change, Edit, TitleChange, SClick, PosTemp, UseSRM, PEdit, PChange, New: integer;

procedure EditParam(Spec: integer);

implementation

{$R *.dfm}

uses SCMMain, fColor, rLocal, fProcedure, fDiagnosis, fSymptom,
     fSubGroup, fTree;

procedure EditParam(Spec: integer);
var
  data: string;
begin
  frmSpecParam := TfrmSpecParam.Create(Application);
  with frmSpecParam do
  begin
    Caption := SpecName + ' ' + Caption;
    CallV('APTWL GET TITLES', []);
    cbTitle.Items := RPCBrokerV.Results;
    CallV('APTWL GET PROVIDER', ['G', SpecIFN]);
    cbSurg.Items  := RPCBrokerV.Results;
    CallV('APTWL GET FACILITATORS', [SiteIFN]);
    cbFac.Items   := RPCBrokerV.Results;
    cbCare.Items  := RPCBrokerV.Results;
    CallV('APTWL GET CODES', []);
    cbCode.Items  := RPCBrokerV.Results;
    CallV('APTWL GET REQ SRVC', [SpecName]);
    cbCSel.Items  := RPCBrokerV.Results;
    data := sCallV('APTWL GET SPEC PARAM', [SpecIFN]);
    cbTitle.Text  := piece(piece(data, '^', 1), ':', 2);
    TitleIFN      := piece(piece(data, '^', 1), ':', 1);
    ColorBox1.Selected := clWhite;
    if (piece(data, '^', 2) <> '') then ColorBox1.Selected := StringToColor(piece(data, '^', 2));
    cbCode.Text   := piece(data, '^', 3);
    edAbb.Text    := piece(data, '^', 4);
    cbFac.Text    := piece(piece(data, '^', 5), ':', 2);
    FacIFN        := piece(piece(data, '^', 5), ':', 1);
    cbCare.Text   := piece(piece(data, '^', 6), ':', 2);
    CareIFN       := piece(piece(data, '^', 6), ':', 1);
    UseSRM        := StrToInt(piece(data, '^', 7));
    if UseSRM = 1 then cbxYes.Checked := True
    else cbxNo.Checked := True;
    CallV('APTWL GET SURGEONS', [SpecIFN]);
    lbSurg.Items     := RPCBrokerV.Results;
    CallV('APTWL GET CON SRVC LIST', [SpecIFN]);
    lbConsult.Items  := RPCBrokerV.Results;
    RefreshGroupList;
    btnInact.Enabled := False;
    btnPos.Enabled   := False;
    btnCInac.Enabled := False;
    Change           := 0;
    PChange          := 0;
    Edit             := 0;
    PEdit            := 0;
    TitleChange      := 0;
    SClick           := 0;
    SGroupIFN        := '';
    SGroupName       := '';
    pcParam.ActivePage := TabSheet1;
    pnl1.Color       := SpecColor;
    ShowModal;
  end;
end;


procedure TfrmSpecParam.btnExitClick(Sender: TObject);
begin
  if Change = 1 then btnSaveClick(Self);
  Close;
end;

procedure TfrmSpecParam.btnSaveClick(Sender: TObject);
var
  data, title, color, code, abb, fac, care, Success, ques, reqfld: string;
begin
  if Change = 0 then
  begin
    MessageDlg('No changes have been made.', mtInformation, [mbOK], 0);
    Exit;
  end;
  title := TitleIFN;
  color := ColorToString(ColorBox1.Selected);
  code  := cbCode.Text;
  abb   := edAbb.Text;
  fac   := FacIFN;
  care  := CareIFN;
  ques  := '0^0^0^0^0^0^0^0^0^0^0^0';
  reqfld := '^^^^^^^^^^^^^^^^^^^^';
  // srm surgical risk questions
  if cbQues1.Checked = True then SetPiece(ques, '^', 1, '1');
  if cbQues2.Checked = True then SetPiece(ques, '^', 2, '1');
  if cbQues3.Checked = True then SetPiece(ques, '^', 3, '1');
  if cbQues4.Checked = True then SetPiece(ques, '^', 4, '1');
  if cbQues5.Checked = True then SetPiece(ques, '^', 5, '1');
  if cbQues6.Checked = True then SetPiece(ques, '^', 6, '1');
  if cbQues7.Checked = True then SetPiece(ques, '^', 7, '1');
  if cbQues8.Checked = True then SetPiece(ques, '^', 8, '1');
  if cbQues9.Checked = True then SetPiece(ques, '^', 9, '1');
  if cbQues10.Checked = True then SetPiece(ques, '^', 10, '1');
  if cbQues11.Checked = True then SetPiece(ques, '^', 11, '1');
  if cbQues12.Checked = True then SetPiece(ques, '^', 12, '1');
  // srm required fields
  if cbxReq1.Checked = True then SetPiece(reqfld, '^', 1, '1');
  if cbxReq2.Checked = True then SetPiece(reqfld, '^', 2, '1');
  if cbxReq3.Checked = True then SetPiece(reqfld, '^', 3, '1');
  if cbxReq4.Checked = True then SetPiece(reqfld, '^', 4, '1');
  if cbxReq5.Checked = True then SetPiece(reqfld, '^', 5, '1');
  if cbxReq6.Checked = True then SetPiece(reqfld, '^', 6, '1');
  if cbxReq7.Checked = True then SetPiece(reqfld, '^', 7, '1');
  if cbxReq8.Checked = True then SetPiece(reqfld, '^', 8, '1');
  if cbxReq9.Checked = True then SetPiece(reqfld, '^', 9, '1');
  if cbxReq10.Checked = True then SetPiece(reqfld, '^', 10, '1');
  if cbxReq11.Checked = True then SetPiece(reqfld, '^', 11, '1');
  if cbxReq12.Checked = True then SetPiece(reqfld, '^', 12, '1');
  if cbxReq13.Checked = True then SetPiece(reqfld, '^', 13, '1');
  if cbxReq14.Checked = True then SetPiece(reqfld, '^', 14, '1');
  if cbxReq15.Checked = True then SetPiece(reqfld, '^', 15, '1');
  if cbxReq16.Checked = True then SetPiece(reqfld, '^', 16, '1');
  if cbxReq17.Checked = True then SetPiece(reqfld, '^', 17, '1');
  if cbxReq18.Checked = True then SetPiece(reqfld, '^', 18, '1');
  if cbxReq19.Checked = True then SetPiece(reqfld, '^', 19, '1');
  if cbxReq20.Checked = True then SetPiece(reqfld, '^', 20, '1');
  data  := title + '^' + color + '^' + code + '^' + abb + '^' + fac + '^' + care + '^' + IntToStr(UseSRM);
  Success := sCallV('APTWL PUT SPEC PARAM', [SpecIFN, data, lbSurg.Items, lbConsult.Items, ques, reqfld]);
  if Success = '0' then MessageDlg('Saving Parameter data was not successful.', mtwarning, [mbOK], 0);
  if Success = '1' then    // update parameters for session
    begin
      SpecAbbr  := edAbb.Text;
      SpecColor := ColorBox1.Selected;
    end;
  Close;
end;

procedure TfrmSpecParam.btnAddClick(Sender: TObject);
begin
  DisplaySurg;
  btnPos.Enabled   := False;
  btnInact.Enabled := False;
  Edit := 0;
end;


procedure TfrmSpecParam.cbTitleClick(Sender: TObject);
begin
  TitleIFN := IntToStr(cbTitle.ItemIEN);
  Change := 1;
end;

procedure TfrmSpecParam.cbSurgClick(Sender: TObject);
begin
  Change          := 1;
  SClick          := 1;
end;

procedure TfrmSpecParam.lbSurgClick(Sender: TObject);
begin
  btnInact.Enabled := True;
  btnPos.Enabled   := True;
end;

procedure TfrmSpecParam.btnInactClick(Sender: TObject);
var
  message: string;
begin
  message := 'Are you sure you want to inactivate ' + piece(lbSurg.Items[lbSurg.ItemIndex], '^', 2) + '?';
  if MessageDlg(message, mtConfirmation, [mbYes, mbNo], 0) = mrNo then Exit;
  lbSurg.Items[lbSurg.ItemIndex] := lbSurg.Items[lbSurg.ItemIndex] + '^Inactive';
  btnInact.Enabled := False;
  Change := 1;
end;

procedure TfrmSpecParam.cbTitleChange(Sender: TObject);
begin
  if cbTitle.Text = '' then
    begin
      cbTitle.DroppedDown := False;
      Exit;
    end;
  CallV('APTWL GET TITLES', [cbTitle.Text]);
  cbTitle.Items := RPCBrokerV.Results;
  TitleChange := 1;
  cbTitle.DroppedDown := True;
end;

procedure TfrmSpecParam.ColorBox1Change(Sender: TObject);
var
  Result: string;
begin
  Change := 1;
  Result := sCallV('APTWL IS COLOR USED', [ColorToString(ColorBox1.Selected)]);
  if piece(Result, '^', 1) = '1' then
    begin
      if MessageDlg('That color is being used by ' + piece(Result, '^', 2), mtwarning, [mbOK, mbIgnore], 0) = mrOK then
        begin
          ColorBox1.Selected := clWhite;
          Change := 0;
          Exit;
        end;
    end;
end;

procedure TfrmSpecParam.edAbbChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSpecParam.lbSurgChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSpecParam.btnPosClick(Sender: TObject);
begin
  DisplaySurg;
  cbSurg.Enabled   := False;
  lblSurg1.Enabled := False;
  rgPos.ItemIndex  := StrToInt(piece(lbSurg.Items[lbSurg.ItemIndex], '^', 3)) -1;
  PosTemp          := rgPos.ItemIndex;
  // set check ed item
  Edit             := 1;
  btnAdd.Enabled   := False;
  btnInact.Enabled := False;
end;

procedure TfrmSpecParam.btnColorClick(Sender: TObject);
begin
  ColorGuide;
end;

procedure TfrmSpecParam.cbSurgChange(Sender: TObject);
begin
  if cbSurg.Text = '' then
    begin
      cbSurg.DroppedDown := False;
      Exit;
    end;
  if SClick = 1 then
    begin
      SClick := 0;
      Exit;
    end;
  CallV('APTWL GET PROVIDER', ['G', SpecIFN, cbSurg.Text]);
  cbSurg.Items  := RPCBrokerV.Results;
  cbSurg.DroppedDown := True;
end;

procedure TfrmSpecParam.cbFacChange(Sender: TObject);
begin
  if cbFac.Text = '' then
    begin
      cbFac.DroppedDown := False;
      Exit;
    end;
  cbFac.DroppedDown := True;
end;

procedure TfrmSpecParam.cbCareChange(Sender: TObject);
begin
  if cbCare.Text = '' then
    begin
      cbCare.DroppedDown := False;
      Exit;
    end;
  cbCare.DroppedDown := True;
end;

procedure TfrmSpecParam.cbFacClick(Sender: TObject);
begin
  Change := 1;
  FacIFN := IntToStr(cbFac.ItemIEN);
end;

procedure TfrmSpecParam.cbCareClick(Sender: TObject);
begin
  Change  := 1;
  CareIFN := IntToStr(cbCare.ItemIEN);
end;

procedure TfrmSpecParam.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  ResetTimeOut;
end;

procedure TfrmSpecParam.cbCodeChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSpecParam.DisplaySurg;
begin
  pnlSel.Visible := True;
end;

procedure TfrmSpecParam.HideSurg;
begin
  pnlSel.Visible  := False;
  btnAdd.Enabled  := True;
  btnPos.Enabled  := False;
end;

procedure TfrmSpecParam.btnCancClick(Sender: TObject);
begin
  HideSurg;
end;

procedure TfrmSpecParam.btnOKClick(Sender: TObject);
var
  data, datax: string;
begin
  if Edit = 0 then
    begin
      if cbSurg.Text = '' then
        begin
          HideSurg;
          Exit;
        end;
      data := IntToStr(cbSurg.ItemIEN) + '^' + piece(cbSurg.Items[cbSurg.ItemIndex], '^', 2) + '^' + IntToStr(rgPos.ItemIndex + 1) + '^' + rgPos.Items[rgPos.ItemIndex];
      lbSurg.Items.Add(data);
      cbSurg.Text      := '';
    end
  else
    begin
      if rgPos.ItemIndex = PosTemp then
        begin
          HideSurg;
          Exit;
        end;
      datax := lbSurg.Items[lbSurg.ItemIndex];
      SetPiece(datax, '^', 3, IntToStr(rgPos.ItemIndex + 1));
      SetPiece(datax, '^', 4, rgPos.Items[rgPos.ItemIndex]);
      lbSurg.Items[lbSurg.ItemIndex] := datax;
    end;
  Change := 1;
  HideSurg;
end;

procedure TfrmSpecParam.btnCCancClick(Sender: TObject);
begin
  cbCSel.Text     := '';
  pnlCSel.Visible := False;
end;

procedure TfrmSpecParam.btnCAddClick(Sender: TObject);
begin
  pnlCSel.Visible := True;
end;

procedure TfrmSpecParam.lbConsultClick(Sender: TObject);
begin
  btnCInac.Enabled := True;
end;

procedure TfrmSpecParam.cbCSelClick(Sender: TObject);
var
  data: string;
begin
  data := IntToStr(cbCSel.ItemIEN) + '^' + piece(cbCSel.Items[cbCSel.ItemIndex], '^', 2);
  lbConsult.Items.Add(data);
  cbCSel.Text     := '';
  pnlCSel.Visible := False;
  Change          := 1;
end;

procedure TfrmSpecParam.btnCInacClick(Sender: TObject);
var
  message: string;
begin
  message := 'Are you sure you want to inactivate ' + piece(lbConsult.Items[lbConsult.ItemIndex], '^', 2) + '?';
  if MessageDlg(message, mtConfirmation, [mbYes, mbNo], 0) = mrNo then Exit;
  lbConsult.Items[lbConsult.ItemIndex] := lbConsult.Items[lbConsult.ItemIndex] + '^Inactive';
  btnCInac.Enabled := False;
  Change := 1;
end;

procedure TfrmSpecParam.cbxYesClick(Sender: TObject);
begin
  cbxNo.Checked := False;
  Change := 1;
  UseSRM := 1;
end;

procedure TfrmSpecParam.cbxNoClick(Sender: TObject);
begin
  cbxYes.Checked := False;
  Change := 1;
  UseSRM := 0;
end;

procedure TfrmSpecParam.btnASubClick(Sender: TObject);
begin
  DisablePGroup;
  edGroup.Text := '';
  GetSubGroup;
end;

procedure TfrmSpecParam.DisablePMenu;
begin
  btnAProc.Enabled  := False;
  btnADiag.Enabled  := False;
  btnASymp.Enabled  := False;
  btnASub.Enabled   := False;
  btnPGEdit.Enabled := False;
  btnPGDel.Enabled  := False;
end;

procedure TfrmSpecParam.EnablePMenu;
begin
  btnAProc.Enabled  := True;
  btnADiag.Enabled  := True;
  btnASymp.Enabled  := True;
  btnASub.Enabled   := True;
  btnPGEdit.Enabled := True;
  btnPGDel.Enabled  := True;
end;

procedure TfrmSpecParam.btnPGAddClick(Sender: TObject);
begin
  lblPGEdit.Caption := 'Enter Group Name:';
  PEdit := 0;
  edGroup.Text := '';
  EnablePGroup;
  DisablePMenu;
  edGroup.SetFocus;
end;

procedure TfrmSpecParam.btnGOKClick(Sender: TObject);
var
  success: string;
begin
  if edGroup.Text = '' then
    begin
      DisablePGroup;
      Exit;
    end;
  if PEdit = 1 then
    begin
      if PChange = 0 then
        begin
          DisablePGroup;
          Exit;
        end;
      CallV('APTWL EDIT SPEC PROC GRP', [SpecIFN, GroupIFN, edGroup.Text]);
      RefreshGroupList;
      PEdit   := 0;
      PChange := 0;
    end
  else
    begin
      success := sCallV('APTWL PUT SPEC PROC GRP', [SpecIFN, edGroup.Text, lbGroup.Items]);
      RefreshGroupList;
      lbGroup.ItemIndex := StrToInt(success);
    end;
  edGroup.Text := '';
  DisablePGroup;
  DisableGMenu;
  btnGOK.Default := False;
end;

procedure TfrmSpecParam.lbGroupClick(Sender: TObject);
begin
  if lbGroup.Items.Count = 0 then Exit;
  btnPGEdit.Enabled := True;
  btnPGDel.Enabled  := True;
  btnUp.Enabled     := True;
  btnDown.Enabled   := True;
  EnablePMenu;
  GroupName  := piece(lbGroup.Items[lbGroup.ItemIndex], '^', 2);
  GroupIFN   := IntToStr(lbGroup.ItemIEN);
  SGroupIFN  := '';
  SGroupName := '';
  GroupType  := 'G';
end;

procedure TfrmSpecParam.btnPGEditClick(Sender: TObject);
begin
  lblPGEdit.Caption := 'Edit Group Name:';
  edGroup.Text := piece(lbGroup.Items[lbGroup.ItemIndex], '^', 2);
  EnablePGroup;
  DisablePMenu;
  PEdit := 1;
  edGroup.SetFocus;
end;

procedure TfrmSpecParam.pcParamChange(Sender: TObject);
var
  Param: string;
begin
  if pcParam.ActivePage = TabSheet4 then
    begin
      PEdit   := 0;
      PChange := 0;
      DisablePMenu;
      DisablePGroup;
      DisableGMenu;
    end;
  if pcParam.ActivePage = TabSheet5 then
    begin
      Param := sCallV('APTWL GET SRM QUESTION', [SpecIFN]);
      if piece(Param, '^', 1) = '1' then cbQues1.Checked := True;
      if piece(Param, '^', 2) = '1' then cbQues2.Checked := True;
      if piece(Param, '^', 3) = '1' then cbQues3.Checked := True;
      if piece(Param, '^', 4) = '1' then cbQues4.Checked := True;
      if piece(Param, '^', 5) = '1' then cbQues5.Checked := True;
      if piece(Param, '^', 6) = '1' then cbQues6.Checked := True;
      if piece(Param, '^', 7) = '1' then cbQues7.Checked := True;
      if piece(Param, '^', 8) = '1' then cbQues8.Checked := True;
      if piece(Param, '^', 9) = '1' then cbQues9.Checked := True;
      if piece(Param, '^', 10) = '1' then cbQues10.Checked := True;
      if piece(Param, '^', 11) = '1' then cbQues11.Checked := True;
      if piece(Param, '^', 12) = '1' then cbQues12.Checked := True;
    end;
  if pcParam.ActivePage = TabSheet6 then
    begin
      Param := sCallV('APTWL GET SRM REQUIRED', [SpecIFN]);
      if piece(Param, '^', 1) = '1' then cbxReq1.Checked := True;
      if piece(Param, '^', 2) = '1' then cbxReq2.Checked := True;
      if piece(Param, '^', 3) = '1' then cbxReq3.Checked := True;
      if piece(Param, '^', 4) = '1' then cbxReq4.Checked := True;
      if piece(Param, '^', 5) = '1' then cbxReq5.Checked := True;
      if piece(Param, '^', 6) = '1' then cbxReq6.Checked := True;
      if piece(Param, '^', 7) = '1' then cbxReq7.Checked := True;
      if piece(Param, '^', 8) = '1' then cbxReq8.Checked := True;
      if piece(Param, '^', 9) = '1' then cbxReq9.Checked := True;
      if piece(Param, '^', 10) = '1' then cbxReq10.Checked := True;
      if piece(Param, '^', 11) = '1' then cbxReq11.Checked := True;
      if piece(Param, '^', 12) = '1' then cbxReq12.Checked := True;
      if piece(Param, '^', 13) = '1' then cbxReq13.Checked := True;
      if piece(Param, '^', 14) = '1' then cbxReq14.Checked := True;
      if piece(Param, '^', 15) = '1' then cbxReq15.Checked := True;
      if piece(Param, '^', 16) = '1' then cbxReq16.Checked := True;
      if piece(Param, '^', 17) = '1' then cbxReq17.Checked := True;
      if piece(Param, '^', 18) = '1' then cbxReq18.Checked := True;
      if piece(Param, '^', 19) = '1' then cbxReq19.Checked := True;
      if piece(Param, '^', 20) = '1' then cbxReq20.Checked := True;
    end;
end;

procedure TfrmSpecParam.btnPGDelClick(Sender: TObject);
var
  Result: string;
begin
  edGroup.Text := '';
  DisablePMenu;
  Result := sCallV('APTWL GRP HAS CHILD', [SpecIFN, GroupIFN]);
  if Result <> '' then MessageDlg('This Group has ' + Result, mtinformation, [mbOK],0);
  if MessageDlg('Are you sure you want to delete ' + piece(lbGroup.Items[lbGroup.ItemIndex], '^', 2), mtwarning, [mbYes,mbNo],0) = mrYes then
    begin
      CallV('APTWL DEL SPEC PROC GRP', [SpecIFN, GroupIFN]);
      RefreshGroupList;
    end;
  DisablePGroup;
  DisableGMenu;
end;

procedure TfrmSpecParam.DisablePGroup;
begin
  pnlGroup.Enabled  := False;
  lblPGEdit.Enabled := False;
  edGroup.Enabled   := False;
  btnGOK.Enabled    := False;
end;

procedure TfrmSpecParam.EnablePGroup;
begin
  pnlGroup.Enabled  := True;
  lblPGEdit.Enabled := True;
  edGroup.Enabled   := True;
  btnGOK.Enabled    := True;
end;
procedure TfrmSpecParam.btnAProcClick(Sender: TObject);
begin
  DisablePGroup;
  edGroup.Text := '';
  GetProcedures;
end;

procedure TfrmSpecParam.btnADiagClick(Sender: TObject);
begin
  DisablePGroup;
  edGroup.Text := '';
  GetDiagnosis;
end;

procedure TfrmSpecParam.edGroupChange(Sender: TObject);
begin
  PChange := 1;
  btnGOK.Default := True;
end;

procedure TfrmSpecParam.lbGroupChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSpecParam.btnASympClick(Sender: TObject);
begin
  DisablePGroup;
  edGroup.Text := '';
  GetSymptom;
end;

procedure TfrmSpecParam.RefreshGroupList;
begin
  CallV('APTWL GET SPEC PROC GRP', [SpecIFN]);
  lbGroup.Items := RPCBrokerV.Results;
end;

procedure TfrmSpecParam.btnATreeClick(Sender: TObject);
begin
  DisplayTree;
end;

procedure TfrmSpecParam.cbQues1Click(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSpecParam.cbQues2Click(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSpecParam.cbQues3Click(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSpecParam.cbQues4Click(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSpecParam.cbQues5Click(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSpecParam.cbQues6Click(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSpecParam.cbQues7Click(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSpecParam.cbQues8Click(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSpecParam.cbQues9Click(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSpecParam.DisableGMenu;
begin
  btnPGEdit.Enabled := False;
  btnPGDel.Enabled  := False;
  btnPGAdd.Enabled  := True;
end;

procedure TfrmSpecParam.btnUpClick(Sender: TObject);
begin
  New := lbGroup.ItemIndex - 1;
  SaveGList;
end;

procedure TfrmSpecParam.btnDownClick(Sender: TObject);
begin
  New := lbGroup.ItemIndex + 1;
  SaveGList;
end;

procedure TfrmSpecParam.SaveGList;
begin
  lbGroup.Items.Move(lbGroup.ItemIndex, New);
  lbGroup.ItemIndex := New;
  CallV('APTWL PUT SPEC GRP LST', [SpecIFN, lbGroup.Items]);
end;

procedure TfrmSpecParam.cbxReq1Click(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSpecParam.cbxReq2Click(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSpecParam.cbxReq3Click(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSpecParam.cbxReq4Click(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSpecParam.cbxReq5Click(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSpecParam.cbxReq6Click(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSpecParam.cbxReq7Click(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSpecParam.cbxReq8Click(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSpecParam.cbxReq9Click(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSpecParam.cbxReq10Click(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSpecParam.cbxReq11Click(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSpecParam.cbxReq12Click(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSpecParam.cbxReq13Click(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSpecParam.cbxReq14Click(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSpecParam.cbxReq15Click(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSpecParam.cbxReq16Click(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSpecParam.cbxReq17Click(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSpecParam.cbxReq18Click(Sender: TObject);
begin
  Change := 1;
end;

end.
