unit fOutput;
// ptld/jit  6-25-08  delimited output for excel

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ORFn, ORNet, ORCtrls;

type
  TfrmOutput = class(TForm)
    memOutput: TMemo;
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmOutput: TfrmOutput;

procedure DelimitedOutput(lstTemp: TORListBox; Title: string);

implementation

{$R *.dfm}

uses fGenPrint;

procedure DelimitedOutput(lstTemp: TORListBox; Title: string);
var
  I, char: integer;
  node: string;
begin
  frmOutput := TfrmOutput.Create(Application);
  try
    with frmOutput do
      begin
        char := 0;
        memOutput.Lines.Add(';' + Title);
        for I := 0 to lstTemp.Items.Count -1 do
          begin
            node := lstTemp.Items[I];
            if length(node) > char then char := length(node);
            memOutput.Lines.Add(node);
          end;
        Width := (char * 6) + 60;
        ShowModal;
      end;
  finally
    frmOutput.Release;
  end;
end;


end.
