unit fOps;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ORCtrls, ORNet, ORFn, Buttons, ExtCtrls;

type
  TfrmOps = class(TForm)
    lbOps: TORListBox;
    cbReas: TORComboBox;
    cbRel: TORComboBox;
    memComm: TMemo;
    lblReas: TLabel;
    lblRel: TLabel;
    lblComm: TLabel;
    lblDate: TLabel;
    lblProc: TLabel;
    btnExit: TBitBtn;
    lstSelect: TORListBox;
    btnMove: TBitBtn;
    Bevel1: TBevel;
    lblPat: TLabel;
    procedure lbOpsClick(Sender: TObject);
    procedure btnExitClick(Sender: TObject);
    procedure cbReasChange(Sender: TObject);
    procedure cbRelChange(Sender: TObject);
    procedure memCommChange(Sender: TObject);
    procedure cbReasClick(Sender: TObject);
    procedure cbRelClick(Sender: TObject);
    procedure lstSelectChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    fmrOps: TfrmOps;
  end;

var
  frmOps: TfrmOps;
  dispkey, Change: integer;
  SelectCase, ReasIFN, RelIFN, SelIFN: string;

procedure OpsList(key: integer; TempList: TListBox);

implementation

uses SCMMain, fRequest, fSched, uCore, fEditReq;

{$R *.dfm}

procedure OpsList(key: integer; TempList: TListBox);
var
  Data: string;
begin
  frmOps := TfrmOps.Create(Application);
  try
  with frmOps do
    begin
      lbOps.Items.Clear;
      if key < 3 then Left := frmRequest.Left + frmRequest.pnl1.Width + frmRequest.lblRet.Left + 8;
      if key = 1 then
        begin
          Top  := frmRequest.Top + frmRequest.lblRet.Top +60;
          Caption := 'Select Prior Case';
          CallV('APTWL GET OPS LIST', [PtIFN]);
          lbOps.Items := RPCBrokerV.Results;
        end;
      if key = 2 then
        begin
          Top  := frmRequest.Top + frmRequest.lblCon.Top +60;
          Caption := 'Select Concurrent Case';
          lblDate.Caption := 'Specialty';
          CallV('APTWL GET REQ LIST', [SpecIFN, PtIFN, frmRequest.dbDate.FMDateTime, opcase]);
          lbOps.Items := RPCBrokerV.Results;
        end;
      if key = 3 then
        begin
          Left    := frmSched.Left + frmEditReq.Left + 225;
          Caption := 'Select Concurrent Case';
          lblDate.Caption := 'Specialty';
          CallV('APTWL GET REQ LIST', [SpecIFN, 1, frmSched.dbSurg.FMDateTime, SchedCase]);
          lbOps.Items := RPCBrokerV.Results;
        end;
      if key < 3 then lblPat.Caption := PtName
      else lblPat.Caption := SchedPt;
      lstSelect.Clear;
      memComm.Clear;
      SelectCase := '0';
      dispkey    := key;
      Change     := 0;
      lstSelect.Visible := False;
      cbReas.Visible    := False;
      lblReas.Visible   := False;
      cbRel.Visible     := False;
      lblRel.Visible    := False;
      memComm.Visible   := False;
      lblComm.Visible   := False;
      btnMove.Visible   := False;
      if TempList.Items.Count >0 then
        begin
          Data := TempList.Items[0];
          lstSelect.Items.Add(piece(Data, '^', 3) + '^' + piece(Data, '^', 4) + '^' + piece(Data, '^', 5));
          SelIFN      := piece(Data, '^', 3);
          cbReas.Text := piece(Data, '^', 7);
          ReasIFN     := piece(Data, '^', 6);
          cbRel.Text  := piece(Data, '^', 9);
          RelIFN      := piece(Data, '^', 8);
          if piece(Data, '^', 10) <> '' then memComm.Lines.Add(piece(Data, '^', 10));
        end;
      ShowModal;
    end;
  finally
    frmOps.Release;
  end;
end;

procedure TfrmOps.lbOpsClick(Sender: TObject);
// returned   - dispkey = 1
// concurrent - dispkey = 2
begin
  if lbOps.ItemIEN = 0 then Exit;
  SelIFN := IntToStr(lbOps.ItemIEN);
  if dispkey = 1 then
    begin
      lstSelect.Visible := True;
      cbReas.Visible    := True;
      lblReas.Visible   := True;
      cbRel.Visible     := True;
      lblRel.Visible    := True;
      memComm.Visible   := True;
      lblComm.Visible   := True;
      btnMove.Visible   := True;
      lstSelect.Items.Add(lbOps.Items[lbOps.ItemIndex]);
    end;
  if dispkey = 2 then
    begin
      SelectCase := '1^' + IntToStr(lbOps.ItemIEN) + '^' + piece(lbOps.Items[lbOps.ItemIndex], '^', 2) + '^' + piece(lbOps.Items[lbOps.ItemIndex], '^', 3);
      Close;
    end;
end;

procedure TfrmOps.btnExitClick(Sender: TObject);
begin
  if Change = 0 then dispkey := 0;
  if dispkey = 1 then
    begin
      SelectCase := '1^' + SelIFN + '^' + ReasIFN + '^' + RelIFN +
        '^' + memComm.Lines[0] + '^' + memComm.Lines[1];
    end;
  if dispkey = 2 then SelectCase := '1^' + SelIFN;
  Close;
end;

procedure TfrmOps.cbReasChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmOps.cbRelChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmOps.memCommChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmOps.cbReasClick(Sender: TObject);
begin
  ReasIFN := cbReas.ItemID;
end;

procedure TfrmOps.cbRelClick(Sender: TObject);
begin
  RelIFN := cbRel.ItemID;
end;

procedure TfrmOps.lstSelectChange(Sender: TObject);
begin
  Change := 1;
end;

end.
