unit fMAG;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids, ORCtrls, StdCtrls, ComCtrls, ORNet, ORFn, Menus, ExtCtrls;

type
  TfrmMAG = class(TForm)
    stgrCal: TCaptionStringGrid;
    btnCurr: TButton;
    HeaderControl1: THeaderControl;
    lbTemp: TORListBox;
    btnPrev: TButton;
    btnNext: TButton;
    pmCal: TPopupMenu;
    Details1: TMenuItem;
    AddNote1: TMenuItem;
    timMAG: TTimer;
    pnlKey: TPanel;
    lblReq: TLabel;
    lblSched: TLabel;
    lblProg: TLabel;
    lblComp: TLabel;
    lblUns: TLabel;
    lblNote: TLabel;
    btnClose: TButton;
    pnlDetail: TPanel;
    lblHdr: TLabel;
    lbDetail: TORListBox;
    btnExit: TButton;
    btnDet: TButton;
    btnAud: TButton;
    pnlNote: TPanel;
    memNote: TMemo;
    btnSave: TButton;
    lblSNote: TLabel;
    btnNClose: TButton;
    procedure FillCalendar;
    procedure btnCurrClick(Sender: TObject);
    procedure btnPrevClick(Sender: TObject);
    procedure btnNextClick(Sender: TObject);
    procedure stgrCalMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Refresh(Month: string);
    procedure timMAGTimer(Sender: TObject);
    procedure btnCloseClick(Sender: TObject);
    procedure btnExitClick(Sender: TObject);
    procedure Details1Click(Sender: TObject);
    procedure stgrCalClick(Sender: TObject);
    procedure lbDetailClick(Sender: TObject);
    procedure btnDetClick(Sender: TObject);
    procedure btnAudClick(Sender: TObject);
    procedure memNoteChange(Sender: TObject);
    procedure AddNote1Click(Sender: TObject);
    procedure btnNCloseClick(Sender: TObject);
    procedure btnSaveClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmMAG: TfrmMAG;
  CalMonth, BlockData, MonthKey, Header: string;

procedure Calendar;

implementation

{$R *.dfm}

uses SCMMain, fRptBox;

procedure Calendar;
begin
  frmMAG := TfrmMAG.Create(Application);
  try
    with frmMAG do
    begin
      MonthKey := 'C';
      ShowModal;
    end;
  finally
    frmMAG.Release;
  end;
end;

procedure TfrmMAG.FillCalendar;
var
  Cell: TRect;
  xcoord, ycoord, ACol, ARow: integer;
  Block, ID, glw, J, x, y: integer;
  Day, Data, Holiday, Info, IType, IName: string;
begin
  for Block := 0 to 41 do
    begin
      Data := lbTemp.Items[Block];
      Day  := piece(Data, '^', 1);
      ID   := StrToInt(piece(Data, '^', 2));
      if ID = 3 then Holiday := piece(Data, '^', 3);
      stgrCal.Canvas.Brush.Style := bsSolid;
      stgrCal.Canvas.Font.Color := clBlack;
      stgrCal.Canvas.Font.Size  := 16;
      if ID = 0 then    // day in previous or next month
        begin
          stgrCal.Canvas.Brush.Color := clCream;
          stgrCal.Canvas.Font.Color  := clMedGray;
        end;
      if ID = 1 then    // day in current month
        begin
          stgrCal.Canvas.Brush.Color := clWindow;
          stgrCal.Canvas.Font.Color  := clWindowText;
        end;
      //  day is current day
      if ID = 2 then stgrCal.Canvas.Brush.Color := clMoneyGreen;
      //  day is a holiday
      if ID = 3 then stgrCal.Canvas.Brush.Color := clSkyBlue;
      if (Block = 0) or (Block < 7) then
        begin
          ACol := Block;
          ARow := 0;
        end;
      if (Block > 6) and (Block < 14) then
        begin
          ACol := Block - 7;
          ARow := 1;
        end;
      if (Block > 13) and (Block < 21) then
        begin
          ACol := Block - 14;
          ARow := 2;
        end;
      if (Block > 20) and (Block < 28) then
        begin
          ACol := Block - 21;
          ARow := 3;
        end;
      if (Block > 27) and (Block < 35) then
        begin
          ACol := Block - 28;
          ARow := 4;
        end;
      if (Block > 34) and (Block < 42) then
        begin
          ACol := Block - 35;
          ARow := 5;
        end;
      Cell := stgrCal.CellRect(ACol, ARow);
      stgrCal.Canvas.FillRect(Cell);
      glw := stgrCal.GridLineWidth;
      xcoord := ACol * (stgrCal.DefaultColWidth + glw) + 2;
      ycoord := ARow * (stgrCal.DefaultRowHeight + glw);
      stgrCal.Canvas.TextOut(xcoord, ycoord, Day);
      if ID = 3 then
        begin
          if length(Day) = 1 then x := xcoord + 12;
          if length(Day) = 2 then x := xcoord + 32;
          stgrCal.Canvas.Font.Size := 4;
          stgrCal.Canvas.TextOut(x, ycoord, Holiday);
        end;
      ycoord := ycoord + 20;
      for J := 4 to 12 do
        begin
          Info  := piece(Data, '^', J);
          if Info <> '' then
            begin
              IType := piece(Info, ':', 1);
              IName  := piece(Info, ':', 2);
              stgrCal.Canvas.Font.Size := 8;
              if IType = 'R' then stgrCal.Canvas.Font.Color := clBlue;
              if IType = 'P' then
                begin
                  stgrCal.Canvas.Font.Color := clRed;
                  stgrCal.Canvas.Font.Style := [fsBold];
                end;
              if IType = 'S' then stgrCal.Canvas.Font.Color := clOlive;
              if IType = 'C' then stgrCal.Canvas.Font.Color := clGreen;
              if IType = 'U' then stgrCal.Canvas.Font.Color := clPurple;
              if IType = 'N' then
                begin
                  stgrCal.Canvas.Font.Color := clBlack;
                  stgrCal.Canvas.Font.Style := [fsBold];
                end;
              y := ycoord + ((J-4) * 12);
              stgrCal.Canvas.TextOut(xcoord, y, IName);
              stgrCal.Canvas.Font.Style := []; // reset
            end;
        end;
    end;
  frmMAG.Caption := 'Month-at-a-Glance for ' + SpecName + ', ' + lbTemp.Items[42];
end;

procedure TfrmMAG.btnCurrClick(Sender: TObject);
begin
  Refresh('C');
  MonthKey := 'C';
end;

procedure TfrmMAG.btnPrevClick(Sender: TObject);
begin
  Refresh('P');
  MonthKey := 'P';
end;

procedure TfrmMAG.btnNextClick(Sender: TObject);
begin
  Refresh('N');
  MonthKey := 'N';
end;

procedure TfrmMAG.stgrCalMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var
  coord: TGridCoord;
  ACol, ARow, Block: integer;
begin
  coord := stgrCal.MouseCoord(x, y);
  ACol  := coord.x;
  ARow  := coord.y;
  Block := ACol + (ARow * 7);
  BlockData := lbTemp.Items[Block];
  Header := piece(lbTemp.Items[42], ' ', 1) + ' ' + piece(BlockData, '^', 1) + ', ' + piece(lbTemp.Items[42], ' ', 2) + '     ' + SpecName;
end;

procedure TfrmMAG.Refresh(Month: string);
begin
  CallV('APTWL GET CALENDAR', [SpecIFN, Month]);
  lbTemp.Items := RPCBrokerV.Results;
  FillCalendar;
end;

procedure TfrmMAG.timMAGTimer(Sender: TObject);
begin
  Refresh(MonthKey);
  timMAG.Enabled := False;
end;

procedure TfrmMAG.btnCloseClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmMAG.btnExitClick(Sender: TObject);
begin
  pnlDetail.Visible := False;
  timMAG.Enabled := True;
end;

procedure TfrmMAG.Details1Click(Sender: TObject);
begin
  CallV('APTWL GET CALENDAR DETAILS', [BlockData]);
  lbDetail.Items := RPCBrokerV.Results;
  lblHdr.Caption := 'Expanded List ' + Header;
  pnlDetail.Visible := True;
end;

procedure TfrmMAG.stgrCalClick(Sender: TObject);
begin
  timMAG.Enabled := True;
end;

procedure TfrmMAG.lbDetailClick(Sender: TObject);
begin
  btnDet.Enabled := True;
  btnAud.Enabled := True;
end;

procedure TfrmMAG.btnDetClick(Sender: TObject);
var
  OpID: integer;
begin
  OpID := lbDetail.ItemIEN;
  CallV('APTWL GET REQ DETAIL', [OpID, 'R']);
  ReportBox(RPCBrokerV.Results, 'Case Detail for ' + piece(lbDetail.Items[lbDetail.ItemIndex], '^', 3), True);
  timMAG.Enabled := True;
end;

procedure TfrmMAG.btnAudClick(Sender: TObject);
var
  OpID: integer;
begin
  OpID := lbDetail.ItemIEN;
  CallV('APTWL GET AUDIT', [SpecIFN, OpID, 'R']);
  ReportBox(RPCBrokerV.Results, 'Audit Trail for ' + piece(lbDetail.Items[lbDetail.ItemIndex], '^', 3), True);
  timMag.Enabled := True;
end;

procedure TfrmMAG.memNoteChange(Sender: TObject);
begin
  btnSave.Enabled := True;
end;

procedure TfrmMAG.AddNote1Click(Sender: TObject);
begin
  lblSNote.Caption := 'Scheduling Notes - ' + Header;
  pnlNote.Visible := True;
  CallV('APTWL GET SCHED NOTE', [BlockData, SpecIFN]);
  memNote.Lines := RPCBrokerV.Results;
end;

procedure TfrmMAG.btnNCloseClick(Sender: TObject);
begin
  pnlNote.Visible := False;
  timMAG.Enabled  := True;
end;

procedure TfrmMAG.btnSaveClick(Sender: TObject);
var
  success: string;
begin
  success := sCallV('APTWL PUT SCHED NOTE', [SpecIFN, BlockData, memNote.Lines]);
  pnlNote.Visible := False;
  timMAG.Enabled  := True;
end;

end.
