unit fFindPt;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls, ORCtrls, ORNet, ORFn;

type
  TfrmFindPt = class(TForm)
    cbFindPt: TORComboBox;
    lblFindPt: TLabel;
    lbFindPt: TORListBox;
    HeaderControl1: THeaderControl;
    btnExit: TButton;
    lblPNM: TLabel;
    procedure cbFindPtClick(Sender: TObject);
    procedure cbFindPtChange(Sender: TObject);
    procedure btnExitClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmFindPt: TfrmFindPt;

procedure FindPatient;

implementation

{$R *.dfm}

uses SCMMain, rLocal, uCore;

procedure FindPatient;
begin
  frmFindPt := TfrmFindPt.Create(Application);
  try
  with frmFindPt do
    begin
      CallV('APTWL GET PATIENTS', ['A']);
      cbFindPt.Items := RPCBrokerV.Results;
      ShowModal;
    end;
  finally
    frmFindPt.Release;
  end;
end;

procedure TfrmFindPt.cbFindPtClick(Sender: TObject);
begin
  CallV('APTWL GET PATIENT CASES', [cbFindPt.ItemIEN]);
  lbFindPt.Items := RPCBrokerV.Results;
  lblPNM.Visible := True;
  lblPNM.Caption := cbFindPt.Text;
end;

procedure TfrmFindPt.cbFindPtChange(Sender: TObject);
begin
  if cbFindPt.Text = '' then
    begin
      cbFindPt.DroppedDown := False;
      Exit;
    end;
  //if length(cbFindPt.Text) < 2 then Exit;
  CallV('APTWL GET PATIENTS', [cbFindPt.Text]);
  cbFindPt.Items := RPCBrokerV.Results;
  if cbFindPt.Items.Count = 0 then Exit;
  cbFindPt.DroppedDown := True;
end;

procedure TfrmFindPt.btnExitClick(Sender: TObject);
begin
  Close;
end;

end.
