unit fFindCon;
//  jit/ptld   1-30-08

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ORNet, ORFn, StdCtrls, ORCtrls, ComCtrls, ExtCtrls;

type
  TfrmFindCon = class(TForm)
    lbFConsult: TORListBox;
    lblFConsult: TLabel;
    btnFConsult: TButton;
    hcFConsult: THeaderControl;
    pnlMenu: TPanel;
    btnFDet: TButton;
    btnFSel: TButton;
    lbFTemp: TORListBox;
    lbFSelect: TORListBox;
    procedure lbFConsultClick(Sender: TObject);
    procedure btnFDetClick(Sender: TObject);
    procedure btnFSelClick(Sender: TObject);
    procedure btnFConsultClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmFindCon: TfrmFindCon;
  ConIFN: string;

procedure FindConsult(Spec: integer);

implementation

{$R *.dfm}

uses SCMMain, uCore, fRptBox;

procedure FindConsult(Spec: integer);
begin
  frmFindCon := TfrmFindCon.Create(Application);
  try
  with frmFindCon do
    begin
      CallV('APTWL GET CONSULTS FOR SPEC', [SpecIFN, Patient.DFN]);
      lbFConsult.Items := RPCBrokerV.Results;
      if lbFConsult.Items.Count = 0 then
        begin
          lbFSelect.Items.Add('0');
          Exit;
        end;
      Caption := Specname + ' Consults for ' + Patient.Name;
      ConIFN := '0';
      ShowModal;
    end;
  finally
    frmFindCon.Release;
  end;
end;

procedure TfrmFindCon.lbFConsultClick(Sender: TObject);
begin
  btnFDet.Enabled := True;
  btnFSel.Enabled := True;
  ConIFN := IntToStr(lbFConsult.ItemIEN);
end;

procedure TfrmFindCon.btnFDetClick(Sender: TObject);
begin
  CallV('ORWCS REPORT TEXT', [DFN, ConIFN]);
  lbFTemp.Items := RPCBrokerV.Results;
  ReportBox(lbFTemp.Items, 'Consult Details for ' + PtName, False);
end;

procedure TfrmFindCon.btnFSelClick(Sender: TObject);
begin
  lbFSelect.Items.Clear;
  lbFSelect.Items.Add(ConIFN);
end;

procedure TfrmFindCon.btnFConsultClick(Sender: TObject);
begin
  if lbFSelect.Items.Count = 0 then lbFSelect.Items.Add('0');
  Close;
end;

end.
