unit fDiagnosis;
//  ptld/jit   6-6-08

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ORCtrls, StdCtrls, ExtCtrls, ORNet, ORFn, Buttons;

type
  TfrmDiagnosis = class(TForm)
    lbDiag: TORListBox;
    lblDiag: TLabel;
    btnDAdd: TButton;
    btnDEdit: TButton;
    btnDDel: TButton;
    btnDExit: TButton;
    pnlDiag: TPanel;
    lblDiag1: TLabel;
    cbDiag: TORComboBox;
    btnOK: TButton;
    btnDown: TBitBtn;
    btnUp: TBitBtn;
    procedure btnDExitClick(Sender: TObject);
    procedure cbDiagChange(Sender: TObject);
    procedure cbDiagClick(Sender: TObject);
    procedure btnDAddClick(Sender: TObject);
    procedure DisableSel;
    procedure EnableSel;
    procedure btnDEditClick(Sender: TObject);
    procedure btnDDelClick(Sender: TObject);
    procedure edDiagChange(Sender: TObject);
    procedure btnOKClick(Sender: TObject);
    procedure lbDiagClick(Sender: TObject);
    procedure RefreshDiagList;
    procedure DisableDMenu;
    procedure btnDownClick(Sender: TObject);
    procedure btnUpClick(Sender: TObject);
    procedure SaveDList;
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmDiagnosis: TfrmDiagnosis;
  DChange, DEdit, New: integer;
  DiagIFN, DiagName, ICDIFN: string;

procedure GetDiagnosis;

implementation

{$R *.dfm}

uses fParam, SCMMain, fSubGroup;

procedure GetDiagnosis;
begin
  frmDiagnosis := TfrmDiagnosis.Create(Application);
  try
  with frmDiagnosis do
    begin
      if GroupType = 'S' then lblDiag.Caption := 'Diagnoses for SubGroup ' + SGroupName
      else lblDiag.Caption := 'Diagnoses for ' + GroupName;
      RefreshDiagList;
      CallV('APTWL GET DIAG', []);
      cbDiag.Items := RPCBrokerV.Results;
      DChange := 0;
      DEdit  := 0;
      DisableSel;
      DisableDMenu;
      ShowModal;
    end;
  finally
    frmDiagnosis.Release;
  end;
end;

procedure TfrmDiagnosis.btnDExitClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmDiagnosis.cbDiagChange(Sender: TObject);
begin
  if cbDiag.Text = '' then
    begin
      cbDiag.DroppedDown := False;
      Exit;
    end;
  if length(cbDiag.Text) <3 then Exit;
  cbDiag.Items.Clear;
  CallV('APTWL GET DIAG', [cbDiag.Text]);
  cbDiag.Items := RPCBrokerV.Results;
  cbDiag.DroppedDown := True;
  btnOK.Default := True;
  DChange := 1;
end;

procedure TfrmDiagnosis.cbDiagClick(Sender: TObject);
begin
  ICDIFN   := IntToStr(cbDiag.ItemIEN);
  DiagName := cbDiag.Text;
end;

procedure TfrmDiagnosis.btnDAddClick(Sender: TObject);
begin
  EnableSel;
  DEdit := 0;
  cbDiag.Text := '';
  ICDIFN := '';
  cbDiag.SetFocus;
end;

procedure TfrmDiagnosis.DisableSel;
begin
  pnlDiag.Enabled  := False;
  lblDiag1.Enabled := False;
  cbDiag.Enabled   := False;
  btnOK.Enabled    := False;
end;

procedure TfrmDiagnosis.EnableSel;
begin
  pnlDiag.Enabled  := True;
  lblDiag1.Enabled := True;
  cbDiag.Enabled   := True;
  btnOK.Enabled    := True;
end;

procedure TfrmDiagnosis.btnDEditClick(Sender: TObject);
begin
  EnableSel;
  DEdit            := 1;
  cbDiag.Text      := piece(lbDiag.Items[lbDiag.ItemIndex], '^', 2);
  cbDiag.SetFocus;
end;

procedure TfrmDiagnosis.btnDDelClick(Sender: TObject);
begin
  cbDiag.Text := '';
  if MessageDlg('Are you sure you want to delete ' + piece(lbDiag.Items[lbDiag.ItemIndex], '^', 2), mtInformation, [mbYes,mbNo],0) = mrYes then
    begin
      CallV('APTWL DEL SPEC GRP DIAG', [SpecIFN, GroupIFN, SGroupIFN, DiagIFN]);
      RefreshDiagList;
    end;
  DisableSel;
  DisableDMenu;
end;

procedure TfrmDiagnosis.edDiagChange(Sender: TObject);
begin
  DChange := 1;
end;

procedure TfrmDiagnosis.btnOKClick(Sender: TObject);
begin
  if cbDiag.Text = '' then
    begin
      DisableSel;
      Exit;
    end;
  if DEdit = 1 then
    begin
      if DChange = 0 then
        begin
          DisableSel;
          Exit;
        end;
      CallV('APTWL EDIT SPEC GRP DIAG', [SpecIFN, GroupIFN, SGroupIFN, DiagIFN, ICDIFN]);
      RefreshDiagList;
      DEdit  := 0;
      DChange := 0;
      cbDiag.Text := '';
    end
  else
    begin
      CallV('APTWL PUT SPEC GRP DIAG', [SpecIFN, GroupIFN, SGroupIFN, ICDIFN]);
      RefreshDiagList;
      cbDiag.Text := '';
    end;
  DisableSel;
  DisableDMenu;
  btnOK.Default := False;
end;

procedure TfrmDiagnosis.lbDiagClick(Sender: TObject);
begin
  if lbDiag.Items.Count = 0 then Exit;
  DiagIFN          := IntToStr(lbDiag.ItemIEN);
  ICDIFN           := piece(lbDiag.Items[lbDiag.ItemIndex], '^', 3);
  btnDEdit.Enabled := True;
  btnDDel.Enabled  := True;
  btnUp.Enabled    := True;
  btnDown.Enabled  := True;
end;

procedure TfrmDiagnosis.RefreshDiagList;
begin
  if GroupType = 'G' then CallV('APTWL GET SPEC GRP DIAG', [SpecIFN, GroupIFN])
  else CallV('APTWL GET SPEC SGRP DIAG', [SpecIFN, GroupIFN, SGroupIFN]);
  lbDiag.Items := RPCBrokerV.Results;
end;

procedure TfrmDiagnosis.DisableDMenu;
begin
  btnDEdit.Enabled := False;
  btnDDel.Enabled  := False;
  btnDAdd.Enabled  := True;
end;

procedure TfrmDiagnosis.btnDownClick(Sender: TObject);
begin
  New := lbDiag.ItemIndex + 1;
  SaveDlist;
end;

procedure TfrmDiagnosis.btnUpClick(Sender: TObject);
begin
  New := lbDiag.ItemIndex - 1;
  SaveDList;
end;

procedure TfrmDiagnosis.SaveDList;
begin
  lbDiag.Items.Move(lbDiag.ItemIndex, New);
  lbDiag.ItemIndex := New;
  if SGroupIFN = '' then CallV('APTWL PUT SPEC PROC LST', [SpecIFN, GroupIFN, 4, lbDiag.Items])
  else CallV('APTWL PUT SPEC PROC SG LST', [SpecIFN, GroupIFN, SGroupIFN, 3, lbDiag.Items]);
end;

end.
