unit fDelay;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, ExtCtrls, ORFn, ORNet;

type
  TfrmDelay = class(TForm)
    pnlDelay: TPanel;
    lblDelay: TLabel;
    lblReas: TLabel;
    lblCheck: TLabel;
    lblDays: TLabel;
    edDelay: TEdit;
    edCheck: TEdit;
    updnCheck: TUpDown;
    btnOK: TButton;
    btnCanc: TButton;
    cbDelay: TCheckBox;
  procedure btnOKClick(Sender: TObject);
  procedure btnCancClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmDelay: TfrmDelay;
  ListType, DelayID, DFlag: string;

procedure PatientDelay(List: string; ID: integer; Flag: string);

implementation

{$R *.dfm}

uses SCMMain, uCore;

procedure PatientDelay(List: string; ID: integer; Flag: string);
begin
  frmDelay := TfrmDelay.Create(Application);
  try
  with frmDelay do
    begin
      ListType := List;
      DelayID  := IntToStr(ID);
      DFlag    := Flag;
      if Flag = 'D' then
        begin
          lblReas.Visible   := False;
          edDelay.Visible   := False;
          lblCheck.Visible  := False;
          edCheck.Visible   := False;
          UpDnCheck.Visible := False;
          lblDays.Visible   := False;
          cbDelay.Visible   := True;
        end;
      ShowModal;
    end;
  finally
    frmDelay.Release;
  end;
end;

procedure TfrmDelay.btnOKClick(Sender: TObject);
var
  Data, Success, Remove: string;
begin
  if (DFlag = 'D') and (cbDelay.Checked = False) then Exit;
  if (cbDelay.Checked = False) and (edDelay.Text = '') then
    begin
      MessageDlg('Please enter a delay reason.', mtwarning, [mbOK], 0);
      Exit;
    end;
  if cbDelay.Checked = True then Remove := '1'
    else Remove := '0';
  Data := Patient.DFN + '^' + DelayID + '^' + edDelay.Text + '^' + edCheck.Text + '^' + Remove + '^' + ListType + '^' + IntToStr(SpecIFN);
  Success := sCallV('APTWL PUT PRD', [Data]);
  if Success = '0' then
    begin
      MessageDlg('Delay data could not be saved.', mterror, [mbOK], 0);
    end;
  Close;
end;

procedure TfrmDelay.btnCancClick(Sender: TObject);
begin
  Close;
end;

end.
