unit fCurrentReq;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ORCtrls, ComCtrls, ExtCtrls, ORNet, ORFn, Buttons;

type
  TfrmCurrentReq = class(TForm)
    pnlMain: TPanel;
    hcReq: THeaderControl;
    lbReq: TORListBox;
    rgReq: TKeyClickRadioGroup;
    cbCan: TORComboBox;
    lblCan: TLabel;
    btnOK: TButton;
    btnQuit: TButton;
    lbTemp: TListBox;
    pnl0: TPanel;
    pnl1: TPanel;
    pnl2: TPanel;
    pnl3: TPanel;
    pnl4: TPanel;
    pnl5: TPanel;
    pnl6: TPanel;
    pnlReq: TPanel;
    btnCan: TButton;
    btnEdit: TButton;
    btnDet: TButton;
    btnSched: TButton;
    btnAdd: TButton;
    btnNote1: TButton;
    btnAud: TButton;
    btnBack: TButton;
    edComm: TCaptionRichEdit;
    lblComm: TLabel;
    btnExit: TBitBtn;
    pnlList: TPanel;
    lblLst: TLabel;
    rbLst1: TRadioButton;
    rbLst2: TRadioButton;
    rbLst3: TRadioButton;
    rbLst4: TRadioButton;
    btnPrint: TButton;
    btnAR: TButton;
    pnl7: TPanel;
    btnOut: TButton;
    lbPTemp: TORListBox;
    btnDelay: TButton;
    btnPatInq: TButton;
    btnRem: TButton;
    btnBlank: TButton;
    procedure hcReqSectionClick(HeaderControl: THeaderControl;
      Section: THeaderSection);
    procedure lbReqClick(Sender: TObject);
    procedure btnSchedClick(Sender: TObject);
    procedure btnDetClick(Sender: TObject);
    procedure btnEditClick(Sender: TObject);
    procedure btnCanClick(Sender: TObject);
    procedure btnAddClick(Sender: TObject);
    procedure Refresh;
    procedure btnOKClick(Sender: TObject);
    procedure btnQuitClick(Sender: TObject);
    procedure btnBackClick(Sender: TObject);
    procedure btnNote1Click(Sender: TObject);
    procedure ColorBar(Sect: integer);
    procedure SetColor(barcolor: TColor; Sect: integer);
    procedure btnAudClick(Sender: TObject);
    procedure DisableMenu;
    procedure EnableMenu;
    procedure DisplayCancel;
    procedure HideCancel;
    procedure rgReqClick(Sender: TObject);
    procedure AddToSCM;
    procedure rbLst1Click(Sender: TObject);
    procedure rbLst2Click(Sender: TObject);
    procedure rbLst3Click(Sender: TObject);
    procedure rbLst4Click(Sender: TObject);
    procedure btnPrintClick(Sender: TObject);
    procedure DisplayComment;
    procedure btnARClick(Sender: TObject);
    procedure btnOutClick(Sender: TObject);
    procedure cbCanChange(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure btnDelayClick(Sender: TObject);
    procedure lbReqMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure cbCanClick(Sender: TObject);
    procedure ReadOnly;
    procedure btnPatInqClick(Sender: TObject);
    procedure btnRemClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmCurrentReq: TfrmCurrentReq;
  sort, reqsort, opsort, opcase, back, lastsect, SCMType, CanIFN, ptsort, lastCase: integer;
  start, list, BList, Title: string;

procedure CurrentRequest;

implementation

{$R *.dfm}

uses fRptBox, SCMMain, fSched, fRequest, fGenPrint, uCore, rLocal,
     fDelay, fCodeKey, fPatInq;

procedure CurrentRequest;
var
  x: string;
begin
  frmCurrentReq := TfrmCurrentReq.Create(Application);
  try
  with frmCurrentReq do
    begin
      sort     := 2;
      reqsort  := 1;
      opsort   := 1;
      ptsort   := 0;
      start    := 'T+30';
      lastCase := 0;
      Title    := 'Current ' + SpecName + ' Request List';
      Refresh;
      CallV('APTWL GET CANCEL REASON', []);
      cbCan.Items := RPCBrokerV.Results;
      DisableMenu;
      HideCancel;
      back     := 0;
      pnl2.Color := clBlue;
      lastsect := 2;
      list     := 'R';
      if UserFac = 5 then ReadOnly;
      ShowModal;
    end;
  finally
    frmCurrentReq.Release;
  end;
end;

procedure TfrmCurrentReq.hcReqSectionClick(HeaderControl: THeaderControl;
  Section: THeaderSection);
var
  i: integer;
begin
  if Section.ID = 7 then
    begin
      ShowCodeKey;
      Exit;
    end;
  if piece(lbReq.Items[0], '^',1) = '*' then Exit;
  if lbReq.Items.Count = 1 then Exit;
  lbReq.Clear;
  DisableMenu;
  for i := 0 to hcReq.Sections.Count -1 do
    begin
      if(Section = hcReq.Sections[i]) then
        begin
          Sort := i;
          ColorBar(i);
          break;
        end;
    end;
  // get direction for DOL sort
  if sort = 4 then
    begin
      if reqsort = 1 then reqsort := 0
      else reqsort := 1;
    end;
  // get direction for date sort
  if sort = 1 then
    begin
      if opsort = 1 then opsort := 0
      else opsort := 1;
    end;
  // get direction for patient sort
  if sort = 2 then
    begin
      if ptsort = 1 then ptsort := 0
      else ptsort := 1;
    end;
  CallV('APTWL GET CURRENT REQUEST', [SpecIFN, sort, opsort, reqsort, start,ptsort]);
  lbReq.Items := RPCBrokerV.Results;
end;

procedure TfrmCurrentReq.lbReqClick(Sender: TObject);
begin
  ResetTimeOut;
  EnableMenu;
  opcase      := lbReq.ItemIEN;
  PtName      := piece(lbReq.Items[lbReq.ItemIndex], '^', 3);
  Patient     := TPatient.Create;
  Patient.DFN := piece(lbReq.Items[lbReq.ItemIndex], '^', 9);
  DFN         := Patient.DFN;
  lastCase    := lbReq.ItemIndex;
end;

procedure TfrmCurrentReq.btnSchedClick(Sender: TObject);
var
  SpecData, ReqData: string;
begin
  if UserSched <> 'YES' then
    begin
      frmSCMMain.ScheduleKey;
      Exit;
    end;
  ReqData := lbReq.Items[lbReq.ItemIndex];
  lbTemp.Items[0] := '^' + piece(ReqData, '^', 3); // patient
  lbTemp.Items[1] := piece(ReqData, '^', 4);       // procedure
  lbTemp.Items[2] := '^' + piece(ReqData, '^', 6); // surgeon
  lbTemp.Items[3] := '^' + piece(ReqData, '^', 7); // attending
  lbTemp.Items[4] := IntToStr(opcase);                                  // case #
  lbTemp.Items[5] := piece(ReqData, '^', 10);      // case order
  lbTemp.Items[6] := piece(ReqData, '^', 11);      // est length
  lbTemp.Items[7] := IntToStr(SpecIFN) + '^' + SpecName + '^' + SpecAbbr + '^' + ColorToString(SpecColor);  // retain specialty data for return from schedule
  lbTemp.Items[8] := piece(ReqData, '^', 14) + '^' + piece(ReqData, '^', 2);      // requested date - fm ^ foramtted
  Schedule(SpecIFN, lbTemp.Items, 2);
  SpecData  := lbTemp.Items[7];
  SpecIFN   := StrToInt(piece(SpecData, '^', 1));
  SpecName  := piece(SpecData, '^', 2);
  SpecAbbr  := piece(SpecData, '^', 3);
  SpecColor := StringToColor(piece(SpecData, '^', 4));
  Refresh;
end;

procedure TfrmCurrentReq.btnDetClick(Sender: TObject);
begin
  CallV('APTWL GET REQ DETAIL', [opcase, list]);
  ReportBox(RPCBrokerV.Results, 'Surgery Request Detail for ' + PtName, True);
end;

procedure TfrmCurrentReq.btnEditClick(Sender: TObject);
begin
  CallV('APTWL GET REQ DATA', [opcase]);
  lbTemp.Items := RPCBrokerV.Results;
  Request(lbTemp.Items, 2);
  Refresh;
end;

procedure TfrmCurrentReq.btnCanClick(Sender: TObject);
begin
  DisplayCancel;
  if back = 1 then lblCan.Caption := 'Move back to Wait List Reason';
end;

procedure TfrmCurrentReq.btnAddClick(Sender: TObject);
begin
  pnlList.Visible := True;
end;

procedure TfrmCurrentReq.AddToSCM;
var
  Success: string;
begin
  Success := sCallV('APTWL PUT REQ TO SCM', [opcase, SCMType]);
  if piece(Success, '^', 1) = '1' then
    begin
      ShowMessage('Case ' + IntToStr(opcase) + ' successfully placed on the SCM' + CRLF +
        'Accession: ' + SpecAbbr + ' ' + piece(Success, '^', 2));
    end
  else
    begin
      ShowMessage('The action was unsuccessful:' + CRLF +
        '  ' + piece(Success, '^', 2));
    end;
  pnlList.Visible := False;
  Refresh;
end;

procedure TfrmCurrentReq.Refresh;
var
  Count: integer;
begin
  lbReq.Clear;
  CallV('APTWL GET CURRENT REQUEST', [SpecIFN, sort, reqsort, opsort, start]);
  lbReq.Items := RPCBrokerV.Results;
  Count := lbReq.Items.Count;
  if piece(lbReq.Items[0], '^', 1) = '*' then Count := 0;
  if lastCase > Count then lastCase := Count;
  if lastReq > 0 then lbReq.ItemIndex := lastCase;
  frmCurrentReq.Caption := Title + '  (' + IntToStr(Count) + ')';
  DisableMenu;
end;

procedure TfrmCurrentReq.btnOKClick(Sender: TObject);
var
  Success, Reason, BListn: string;
begin
  Reason  := cbCan.Text;
  if Reason = '' then
    begin
      MessageDlg('Please enter a cancellation reason.', mtwarning, [mbOK], 0);
      Exit;
    end;
  if back = 1 then
    begin
      if BList = 'O' then
        begin
          Success := sCallV('APTWL PUT REQ TO CO', [opcase, edComm.Lines, CanIFN]);
        end
      else
        begin
          Success := sCallV('APTWL PUT REQ TO WL', [opcase, CanIFN, edComm.Lines, BList]);
        end;
      if Success = '1' then
        begin
          BListn := 'Wait';
          if BList = 'A' then BListn := 'AR';
          if BList = 'O' then BListn := 'Outsourced';
          MessageDlg('Case ' + IntToStr(opcase) + ' for ' + PtName +
            CRLF + 'has been moved to the ' + BListn + ' List.', mtinformation, [mbOK], 0);
          Refresh;
        end;
      if piece(Success, '^', 1) = '0' then ShowMessage('Moving to the ' + BListn + ' List not successful.');
      HideCancel;
      Exit;
    end;
  Success := sCallV('APTWL PUT REQ CANCEL', [opcase, CanIFN, edComm.Lines, 1]);
  if piece(Success, '^', 1) = '1' then
    begin
      ShowMessage('Case ' + IntToStr(opcase) + ' cancelled.' + CRLF
        + 'Patient: ' + piece(lbReq.Items[lbReq.ItemIndex], '^', 3) + CRLF
        + 'Reason:  ' + cbCan.Text);
      Refresh;
    end;
  if piece(Success, '^', 2) <> '' then
    begin
      if MessageDlg('There is a concurrent case to the one just cancelled.' + CRLF
        + '   Case ' + piece(Success, '^', 2) + ': ' + piece(Success, '^', 3) + CRLF
        + 'Do you want to cancel it also?', mtwarning, [mbYes, mbNo], 0) = mrYes then
        begin
          Success := sCallV('APTWL PUT REQ CANCEL', [piece(Success, '^', 2), CanIFN, edComm.Lines, 2]);
          if Success = '1' then ShowMessage('Concurrent case cancel successful.');
        end;
    end;
  if Success = '0' then
    begin
      ShowMessage('Cancel not successful.');
    end;
  btnQuitClick(Self);
end;

procedure TfrmCurrentReq.btnQuitClick(Sender: TObject);
begin
  HideCancel;
  if back=1 then lblCan.Caption := 'Cancel Reason';
end;

procedure TfrmCurrentReq.btnBackClick(Sender: TObject);
var
  Success: string;
begin
  back := 1;
  BList := 'W';
  DisplayCancel;
end;

procedure TfrmCurrentReq.btnNote1Click(Sender: TObject);
begin
  NIFN  := StrToInt(sCallV('APTWL GET TIU', [1, opcase]));
  if NIFN = 0 then
    begin
      MessageDlg('There is no Request Note associated with this Request.', mtinformation, [mbOK], 0);
      Exit;
    end;
  CallV('APTWL GET TEXT', [NIFN]);
  ReportBox(RPCBrokerV.Results, 'Request Note for ' + PtName, False);
end;

procedure TfrmCurrentReq.ColorBar(Sect: integer);
var
  color: TColor;
begin
  if (Sect = 1) or (Sect = 4) then
    begin
      if lastsect <> Sect then
        begin
          color := clBtnFace;
          SetColor(color, lastsect);
        end;
      if (opsort = 0) then color := clYellow
      else color := clBlue;
      SetColor(color, Sect);
      lastsect := Sect;
      Exit;
    end;
  if lastsect = Sect then Exit;
  color := clBtnFace;
  SetColor(color, lastsect);
  color := clBlue;
  SetColor(color, Sect);
  lastsect := Sect;
end;

procedure TfrmCurrentReq.SetColor(barcolor: TColor; Sect: integer);
begin
  if Sect = 0 then pnl0.Color := barcolor;
  if Sect = 1 then pnl1.Color := barcolor;
  if Sect = 2 then pnl2.Color := barcolor;
  if Sect = 3 then pnl3.Color := barcolor;
  if Sect = 4 then pnl4.Color := barcolor;
  if Sect = 5 then pnl5.Color := barcolor;
  if Sect = 6 then pnl6.Color := barcolor;
end;


procedure TfrmCurrentReq.btnAudClick(Sender: TObject);
begin
  CallV('APTWL GET AUDIT', [SpecIFN, opcase, list]);
  ReportBox(RPCBrokerV.Results, 'SCM Audit Trail for ' + PtName, True);
end;

procedure TfrmCurrentReq.DisableMenu;
begin
  btnSched.Enabled  := False;
  btnDet.Enabled    := False;
  btnEdit.Enabled   := False;
  btnCan.Enabled    := False;
  btnBack.Enabled   := False;
  btnAud.Enabled    := False;
  btnNote1.Enabled  := False;
  btnAdd.Enabled    := False;
  btnAR.Enabled     := False;
  btnOut.Enabled    := False;
  btnDelay.Enabled  := False;
  btnRem.Enabled    := False;
  btnPatInq.Enabled := False;
  opcase := 0;
end;

procedure TfrmCurrentReq.EnableMenu;
begin
  btnSched.Enabled := True;
  btnDet.Enabled   := True;
  btnEdit.Enabled  := True;
  btnCan.Enabled   := True;
  btnBack.Enabled  := True;
  btnAud.Enabled   := True;
  btnNote1.Enabled := True;
  if piece(lbReq.Items[lbReq.ItemIndex], '^', 8) = '0' then
    begin
      btnAdd.Enabled := True;
      btnRem.Enabled := True;
    end
  else
    begin
      btnAdd.Enabled := False;
      btnRem.Enabled := False;
    end;
  btnAR.Enabled     := True;
  btnOut.Enabled    := True;
  btnDelay.Enabled  := True;
  btnPatInq.Enabled := True;
end;

procedure TfrmCurrentReq.DisplayCancel;
begin
  lblCan.Visible  := True;
  cbCan.Visible   := True;
  btnOK.Visible   := True;
  btnQuit.Visible := True;
  lblComm.Visible := True;
  edComm.Visible  := True;
end;

procedure TfrmCurrentReq.HideCancel;
begin
  lblCan.Visible  := False;
  cbCan.Visible   := False;
  btnOK.Visible   := False;
  btnQuit.Visible := False;
  lblComm.Visible := False;
  edComm.Visible  := False;
end;

procedure TfrmCurrentReq.rgReqClick(Sender: TObject);
begin
  start := rgReq.Items[rgReq.ItemIndex];
  Refresh
end;

procedure TfrmCurrentReq.rbLst1Click(Sender: TObject);
begin
  if (rbLst1.Checked = True) then
    begin
      SCMType := 1;
      AddToSCM;
    end;
  rbLst1.Checked := False;
end;

procedure TfrmCurrentReq.rbLst2Click(Sender: TObject);
begin
  if (rbLst2.Checked = True) then
    begin
      SCMType := 2;
      AddToSCM;
    end;
  rbLst2.Checked := False;
end;

procedure TfrmCurrentReq.rbLst3Click(Sender: TObject);
begin
  if (rbLst3.Checked = True) then
    begin
      SCMType := 3;
      AddToSCM;
    end;
  rbLst3.Checked := False;
end;

procedure TfrmCurrentReq.rbLst4Click(Sender: TObject);
begin
  if (rbLst4.Checked = True) then
    begin
      rbLst4.Checked := False;
      pnlList.Visible := False;
    end;
end;

procedure TfrmCurrentReq.btnPrintClick(Sender: TObject);
var
  Title: string;
  J: integer;
begin
  lbPTemp.Items.Clear;
  for J := 0 to hcReq.Sections.Count-1 do lbPTemp.Items.Add(hcReq.Sections[J].Text);
  Title := frmCurrentReq.Caption;
  GenPrint(lbReq, Title, lbReq.Pieces, lbReq.TabPositions, lbPTemp, '');
end;

procedure TfrmCurrentReq.DisplayComment;
begin
  lblComm.Visible := True;
  edComm.Visible  := True;
  btnOK.Visible   := True;
  btnQuit.Visible := True;
end;

procedure TfrmCurrentReq.btnARClick(Sender: TObject);
begin
  back := 1;
  BList := 'A';
  DisplayCancel;
end;

procedure TfrmCurrentReq.btnOutClick(Sender: TObject);
begin
  back := 1;
  BList := 'O';
  DisplayCancel;
end;

procedure TfrmCurrentReq.cbCanChange(Sender: TObject);
begin
  if cbCan.Text = '' then Exit;
  CallV('APTWL GET CANCEL REASON', [cbCan.Text]);
  cbCan.Items := RPCBrokerV.Results;
  cbCan.DroppedDown := True;
end;

procedure TfrmCurrentReq.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  ResetTimeOut;
end;

procedure TfrmCurrentReq.btnDelayClick(Sender: TObject);
begin
  PatientDelay('R', opcase, piece(lbReq.Items[lbReq.ItemIndex], '^', 13));
  Refresh;
end;

procedure TfrmCurrentReq.lbReqMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if Button = mbLeft then Exit;
  if piece(lbReq.Items[lbReq.ItemIndex], '^', 13) = '' then Exit;
  CallV('APTWL GET PRD', [SpecIFN, lbReq.ItemIEN, list]);
  ReportBox(RPCBrokerV.Results, 'Patient Requested Delay Data', True);
end;

procedure TfrmCurrentReq.cbCanClick(Sender: TObject);
begin
  CanIFN := cbCan.ItemIEN;
end;

procedure TfrmCurrentReq.ReadOnly;
begin
  btnSched.Enabled  := False;
  btnBack.Enabled   := False;
  btnAR.Enabled     := False;
  btnOut.Enabled    := False;
  btnDelay.Enabled  := False;
  btnEdit.Enabled   := False;
  btnCan.Enabled    := False;
  btnAdd.Enabled    := False;
end;

procedure TfrmCurrentReq.btnPatInqClick(Sender: TObject);
begin
  PtInq;
end;

procedure TfrmCurrentReq.btnRemClick(Sender: TObject);
begin
  if MessageDlg('Are you sure you want to remove this Request from the SCM?', mtwarning, [mbYes, mbNo], 0) = mrNo then Exit;
  CallV('APTWL REMOVE ENTRY', [SpecIFN, opcase, 'R']);
  MessageDlg('This action does not remove the request from the Surgery file in Vista.', mtinformation, [mbOK], 0);
  Refresh;
end;

end.
