unit fCurrentOut;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ORCtrls, ExtCtrls, ComCtrls, ORFn, ORNet, Buttons,
  ORDtTm;

type
  TfrmCurrentOut = class(TForm)
    lbOut: TORListBox;
    hcOut: THeaderControl;
    pnl0: TPanel;
    pnl1: TPanel;
    pnl2: TPanel;
    pnl3: TPanel;
    pnl4: TPanel;
    pnl5: TPanel;
    rgReturn: TRadioGroup;
    pnlOut: TPanel;
    btnExit: TBitBtn;
    btnDetail: TButton;
    btnAudit: TButton;
    btnPrint: TButton;
    btnConsult: TButton;
    btnNote: TButton;
    btnRemove: TButton;
    memOut: TMemo;
    lblOut: TLabel;
    btnOK: TButton;
    lbTemp: TORListBox;
    pnlSelect: TPanel;
    lblSelect: TLabel;
    btnSelect: TBitBtn;
    lbSelect: TORListBox;
    btnRet: TButton;
    btnComp: TButton;
    pnlDisp: TPanel;
    rbActive: TRadioButton;
    lblDisp: TLabel;
    rbComp: TRadioButton;
    dbOut: TORDateBox;
    lblDate: TLabel;
    btnQuit: TButton;
    cbCancel: TORComboBox;
    procedure hcOutSectionClick(HeaderControl: THeaderControl;
      Section: THeaderSection);
    procedure RefreshCO;
    procedure lbOutClick(Sender: TObject);
    procedure ColorBar(Sect: integer);
    procedure SetColor(barcolor: TColor; Sect: integer);
    procedure DisableMenu;
    procedure EnableMenu;
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormClick(Sender: TObject);
    procedure btnOKClick(Sender: TObject);
    procedure btnDetailClick(Sender: TObject);
    procedure btnAuditClick(Sender: TObject);
    procedure btnPrintClick(Sender: TObject);
    procedure btnRemoveClick(Sender: TObject);
    procedure btnConsultClick(Sender: TObject);
    procedure btnNoteClick(Sender: TObject);
    procedure btnSelectClick(Sender: TObject);
    procedure lbSelectClick(Sender: TObject);
    procedure btnRetClick(Sender: TObject);
    procedure btnCompClick(Sender: TObject);
    procedure DisableSelect;
    procedure EnableSelect;
    procedure btnQuitClick(Sender: TObject);
    procedure rbActiveClick(Sender: TObject);
    procedure rbCompClick(Sender: TObject);
    procedure cbCancelClick(Sender: TObject);
    procedure cbCancelChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmCurrentOut: TfrmCurrentOut;
  sort, datesort, lastsect, wlifn, SelType, DFN, FMDate, ptsort, Menutype, csort, lastCase: integer;
  Title, PtName, CancIFN: string;

procedure CurrentOut;

implementation

{$R *.dfm}

uses SCMMain, fRptBox, fCurrentWait, fCurrentReq, uCore, rLocal,
     fRequest, fGenPrint;

procedure CurrentOut;
begin
  frmCurrentOut := TfrmCurrentOut.Create(Application);
  try
  with frmCurrentOut do
    begin
      sort       := 1;
      datesort   := 1;
      ptsort     := 0;
      csort      := 1;
      Menutype   := 0;
      pnl1.Color := clBlue;
      lastsect   := 1;
      lastCase   := 0;
      CancIFN    := '';
      Title      := Caption + ' ' + SpecName;
      rbActive.Checked := True;
      CallV('APTWL GET CANCEL REASON', ['A']);
      cbCancel.Items := RPCBrokerV.Results;
      DisableMenu;
      DisableSelect;
      RefreshCO;
      ShowModal;
    end;
  finally
    frmCurrentOut.Release;
  end;
end;

procedure TfrmCurrentOut.hcOutSectionClick(HeaderControl: THeaderControl;
  Section: THeaderSection);
var
  i: integer;
begin
  if piece(lbOut.Items[0], '^',1) = '*' then Exit;
  if lbOut.Items.Count = 1 then Exit;
  if Section.ID = 5 then Exit;
  lbOut.Clear;
  for i := 0 to hcOut.Sections.Count -1 do
    begin
      if(Section = hcOut.Sections[i]) then
        begin
          Sort := i;
          ColorBar(i);
          break;
        end;
    end;
  // get direction for sort by date
  if Sort = 1 then
    begin
      if datesort = 1 then datesort := 0
      else datesort := 1;
    end;
  // get direction for sort by patient
  if Sort = 2 then
    begin
      if ptsort = 1 then ptsort := 0
      else ptsort := 1;
    end;
  RefreshCO;
end;

procedure TfrmCurrentOut.RefreshCO;
var
  Count: integer;
begin
  CallV('APTWL GET CURRENT OUT', [SpecIFN, sort, datesort, ptsort, csort]);
  lbOut.Items := RPCBrokerV.Results;
  Count := lbOut.Items.Count;
  if piece(lbOut.Items[0], '^', 1) = '*' then Count := 0;
  if lastCase > Count then lastCase := Count;
  if lastCase > 0 then lbOut.ItemIndex := lastCase;
  frmCurrentOut.Caption := Title + '  (' + IntToStr(Count) + ')';
  DisableMenu;
  if Count <> 0 then btnPrint.Enabled := True;
end;

procedure TfrmCurrentOut.lbOutClick(Sender: TObject);
begin
  ResetTimeOut;
  wlifn  := lbOut.ItemIEN;
  PtName := piece(lbOut.Items[lbOut.ItemIndex], '^', 3);
  DFN    := StrToInt(piece(lbOut.Items[lbOut.ItemIndex], '^', 7));
  FMDate := StrToInt(piece(lbOut.Items[lbOut.ItemIndex], '^', 8));
  EnableMenu;
  pnlSelect.Visible := False;
  lastCase := lbOut.ItemIndex;
end;

procedure TfrmCurrentOut.ColorBar(Sect: integer);
var
  color: TColor;
begin
  if lastsect = Sect then Exit;
  color := clBtnFace;
  SetColor(color, lastsect);
  color := clBlue;
  SetColor(color, Sect);
  lastsect := Sect;
end;

procedure TfrmCurrentOut.SetColor(barcolor: TColor; Sect: integer);
begin
  if Sect = 0 then pnl0.Color := barcolor;
  if Sect = 1 then pnl1.Color := barcolor;
  if Sect = 2 then pnl2.Color := barcolor;
  if Sect = 3 then pnl3.Color := barcolor;
  if Sect = 4 then pnl4.Color := barcolor;
  if Sect = 5 then pnl5.Color := barcolor;
end;

procedure TfrmCurrentOut.DisableMenu;
begin
  btnDetail.Enabled  := False;
  btnAudit.Enabled   := False;
  btnConsult.Enabled := False;
  btnNote.Enabled    := False;
  btnRemove.Enabled  := False;
  btnRet.Enabled     := False;
  btnComp.Enabled    := False;
  btnPrint.Enabled   := False;
end;

procedure TfrmCurrentOut.EnableMenu;
begin
  btnDetail.Enabled  := True;
  btnAudit.Enabled   := True;
  btnConsult.Enabled := True;
  btnNote.Enabled    := True;
  if UserFac <> 5 then  // except read-only user
    begin
      btnRemove.Enabled  := True;
      btnRet.Enabled     := True;
      btnComp.Enabled    := True;
    end;
  if csort = 2 then  // completed list only sort
    begin
      btnRemove.Enabled  := False;
      btnRet.Enabled     := False;
      btnComp.Enabled    := False;
    end;
end;

procedure TfrmCurrentOut.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  ResetTimeOut;
end;

procedure TfrmCurrentOut.FormClick(Sender: TObject);
begin
  ResetTimeOut;
end;

procedure TfrmCurrentOut.btnOKClick(Sender: TObject);
var
  Success: string;
begin
  if Menutype = 1 then
    begin
      if rgReturn.ItemIndex = 2 then  //  make request
        begin
          CallV('APTWL GET WL DATA', [SpecIFN, wlifn, 'W']);
          lbTemp.Items := RPCBrokerV.Results;
          Request(lbTemp.Items, 4);
        end
      else     // AR or Wait
        begin
          Success := sCallV('APTWL PUT CO BACK', [SpecIFN, wlifn, memOut.Lines, rgReturn.ItemIndex]);
          if Success = '1' then
            begin
              MessageDlg('Outsourced case for ' + PtName +
                CRLF + 'put back on the  ' + rgReturn.Items[rgReturn.ItemIndex], mtinformation, [mbOK], 0);
            end;
          if Success = '0' then MessageDlg('The move could not be accomplished because of an error.', mtwarning, [mbOK], 0);
        end;
    end;
  if Menutype = 2 then
    begin
      Success := sCallV('APTWL COMPLETE OUTSOURCE', [SpecIFN, wlifn, dbOut.FMDateTime, memOut.Lines]);
      if Success = '1' then
        begin
          MessageDlg('Outsourced case for ' + PtName + ' has been completed.', mtinformation, [mbOK], 0);
            end;
      if Success = '0' then MessageDlg('The case could not be marked as completed.', mtwarning, [mbOK], 0);
    end;
  if Menutype = 3 then
    begin
      if MessageDlg('Are you sure you want to remove this case from the Outsource List?', mtwarning, [mbYes, mbNo], 0) = mrNo then
        begin
          DisableSelect;
          Exit;
        end;
      Success := sCallV('APTWL REMOVE OUTSOURCE', [SpecIFN, wlifn, CancIFN, memOut.Lines]);
      if Success = '1' then
        begin
          MessageDlg('Case ' + SpecAbbr + ' ' + IntToStr(wlifn) + ' for ' + PtName + ' removed' +
            CRLF + 'and placed on the Cancelled list.', mtinformation, [mbOK], 0);
          RefreshCO;
        end;
      if Success = '0' then MessageDlg('Not able to remove from Outsource List.', mtwarning, [mbOK], 0);
    end;
  DisableSelect;
  RefreshCO;
end;

procedure TfrmCurrentOut.btnDetailClick(Sender: TObject);
begin
  CallV('APTWL GET WL DETAIL', [SpecIFN, wlifn, 'W']);
  ReportBox(RPCBrokerV.Results, 'Outsourced List Detail for ' + PtName, True);
end;

procedure TfrmCurrentOut.btnAuditClick(Sender: TObject);
begin
  CallV('APTWL GET AUDIT', [SpecIFN, wlifn, 'W']);
  ReportBox(RPCBrokerV.Results, 'SCM Audit Trail for ' + PtName, True);
end;

procedure TfrmCurrentOut.btnPrintClick(Sender: TObject);
var
  Title: string;
  J: integer;
begin
  lbTemp.Items.Clear;
  for J := 0 to hcOut.Sections.Count-1 do lbTemp.Items.Add(hcOut.Sections[J].Text);
  Title := frmCurrentOut.Caption;
  GenPrint(lbOut, Title, lbOut.Pieces, lbOut.TabPositions, lbTemp, '');
end;

procedure TfrmCurrentOut.btnRemoveClick(Sender: TObject);
begin
  EnableSelect;
  lblDate.Visible  := True;
  lblDate.Caption  := 'Remove Reason:';
  cbCancel.Visible := True;
  Menutype         := 3;
end;

procedure TfrmCurrentOut.btnConsultClick(Sender: TObject);
begin
  CallV('APTWL GET OUT CONSULT', [SpecIFN, DFN, FMDate]);
  lbSelect.Items    := RPCBrokerV.Results;
  lblSelect.Caption := 'Outsource Consults for ' + PtName;
  pnlSelect.Visible := True;
  SelType := 1;
end;

procedure TfrmCurrentOut.btnNoteClick(Sender: TObject);
begin
  CallV('APTWL GET OUT NOTE', [SpecIFN, DFN, FMDate]);
  lbSelect.Items    := RPCBrokerV.Results;
  lblSelect.Caption := 'Outsource Notes for ' + PtName;
  pnlSelect.Visible := True;
  SelType := 2;
end;

procedure TfrmCurrentOut.btnSelectClick(Sender: TObject);
begin
  pnlSelect.Visible := False;
end;

procedure TfrmCurrentOut.lbSelectClick(Sender: TObject);
var
  IFN: string;
begin
  IFN := piece(lbSelect.Items[lbSelect.ItemIndex], '^', 1);
  if IFN = '' then Exit;
  if SelType = 1 then
    begin
      CallV('ORWCS REPORT TEXT', [DFN, IFN]);
      lbTemp.Items := RPCBrokerV.Results;
      ReportBox(lbTemp.Items, 'Consult Details for ' + PtName, False);
    end;
  if SelType = 2 then
    begin
      CallV('APTWL GET TEXT', [IFN]);
      ReportBox(RPCBrokerV.Results, 'OutSource Note for ' + PtName, False);
    end;
end;

procedure TfrmCurrentOut.btnRetClick(Sender: TObject);
begin
  rgReturn.Visible := True;
  EnableSelect;
  Menutype         := 1;
end;

procedure TfrmCurrentOut.btnCompClick(Sender: TObject);
begin
  lblDate.Visible := True;
  dbOut.Visible   := True;
  EnableSelect;
  lblDate.Caption := 'Date Completed:';
  Menutype        := 2;
end;

procedure TfrmCurrentOut.DisableSelect;
begin
  rgReturn.Visible := False;
  lblOut.Visible   := False;
  memOut.Visible   := False;
  btnOK.Visible    := False;
  lblDate.Visible  := False;
  cbCancel.Visible := False;
  dbOut.Visible    := False;
  btnQuit.Visible  := False;
end;

procedure TfrmCurrentOut.btnQuitClick(Sender: TObject);
begin
  DisableSelect;
end;

procedure TfrmCurrentOut.EnableSelect;
begin
  lblOut.Visible  := True;
  memOut.Visible  := True;
  btnOK.Visible   := True;
  btnQuit.Visible := True;
end;

procedure TfrmCurrentOut.rbActiveClick(Sender: TObject);
begin
  csort := 1;
  rbComp.Checked := False;
  RefreshCO;
end;

procedure TfrmCurrentOut.rbCompClick(Sender: TObject);
begin
  csort := 2;
  rbActive.Checked := False;
  RefreshCO;
end;

procedure TfrmCurrentOut.cbCancelClick(Sender: TObject);
begin
  CancIFN := IntToStr(cbCancel.ItemIEN);
end;

procedure TfrmCurrentOut.cbCancelChange(Sender: TObject);
begin
  if cbCancel.Text = '' then Exit;
  CallV('APTWL GET CANCEL REASON', [cbCancel.Text]);
  cbCancel.Items := RPCBrokerV.Results;
  cbCancel.DroppedDown := True;
end;

end.
