unit fComplete;
// ptld/jit  4-18-07

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, ORFn, ORNet, StdCtrls, ORCtrls, Buttons, ExtCtrls,
  ORDtTm;

type
  TfrmComplete = class(TForm)
    hcComp: THeaderControl;
    lbComplete: TORListBox;
    rgRange: TRadioGroup;
    pnlMenu: TPanel;
    btnDet: TButton;
    btnOp: TButton;
    btnNurse: TButton;
    btnAudit: TButton;
    btnExit: TBitBtn;
    pnl0: TPanel;
    pnl1: TPanel;
    pnl2: TPanel;
    pnl3: TPanel;
    pnl4: TPanel;
    pnl5: TPanel;
    pnl6: TPanel;
    btnPrint: TButton;
    lbPTemp: TORListBox;
    gbCustom: TGroupBox;
    dbBeg: TORDateBox;
    dbEnd: TORDateBox;
    lblBeg: TLabel;
    lblEnd: TLabel;
    lblSurg: TLabel;
    cbSurg: TORComboBox;
    btnSubmit: TButton;
    procedure lbCompleteDblClick(Sender: TObject);
    procedure btnDetClick(Sender: TObject);
    procedure lbCompleteClick(Sender: TObject);
    procedure EnableMenu;
    procedure btnOpClick(Sender: TObject);
    procedure rgRangeClick(Sender: TObject);
    procedure btnNurseClick(Sender: TObject);
    procedure btnAuditClick(Sender: TObject);
    procedure hcCompSectionClick(HeaderControl: THeaderControl;
      Section: THeaderSection);
    procedure ColorBar(Sect: integer);
    procedure SetColor(barcolor: TColor; Sect: integer);
    procedure RefreshComp;
    procedure DisableMenu;
    procedure btnPrintClick(Sender: TObject);
    procedure cbSurgChange(Sender: TObject);
    procedure cbSurgClick(Sender: TObject);
    procedure btnSubmitClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmComplete: TfrmComplete;
  opcase, sort, datesort, lastsect, ptsort, lastCase: integer;
  PtName, TIUOp, TIUNur, Title, Range, SurgIFN: string;

Procedure DisplayComplete;

implementation

{$R *.dfm}

uses SCMMain, fRptBox, fGenPrint, rLocal;

procedure DisplayComplete;
begin
  frmComplete := TfrmComplete.Create(Application);
  try
    with frmComplete do
      begin
        sort     := 2;
        datesort := 1;
        lastsect := 2;
        ptsort   := 1;
        pnl2.Color := clBlue;
        Title    := 'Completed cases for ';
        Range    := 'T-7';
        SurgIFN  := '';
        lastCase := 0;
        CallV('APTWL GET PROVIDER', ['S', SpecIFN]);
        cbSurg.Items := RPCBrokerV.Results;
        RefreshComp;
        ShowModal;
      end;
  finally
    frmComplete.Release;
  end;
end;

procedure TfrmComplete.lbCompleteDblClick(Sender: TObject);
begin
  CallV('APTWL GET REQ DETAIL', [opcase, 'R']);
  ReportBox(RPCBrokerV.Results, 'Surgery Case Detail for ' + PtName, True);
end;

procedure TfrmComplete.btnDetClick(Sender: TObject);
begin
  lbCompleteDblClick(Self);
end;

procedure TfrmComplete.lbCompleteClick(Sender: TObject);
begin
  ResetTimeOut;
  EnableMenu;
  opcase   := lbComplete.ItemIEN;
  PtName   := piece(lbComplete.Items[lbComplete.ItemIndex], '^', 3);
  TIUOp    := piece(lbComplete.Items[lbComplete.ItemIndex], '^', 9);
  TIUNur   := piece(lbComplete.Items[lbComplete.ItemIndex], '^', 10);
  lastCase := lbComplete.ItemIndex;
end;

procedure TfrmComplete.EnableMenu;
begin
  btnDet.Enabled   := True;
  btnOp.Enabled    := True;
  btnNurse.Enabled := True;
  btnAudit.Enabled := True;
end;

procedure TfrmComplete.btnOpClick(Sender: TObject);
begin
  if (TIUOp = '') then
    begin
      MessageDlg('Case ' + IntToStr(opcase) + ' does not have a signed Op Report.', mtinformation, [mbOK], 0);
      Exit;
    end;
  CallV('APTWL GET OP REPORT', [TIUOp]);
  ReportBox(RPCBrokerV.Results, 'Operation Report for ' + PtName, True);
end;

procedure TfrmComplete.rgRangeClick(Sender: TObject);
begin
  Range := rgRange.Items[rgRange.ItemIndex];
  RefreshComp;
end;

procedure TfrmComplete.btnNurseClick(Sender: TObject);
begin
  if (TIUNur = '') then
    begin
      MessageDlg('Case ' + IntToStr(opcase) + ' does not have a signed Nurses IntraOp Report.', mtinformation, [mbOK], 0);
      Exit;
    end;
  CallV('APTWL GET OP REPORT', [TIUNur]);
  ReportBox(RPCBrokerV.Results, 'Nurses IntraOp Report for ' + PtName, True);
end;

procedure TfrmComplete.btnAuditClick(Sender: TObject);
begin
  CallV('APTWL GET AUDIT', [SpecIFN, opcase, 'R']);
  ReportBox(RPCBrokerV.Results, 'Case Audit for ' + PtName + '  (' + IntToStr(opcase) + ')', True);
end;

procedure TfrmComplete.hcCompSectionClick(HeaderControl: THeaderControl;
  Section: THeaderSection);
var
  i: integer;
begin
  if piece(lbComplete.Items[0], '^',1) = '*' then Exit;
  if lbComplete.Items.Count = 1 then Exit;
  lbComplete.Clear;
  for i := 0 to hcComp.Sections.Count -1 do
    begin
      if(Section = hcComp.Sections[i]) then
        begin
          Sort := i;
          ColorBar(i);
          break;
        end;
    end;
  // get direction for sort by date
  if Sort = 1 then
    begin
      if datesort = 1 then datesort := 0
      else datesort := 1;
    end;
  // get direction for sort by patient
  if Sort = 2 then
    begin
      if ptsort = 1 then ptsort := 0
      else ptsort := 1;
    end;
  RefreshComp;
end;

procedure TfrmComplete.ColorBar(Sect: integer);
var
  color: TColor;
begin
  if lastsect = Sect then Exit;
  color := clBtnFace;
  SetColor(color, lastsect);
  color := clBlue;
  SetColor(color, Sect);
  lastsect := Sect;
end;

procedure TfrmComplete.SetColor(barcolor: TColor; Sect: integer);
begin
  if Sect = 0 then pnl0.Color := barcolor;
  if Sect = 1 then pnl1.Color := barcolor;
  if Sect = 2 then pnl2.Color := barcolor;
  if Sect = 3 then pnl3.Color := barcolor;
  if Sect = 4 then pnl4.Color := barcolor;
  if Sect = 5 then pnl5.Color := barcolor;
end;

procedure TfrmComplete.RefreshComp;
var
  Count: integer;
begin
  CallV('APTWL GET COMPLETED', [SpecIFN, Range, sort, datesort, ptsort, dbBeg.FMDateTime, dbEnd.FMDateTime, SurgIFN]);
  lbComplete.Items := RPCBrokerV.Results;
  Count := lbComplete.Items.Count;
  if piece(lbComplete.Items[0], '^', 1) = '*' then Count := 0;
  if lastCase > Count then lastCase := Count;
  if lastCase > 0 then lbComplete.ItemIndex := lastCase;
  frmComplete.Caption := Title + SpecName + '  (' + IntToStr(Count) +')';
  DisableMenu;
end;

procedure TfrmComplete.DisableMenu;
begin
  btnDet.Enabled   := False;
  btnOp.Enabled    := False;
  btnNurse.Enabled := False;
  btnAudit.Enabled := False;
end;

procedure TfrmComplete.btnPrintClick(Sender: TObject);
var
  Title: string;
  J: integer;
begin
  lbPTemp.Items.Clear;
  for J := 0 to hcComp.Sections.Count -1 do lbPTemp.Items.Add(hcComp.Sections[J].Text);
  Title := frmComplete.Caption;
  GenPrint(lbComplete, Title, lbComplete.Pieces, lbComplete.TabPositions, lbPTemp, '');
end;

procedure TfrmComplete.cbSurgChange(Sender: TObject);
begin
  if cbSurg.Text = '' then Exit;
  CallV('APTWL GET PROVIDER', ['S', SpecIFN, cbSurg.Text]);
  cbSurg.Items := RPCBrokerV.Results;
  cbSurg.DroppedDown := True;
end;

procedure TfrmComplete.cbSurgClick(Sender: TObject);
begin
  SurgIFN := IntToStr(cbSurg.ItemIEN);
end;

procedure TfrmComplete.btnSubmitClick(Sender: TObject);
begin
  if cbSurg.Text = '' then SurgIFN := '';
  RefreshComp;
end;

end.
