unit fCkWait;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ORCtrls, ComCtrls, Buttons, ORNet, ORFn;

type
  TfrmCkWait = class(TForm)
    lbCheck: TORListBox;
    HeaderControl1: THeaderControl;
    btnCanc: TBitBtn;
    lblNote: TLabel;
    btnCont: TButton;
    lblNote2: TLabel;
    procedure lbCheckDblClick(Sender: TObject);
    procedure lbCheckClick(Sender: TObject);
    procedure btnContClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmCkWait: TfrmCkWait;
  wlifn: integer;
  list: string;

procedure CheckWait(CheckData: TStrings; Count: integer);

implementation

{$R *.dfm}

uses SCMMain, fRptBox, fGenPrint, UCore;

procedure CheckWait(CheckData: TStrings; Count: integer);
var
  J: integer;
begin
  frmCkWait := TfrmCkWait.Create(Application);
  try
  with frmCkWait do
    begin
      for J := 0 to Count-1 do lbCheck.Items[J] := CheckData.Strings[J];
      Caption := Caption + PtName;
      ShowModal;
    end;
  finally
    frmCkWait.Release;
  end;
end;

procedure TfrmCkWait.lbCheckDblClick(Sender: TObject);
begin
  CallV('APTWL GET WL DETAIL', [SpecIFN, wlifn, list]);
  ReportBox(RPCBrokerV.Results, 'Case Detail for ' + PtName, True);
end;

procedure TfrmCkWait.lbCheckClick(Sender: TObject);
var
  LType: string;
begin
  wlifn := lbCheck.ItemIEN;
  Patient.DFN := piece(lbCheck.Items[lbCheck.ItemIndex], '^', 8);
  LType := piece(lbCheck.Items[lbCheck.ItemIndex], '^', 3);
  if LType = 'Act-Req' then list := 'A'
  else list := 'W';
end;

procedure TfrmCkWait.btnContClick(Sender: TObject);
var
  Reason, Comm, Success: string;
  ReasonIEN: integer;
begin
  Reason    := 'Administrative';
  ReasonIEN := 63;
  Comm      := 'Manual entry case superceeded by note request';
  Success := sCallV('APTWL PUT WL CANCEL', [SpecIFN, wlifn, list, ReasonIEN, Comm]);
  if Success = '1' then
    begin
      ShowMessage(SpecAbbr + ' ' + IntToStr(wlifn) + ' has been cancelled.' + CRLF
        + 'Patient: ' + PtName + CRLF
        + 'Reason:  ' + Reason);
      CallV('APTWL GET WL FOR ONE PT', [SpecIFN, Patient.DFN]);
      lbCheck.Items := RPCBrokerV.Results;
    end;
  if Success = '0' then ShowMessage('Old entry could not be cancelled.');
end;

end.
