unit fBlood;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ORCtrls, ExtCtrls, ComCtrls, ORFn, ORNet, Buttons;

type
  TfrmBlood = class(TForm)
    lblProd: TLabel;
    lblUnit: TLabel;
    edBlood: TEdit;
    cbBlood: TORComboBox;
    UpDown1: TUpDown;
    pnl1: TPanel;
    btnAdd: TButton;
    btnEdit: TButton;
    btnDel: TButton;
    lbBlood: TORListBox;
    lblSel: TLabel;
    lblNum: TLabel;
    btnExit: TBitBtn;
    btnEnter: TBitBtn;
    procedure lbBloodClick(Sender: TObject);
    procedure btnAddClick(Sender: TObject);
    procedure DisableSelection;
    procedure btnEditClick(Sender: TObject);
    procedure edBloodChange(Sender: TObject);
    procedure btnDelClick(Sender: TObject);
    Procedure DisableCounter;
    procedure btnExitClick(Sender: TObject);
    procedure cbBloodClick(Sender: TObject);
    procedure btnEnterClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    frmBlood: TfrmBlood;
  end;

var
  frmBlood: TfrmBlood;
  Edit, BloodChange: integer;

procedure GetBlood(TempList: TListBox);

implementation

{$R *.dfm}

uses fRequest;

procedure GetBlood(TempList: TListBox);
var
  J: integer;
begin
  frmBlood := TfrmBlood.Create(Application);
  try
  with frmBlood do
    begin
      Left := frmRequest.Left + frmRequest.pnl1.Width + frmRequest.btnBlood.Left + 10;
      Top  := frmRequest.Top + frmRequest.btnBlood.Top +60;
      lbBlood.Clear;
      if TempList.Items.Count > 0 then
        begin
          for J := 0 to TempList.Items.Count-1 do lbBlood.Items.Add(TempList.Items[J]);
        end;
      CallV('APTWL GET BLOOD', []);
      cbBlood.Items := RPCBrokerV.Results;
      DisableSelection;
      btnEdit.Enabled  := False;
      btnDel.Enabled   := False;
      btnEnter.Enabled := False;
      Edit := 0;
      BloodChange := 0;
      ShowModal;
    end;
  finally
    frmBlood.Release;
  end;
end;

procedure TfrmBlood.lbBloodClick(Sender: TObject);
begin
  btnEdit.Enabled := True;
  btnDel.Enabled  := True;
end;

procedure TfrmBlood.btnAddClick(Sender: TObject);
begin
  lblSel.Enabled  := True;
  lblNum.Enabled  := True;
  cbBlood.Enabled := True;
  edBlood.Enabled := True;
  UpDown1.Enabled := True;
end;

procedure TfrmBlood.DisableSelection;
begin
  lblSel.Enabled   := False;
  lblNum.Enabled   := False;
  cbBlood.Enabled  := False;
  edBlood.Enabled  := False;
  UpDown1.Enabled  := False;
  btnEnter.Enabled := False;
end;

procedure TfrmBlood.btnEditClick(Sender: TObject);
begin
  edBlood.Enabled := True;
  UpDown1.Enabled := True;
  Edit := 1;
end;

procedure TfrmBlood.edBloodChange(Sender: TObject);
begin
  if edBlood.Text = '0' then Exit;
  btnEnter.Enabled := True;
  BloodChange := 1;
end;

procedure TfrmBlood.btnDelClick(Sender: TObject);
begin
  if MessageDlg('Are you sure you want to delete the entry?', mtconfirmation, [mbYes, mbNo], 0) = mrNo then
    begin
      DisableCounter;
      Exit;
    end;
  lbBlood.Items.Delete(lbBlood.ItemIndex);
  DisableCounter;
  btnDel.Enabled  := False;
  btnEdit.Enabled := False;
end;

procedure TfrmBlood.DisableCounter;
begin
  edBlood.Enabled := False;
  UpDown1.Enabled := False;
end;

procedure TfrmBlood.btnExitClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmBlood.cbBloodClick(Sender: TObject);
begin
  btnEnter.Enabled := True;
end;

procedure TfrmBlood.btnEnterClick(Sender: TObject);
var
  X, Data: string;
begin
  if Edit = 1 then
    begin
      X := lbBlood.Items[lbBlood.ItemIndex];
      SetPiece(X, '^', 3, edBlood.Text);
      lbBlood.Items[lbBlood.ItemIndex] := X;
    end;
  if Edit = 0 then
    begin
      Data := IntToStr(cbBlood.ItemIEN) + '^' + cbBlood.Text + '^' + edBlood.Text;
      lbBlood.Items.Add(Data);
      cbBlood.Text := '';
    end;
  Edit := 0;
  DisableSelection;
end;

end.
