unit rLocal;
{ DATE CREATED:  6-25-01 }
{ CREATED BY:    user   user, PORTLAND VAMC }
{ DESCRIPTION:   FUNCTION AND PROCEDURE CALLS }
{ MODIFIED:      }


interface

uses SysUtils, Windows, Classes, uConst, ORNet, ORFn, Dialogs, ShellAPI;

function DetailFlag(IEN: Integer): TStrings;
function DetailFlagPtSel(IEN: Integer): TStrings;
function DetailIO(Data: String): TStrings;
function DetailCall(DFN: String; IEN: String): TStrings;
function DetailRx(DFN: String; IEN: String): TStrings;
function DetailUCD(DUZ: Integer; IEN: Integer): TStrings;
procedure ListFlags(Dest: TStrings);
procedure ListFlagsPtSel(Dest: TStrings);
procedure ListSurgeries(Dest: TStrings);
procedure ListCompPens(Dest: TStrings);
procedure GetNews(Dest: TStrings);
procedure GetUCD(Dest: TStrings);
procedure GetSA(Dest: TStrings);
function ValidateVitals(VitalList: TStringList):string;
function CheckNotif(Provider: integer): integer;
procedure ResetTimeOut;

implementation

uses uCore, rCore, SCMMain;

{ below 4 functions added  ptld-jit  9-9-00 }
function DetailFlag(IEN: Integer): TStrings;
{ flag details }
begin
  CallV('APTO GET RF DETAIL', [Patient.DFN, IEN]);
  Result := RPCBrokerV.Results;
end;

function DetailFlagPtSel(IEN: Integer): TStrings;
{ flag details for patient selection window}
begin
  CallV('APTO GET RF DETAIL', [Patient.DFN, IEN]);
  Result := RPCBrokerV.Results;
end;

function DetailIO(Data: String): TStrings;
{ Intake/Output details }
begin
  CallV('APTO GET IO DETAIL', [Patient.DFN, 'X', Data]);
  Result := RPCBrokerV.Results;
end;

function DetailCall(DFN: String; IEN: String): TStrings;
{ telephone care call details }
begin
  CallV('APTPI GET CALL DETAIL', [Patient.DFN, IEN]);
  Result := RPCBrokerV.Results;
end;

function DetailRX(DFN: String; IEN: String): TStrings;
{ prescription details }
begin
  CallV('APTPI GET RX DETAIL', [Patient.DFN, IEN]);
  Result := RPCBrokerV.Results;
end;

procedure ListFlags(Dest: TStrings);
begin
  CallV('APTO GET RF', [Patient.DFN]);
  //MixedCaseList(RPCBrokerV.Results);
  Dest.Assign(RPCBrokerV.Results);
end;

procedure ListFlagsPtSel(Dest: TStrings);
begin
  CallV('APTO GET RF', [Patient.DFN]);
  //MixedCaseList(RPCBrokerV.Results);
  Dest.Assign(RPCBrokerV.Results);
end;

procedure ListSurgeries(Dest: TStrings);
var
  x: string;
  i: integer;
begin
  CallV('APTO GET SURGERY', [Patient.DFN]);
  with RPCBrokerV do
  begin
    for i := 0 to Results.Count -1 do
    begin
      x := Results[i];
      Results[i] := 'i' + x;
    end;
    Dest.Assign(Results);
  end;
end;

procedure ListCompPens(Dest: TStrings);
var
  x: string;
  i: integer;
begin
  CallV('APTO GET COMP', [Patient.DFN]);
  with RPCBrokerV do
  begin
    for i := 0 to Results.Count -1 do
    begin
      x := Results[i];
      Results[i] := 'i' + x;
    end;
    Dest.Assign(Results);
  end;
end;

function ValidateVitals(VitalList: TStringList):string;
begin
  CallV('ORQQVI2 VITALS VALIDATE',[VitalList]);
  if RPCBrokerV.results[0] >= '0' then
    result := 'True'  //stored ok
  else
    result := Piece(RPCBrokerV.results[1],U,2) + ': '+Piece(RPCBrokerV.results[1],U,3)+' Value: '+
      Piece(RPCBrokerV.results[1],U,4);
end;

procedure GetNews(Dest: TStrings);
begin
  CallV('APTO GET NEWS', []);
  Dest.Assign(RPCBrokerV.Results);
end;

procedure GetUCD(Dest: TStrings);
begin
  CallV('APTO GET UCD', [User.DUZ]);
  Dest.Assign(RPCBrokerV.Results);
end;

procedure GetSA(Dest: TStrings);
begin
  CallV('APTO GET SA', [User.DUZ]);
  Dest.Assign(RPCBrokerV.Results);
end;

function DetailUCD(DUZ: integer; IEN: integer): TStrings;
begin
  CallV('APTO GET UCD DETAIL', [User.DUZ, IEN]);
  Result := RPCBrokerV.Results;
end;

function CheckNotif(Provider: integer): integer;
begin
  Result := StrToInt(sCallV('APTLS HAS NOTIF', [Provider]));
end;

procedure ResetTimeOut;
begin
  frmSCMMain.TimeOut.Enabled := False;
  frmSCMMain.TimeOut.Enabled := True;
  frmSCMMain.ResetDisplayTimerCounter;
end;

end.
