unit fWorkLoad;
// ptld/jit  8-5-09

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, ORDtTm, ORCtrls, ORFn, ORNet;

type
  TfrmWorkLoad = class(TForm)
    cbSpec: TORComboBox;
    cbSurg: TORComboBox;
    ORDateTimeDlg1: TORDateTimeDlg;
    dbDate1: TORDateBox;
    dbDate2: TORDateBox;
    rgSpec: TRadioGroup;
    lblSpec: TLabel;
    lblDate1: TLabel;
    lblDate2: TLabel;
    rgSort: TRadioGroup;
    lblSurg: TLabel;
    btnSubmit: TButton;
    btnQuit: TButton;
    procedure rgSpecClick(Sender: TObject);
    procedure rgSortClick(Sender: TObject);
    procedure cbSpecClick(Sender: TObject);
    procedure cbSurgChange(Sender: TObject);
    procedure cbSurgClick(Sender: TObject);
    procedure dbDate2Change(Sender: TObject);
    procedure btnSubmitClick(Sender: TObject);
    procedure btnQuitClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmWorkLoad: TfrmWorkLoad;
  SpecID, SurgID: string;

procedure GetWorkLoad;

implementation

{$R *.dfm}

uses SCMMain, fRptBox;

procedure GetWorkLoad;
begin
  frmWorkLoad := TfrmWorkLoad.Create(Application);
  try
  with frmWorkLoad do
    begin
      CallV('APTWL GET SPEC',[1, UserID, SiteIFN]);
      cbSpec.Items := RPCBrokerV.Results;
      CallV('APTWL GET PROVIDER', ['S', SpecID]);
      cbSurg.Items := RPCBrokerV.Results;
      ShowModal;
    end;
  finally
    frmWorkLoad.Release;
  end;
end;

procedure TfrmWorkLoad.rgSpecClick(Sender: TObject);
begin
  if rgSpec.ItemIndex = 0 then
    begin
      lblSpec.Enabled := True;
      cbSpec.Enabled  := True;
    end
  else
    begin
      lblSpec.Enabled := False;
      cbSpec.Enabled  := False;
      cbSpec.Text     := '';
      SpecID          := '';
    end;
end;

procedure TfrmWorkLoad.rgSortClick(Sender: TObject);
begin
  if rgSort.ItemIndex <> 2 then
    begin
      lblSurg.Enabled := True;
      cbSurg.Enabled  := True;
    end
  else
    begin
      lblSurg.Enabled := False;
      cbSurg.Enabled  := False;
      cbSurg.Text     := '';
      SurgID          := '';
    end;
end;

procedure TfrmWorkLoad.cbSpecClick(Sender: TObject);
begin
  SpecID := IntToStr(cbSpec.ItemIEN);
end;

procedure TfrmWorkLoad.cbSurgChange(Sender: TObject);
begin
  if cbSurg.Text = '' then
    begin
      cbSurg.DroppedDown := False;
      Exit;
    end;
  CallV('APTWL GET PROVIDER', ['S', SpecID, cbSurg.Text]);
  cbSurg.Items := RPCBrokerV.Results;
  cbSurg.DroppedDown := True;
end;

procedure TfrmWorkLoad.cbSurgClick(Sender: TObject);
begin
  SurgID := IntToStr(cbSurg.ItemIEN);
end;

procedure TfrmWorkLoad.dbDate2Change(Sender: TObject);
begin
  if dbDate2.FMDateTime < dbDate1.FMDateTime then
    begin
      MessageDlg('The "To" date is earlier than the "From" date!', mterror, [mbOK], 0);
      Exit;
    end;
end;

procedure TfrmWorkLoad.btnSubmitClick(Sender: TObject);
begin
  if (rgSpec.ItemIndex = 0) and (cbSpec.Text = '') then
    begin
      MessageDlg('Please select a specialty.', mtwarning, [mbOK], 0);
      Exit;
    end;
  if (dbDate1.Text = '') or (dbDate2.Text = '') then
    begin
      MessageDlg('Please select both dates.', mtwarning, [mbOK], 0);
      Exit;
    end;
  if (rgSort.ItemIndex < 2) and (cbSurg.Text = '') then
    begin
      MessageDlg('Please select a surgeon.', mtwarning, [mbOK], 0);
      Exit;
    end;
  CallV('APTWL GET WORKLOAD', [SpecID, SurgID, rgSort.ItemIndex, dbDate1.FMDateTime, dbDate2.FMDateTime]);
  ReportBox(RPCBrokerV.Results, 'Surgical Workload', True);
end;

procedure TfrmWorkLoad.btnQuitClick(Sender: TObject);
begin
  Close;
end;

end.
