unit fWaitReport;
// ptld/jit   5-23-07

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ORCtrls, ExtCtrls, ORDtTm, ORNet, ORFn, Buttons, Menus;

type
  TfrmWaitReport = class(TForm)
    pnl1: TPanel;
    lbRpt: TORListBox;
    hdrMem2: TMemo;
    hdrMem1: TMemo;
    hdrMem3: TMemo;
    hdrMem4: TMemo;
    hdrMem5: TMemo;
    hdrMem6: TMemo;
    hdrMem7: TMemo;
    hdrMem8: TMemo;
    hdrMem9: TMemo;
    rgSort: TRadioGroup;
    GroupBox1: TGroupBox;
    dbTo: TORDateBox;
    lblTo: TLabel;
    dbFrom: TORDateBox;
    lblFrom: TLabel;
    btnSubmit: TButton;
    rgRange: TRadioGroup;
    gbSel: TGroupBox;
    cbSel: TORComboBox;
    btnExit: TBitBtn;
    lbPatient: TORListBox;
    lbHold: TORListBox;
    pnlBack: TPanel;
    btnPrint: TButton;
    pmWait: TPopupMenu;
    pmWait1: TMenuItem;
    pmWait2: TMenuItem;
    pmWait3: TMenuItem;
    lbPTemp: TORListBox;
    pmWait4: TMenuItem;
    pmWait5: TMenuItem;
    procedure rgRangeClick(Sender: TObject);
    procedure rgSortClick(Sender: TObject);
    procedure cbSelChange(Sender: TObject);
    procedure btnSubmitClick(Sender: TObject);
    procedure btnExitClick(Sender: TObject);
    function CheckEntry(): Integer;
    procedure cbSelClick(Sender: TObject);
    procedure ClearFields;
    procedure lbRptClick(Sender: TObject);
    procedure pnlBackClick(Sender: TObject);
    procedure pmWait1Click(Sender: TObject);
    procedure GetData;
    procedure pmWait2Click(Sender: TObject);
    procedure pmWait3Click(Sender: TObject);
    procedure btnPrintClick(Sender: TObject);
    procedure pmWait4Click(Sender: TObject);
    procedure pmWait5Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmWaitReport: TfrmWaitReport;
  Sort, SelIFN, level, SpecIFN, wlifn, SRTN: integer;
  PtName, SortKey, TIUOp, TIUNur: string;

procedure WaitTimes;

implementation

{$R *.dfm}

uses SCMMain, fRptBox, fGenPrint;

procedure WaitTimes;
begin
  frmWaitReport := TfrmWaitReport.Create(Application);
  try
  with frmWaitReport do
    begin
      level := 1;
      ShowModal;
    end;
  finally
    frmWaitReport.Release;
  end;
end;

procedure TfrmWaitReport.rgRangeClick(Sender: TObject);
begin
  if rgRange.ItemIndex = 0 then gbSel.Visible := True;
  if rgRange.ItemIndex = 1 then
    begin
      gbSel.Visible := False;
      SelIFN := 0;
    end;
end;

procedure TfrmWaitReport.rgSortClick(Sender: TObject);
var
  Z: string;
begin
  Z := '';
  ClearFields;
  if rgSort.ItemIndex = 0 then
    begin
      Sort := 1;
      gbSel.Caption := 'Select Specialty';
      CallV('APTWL GET SPEC', [0, Z, SiteIFN]);
    end;
  if rgSort.ItemIndex = 1 then
    begin
      Sort := 2;
      gbSel.Caption := 'Select Surgeon';
      CallV('APTWL GET PROVIDER', ['G', 0, 'A']);
    end;
  if rgSort.ItemIndex = 2 then
    begin
      Sort := 3;
      gbSel.Caption := 'Select Attending';
      CallV('APTWL GET PROVIDER', ['G', 0, 'A']);
    end;
  if rgSort.ItemIndex = 3 then
    begin
      Sort := 4;
      gbSel.Caption := 'Select Procedure';
      CallV('APTWL GET PROC', [1]);
    end;
  cbSel.Items := RPCBrokerV.Results;
  frmWaitReport.Caption := 'Average Wait Times Report';
  lbRpt.Items.Clear;
end;

procedure TfrmWaitReport.cbSelChange(Sender: TObject);
begin
  if (cbSel.Text = '') or (Sort = 1) then
    begin
      cbSel.DroppedDown := False;
      Exit;
    end;
  if (Sort = 2) or (Sort = 3) then CallV('APTWL GET PROVIDER', ['G', 0, cbSel.Text]);
  if Sort= 4 then CallV('APTWL GET PROC', [cbSel.Text]);
  cbSel.Items := RPCBrokerV.Results;
  cbSel.DroppedDown := True;
end;

procedure TfrmWaitReport.btnSubmitClick(Sender: TObject);
begin
  if CheckEntry = 0 then
    begin
      MessageDlg('Please fill in all sort parameters first.', mtwarning, [mbOK], 0);
      Exit;
    end;
  CallV('APTWL GET WAIT TIMES', [rgSort.ItemIndex, rgRange.ItemIndex, SelIFN, dbFrom.FMDateTime, dbTo.FMDateTime, 0]);
  lbRpt.Items := RPCBrokerV.Results;
  CallV('APTWL GET WAIT TIMES', [rgSort.ItemIndex, rgRange.ItemIndex, SelIFN, dbFrom.FMDateTime, dbTo.FMDateTime, 1]);
  lbPatient.Items  := RPCBrokerV.Results;
  btnPrint.Visible := True;
  level := 1;
  frmWaitReport.Caption := 'Average Wait Times Report by ' + rgSort.Items[rgSort.ItemIndex];
end;

procedure TfrmWaitReport.btnExitClick(Sender: TObject);
begin
  Close;
end;

function TfrmWaitReport.CheckEntry(): Integer;
begin
  Result := 0;
  if rgSort.ItemIndex = -1 then Exit;
  if rgRange.ItemIndex = -1 then Exit;
  if (rgRange.ItemIndex = 0) and (cbSel.Text = '') then Exit;
  if dbFrom.Text = '' then Exit;
  if dbTo.Text ='' then Exit;
  Result := 1;
end;

procedure TfrmWaitReport.cbSelClick(Sender: TObject);
begin
  SelIFN := cbSel.ItemIEN;
end;

procedure TfrmWaitReport.ClearFields;
begin
  rgRange.ItemIndex := -1;
  gbSel.Caption     := 'Select';
  cbSel.Text        := '';
  cbSel.Items.Clear;
  dbFrom.Text       := '';
  dbTo.Text         := '';
  btnPrint.Visible  := False;
end;

procedure TfrmWaitReport.lbRptClick(Sender: TObject);
var
  J: integer;
  SortName: string;
begin
  if level = 2 then
    begin
      pmWait.Popup(Mouse.CursorPos.X, Mouse.CursorPos.Y + 10);
      Exit;
    end;
  SortKey := piece(lbRpt.Items[lbRpt.ItemIndex], '^', 13);
  SortName := piece(piece(lbRpt.Items[lbRpt.ItemIndex], '^', 1), '(', 1);
  lbHold.Items    := lbRpt.Items;
  lbRpt.Items.Clear;
  for J := 0 to lbPatient.Items.Count -1 do
    begin
      if piece(lbPatient.Items[J], '^', 13) = SortKey then lbRpt.Items.Add(lbPatient.Items[J]);
    end;
  level := 2;
  hdrMem1.Lines[1] := SortName;
  pnlBack.Visible := True;
end;

procedure TfrmWaitReport.pnlBackClick(Sender: TObject);
begin
  lbRpt.Items     := lbHold.Items;
  level := 1;
  pnlBack.Visible := False;
  hdrMem1.Lines[1] := '';
end;

procedure TfrmWaitReport.pmWait1Click(Sender: TObject);
begin
  GetData;
  CallV('APTWL GET WL DETAIL', [SpecIFN, wlifn, 'A']);
  ReportBox(RPCBrokerV.Results, ' SCM Entry Detail for ' + PtName, True);
end;

procedure TfrmWaitReport.GetData;
var
  data: string;
begin
  data    := lbRpt.Items[lbRpt.ItemIndex];
  PtName  := piece(piece(data, '^', 1), ' ', 1);
  SpecIFN := StrToInt(piece(data, '^', 10));
  wlifn   := StrToInt(piece(data, '^', 11));
  SRTN    := StrToInt(piece(data, '^', 12));
  TIUOp   := piece(data, '^', 14);
  TIUNur  := piece(data, '^', 15);
end;

procedure TfrmWaitReport.pmWait2Click(Sender: TObject);
var
  data: string;
begin
  GetData;
  if SRTN = 0 then
    begin
      ShowMessage('There is no Surgery case for this patient.');
      Exit;
    end;
  CallV('APTWL GET REQ DETAIL', [SRTN, 'R']);
  ReportBox(RPCBrokerV.Results, 'Surgery Case Detail for ' + PtName, True);
end;

procedure TfrmWaitReport.pmWait3Click(Sender: TObject);
var
  data: string;
begin
  GetData;
  CallV('APTWL GET AUDIT', [SpecIFN, wlifn, 'A']);
  ReportBox(RPCBrokerV.Results, 'SCM Audit Trail for ' + PtName, True);
end;

procedure TfrmWaitReport.btnPrintClick(Sender: TObject);
var
  Title: string;
begin
  lbPTemp.Items.Clear;
  lbPTemp.Items.Add('Sort Name');
  lbPTemp.Items.Add('PCP Consult');
  lbPTemp.Items.Add('Note Request');
  lbPTemp.Items.Add('Action-Req');
  lbPTemp.Items.Add('Wait List');
  lbPTemp.Items.Add('Request List');
  lbPTemp.Items.Add('Scheduled');
  lbPTemp.Items.Add('Signed Rpt');
  lbPTemp.Items.Add('Total');
  Title := frmWaitReport.Caption;
  GenPrint(lbRpt, Title, lbRpt.Pieces, lbRpt.TabPositions, lbPTemp, '');
end;

procedure TfrmWaitReport.pmWait4Click(Sender: TObject);
begin
  GetData;
  if TIUOp = '' then
    begin
      MessageDlg('There is no Op Report for this case.', mtinformation, [mbOK], 0);
      Exit;
    end;
  CallV('APTWL GET OP REPORT', [TIUOp]);
  ReportBox(RPCBrokerV.Results, 'Op Report for ' + PtName, True);
end;

procedure TfrmWaitReport.pmWait5Click(Sender: TObject);
begin
  GetData;
  if TIUNur = '' then
    begin
      MessageDlg('There is no Nurse Intraop Report for this case.', mtinformation, [mbOK], 0);
      Exit;
    end;
  CallV('APTWL GET OP REPORT', [TIUNur]);
  ReportBox(RPCBrokerV.Results, 'Nurse Intraop Report for ' + PtName, True);
end;

end.
