unit fWait;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, ORCtrls, TRPCB, ORFn, ORNet, ComCtrls,
  Buttons, ORDtTm;

type
  TfrmWait = class(TForm)
    pnl1: TPanel;
    pnl2: TPanel;
    bvl1: TBevel;
    lblFind: TLabel;
    memFind: TMemo;
    lblDiag: TLabel;
    edDiag: TEdit;
    lblBrief: TLabel;
    memBrief: TMemo;
    lblRes: TLabel;
    lblAtt: TLabel;
    lblComp: TLabel;
    lblLen: TLabel;
    edLen: TEdit;
    edOrd: TEdit;
    lblOrd: TLabel;
    lblTyp: TLabel;
    lblStat: TLabel;
    lblDis: TLabel;
    cbRes: TORComboBox;
    cbAtt: TORComboBox;
    cbStat: TORComboBox;
    cbDis: TORComboBox;
    lblStar2: TLabel;
    lblStar3: TLabel;
    lblStar4: TLabel;
    lblStar5: TLabel;
    cbType: TORComboBox;
    lblStar6: TLabel;
    lblMed: TLabel;
    lblMStat1: TLabel;
    pcMed: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    TabSheet3: TTabSheet;
    TabSheet4: TTabSheet;
    cbMed1: TORComboBox;
    cbMed2: TORComboBox;
    cbMed3: TORComboBox;
    cbMed4: TORComboBox;
    cbxMed1: TCheckBox;
    cbxMed2: TCheckBox;
    cbxMed3: TCheckBox;
    cbxMed4: TCheckBox;
    edMed1: TCaptionRichEdit;
    lblCMed1: TLabel;
    edMed2: TCaptionRichEdit;
    lblCMed2: TLabel;
    edMed3: TCaptionRichEdit;
    lblCMed3: TLabel;
    edMed4: TCaptionRichEdit;
    lblCMed4: TLabel;
    lblCon1: TLabel;
    edCon1: TEdit;
    lblOrder1: TLabel;
    edOrder1: TEdit;
    lblCon2: TLabel;
    lblOrder2: TLabel;
    edCon2: TEdit;
    edOrder2: TEdit;
    lblCon3: TLabel;
    lblOrder3: TLabel;
    edCon3: TEdit;
    edOrder3: TEdit;
    lblCon4: TLabel;
    lblOrder4: TLabel;
    edCon4: TEdit;
    edOrder4: TEdit;
    pnl3: TPanel;
    pnl4: TPanel;
    pnl5: TPanel;
    btnCan: TBitBtn;
    btnTran: TButton;
    btnSave: TButton;
    edWait: TCaptionRichEdit;
    lblWait: TLabel;
    btnClr1: TButton;
    btnClr2: TButton;
    btnClr3: TButton;
    btnClr4: TButton;
    Bevel1: TBevel;
    lblStar7: TLabel;
    lblStar8: TLabel;
    lblStar9: TLabel;
    lblStar10: TLabel;
    btnCon: TButton;
    btnOrd: TButton;
    lblTask: TLabel;
    pcTask: TPageControl;
    TabSheet5: TTabSheet;
    TabSheet6: TTabSheet;
    TabSheet7: TTabSheet;
    TabSheet8: TTabSheet;
    cbTask1: TORComboBox;
    cbTask2: TORComboBox;
    cbTask3: TORComboBox;
    cbTask4: TORComboBox;
    lblTTask1: TLabel;
    cbxTask1: TCheckBox;
    btnTask1: TButton;
    edTask1: TCaptionRichEdit;
    edTask2: TCaptionRichEdit;
    edTask3: TCaptionRichEdit;
    edTask4: TCaptionRichEdit;
    lblTTask4: TLabel;
    lblTTask2: TLabel;
    lblTTask3: TLabel;
    cbxTask2: TCheckBox;
    cbxTask3: TCheckBox;
    cbxTask4: TCheckBox;
    btnTask2: TButton;
    btnTask3: TButton;
    btnTask4: TButton;
    lblStar11: TLabel;
    lblStar12: TLabel;
    lblStar13: TLabel;
    lblStar14: TLabel;
    pnl6: TPanel;
    cbCPT: TORComboBox;
    lblCPT: TLabel;
    edProc: TEdit;
    lblFTProc: TLabel;
    cbProc: TORComboBox;
    lblProc: TLabel;
    lblStar0: TLabel;
    lblOr: TLabel;
    lblLocal: TLabel;
    lblStar15: TLabel;
    cbComp: TORComboBox;
    ORDateTimeDlg1: TORDateTimeDlg;
    lblSStat1: TLabel;
    dbManual: TORDateBox;
    lblManual: TLabel;
    lbFinal: TListBox;
    lbSec: TORListBox;
    edGComm: TCaptionRichEdit;
    lblGComm: TLabel;
    lblNeed: TLabel;
    edNeed: TEdit;
    lblEq: TLabel;
    edEq: TEdit;
    lblStar1: TLabel;
    lblLat: TLabel;
    lblSC: TLabel;
    lblLoc: TLabel;
    cbSC: TORComboBox;
    edLoc: TEdit;
    cbLat: TORComboBox;
    btnSec: TPanel;
    procedure btnCanClick(Sender: TObject);
    procedure cbResChange(Sender: TObject);
    procedure cbAttChange(Sender: TObject);
    procedure btnTranClick(Sender: TObject);
    procedure CollectData;
    procedure cbLatClick(Sender: TObject);
    procedure cbResClick(Sender: TObject);
    procedure cbAttClick(Sender: TObject);
    procedure cbStatClick(Sender: TObject);
    procedure cbDisClick(Sender: TObject);
    function CheckEdit(): integer;
    procedure cbProcChange(Sender: TObject);
    procedure cbProcClick(Sender: TObject);
    procedure cbTypeClick(Sender: TObject);
    procedure btnSaveClick(Sender: TObject);
    procedure cbLatChange(Sender: TObject);
    procedure memFindChange(Sender: TObject);
    procedure edDiagChange(Sender: TObject);
    procedure memBriefChange(Sender: TObject);
    procedure edTimeChange(Sender: TObject);
    procedure edLenChange(Sender: TObject);
    procedure edCompChange(Sender: TObject);
    procedure edOrdChange(Sender: TObject);
    procedure cbTypeChange(Sender: TObject);
    procedure cbStatChange(Sender: TObject);
    procedure cbDisChange(Sender: TObject);
    procedure edNeedChange(Sender: TObject);
    procedure edEqChange(Sender: TObject);
    procedure btnConClick(Sender: TObject);
    procedure HideMedClr;
    procedure btnOrdClick(Sender: TObject);
    procedure CheckStatus;
    procedure cbMed1Change(Sender: TObject);
    procedure cbxMed1Click(Sender: TObject);
    procedure cbMed2Change(Sender: TObject);
    procedure cbxMed2Click(Sender: TObject);
    procedure cbMed3Change(Sender: TObject);
    procedure cbxMed3Click(Sender: TObject);
    procedure cbMed4Change(Sender: TObject);
    procedure cbxMed4Click(Sender: TObject);
    procedure Med1Enable;
    procedure Med2Enable;
    procedure Med3Enable;
    procedure Med4Enable;
    procedure DisableMedClr;
    procedure edCon1Change(Sender: TObject);
    procedure edOrder1Change(Sender: TObject);
    procedure edMed1Change(Sender: TObject);
    procedure edCon2Change(Sender: TObject);
    procedure edOrder2Change(Sender: TObject);
    procedure edMed2Change(Sender: TObject);
    procedure edCon3Change(Sender: TObject);
    procedure edOrder3Change(Sender: TObject);
    procedure edMed3Change(Sender: TObject);
    procedure edCon4Change(Sender: TObject);
    procedure edOrder4Change(Sender: TObject);
    procedure edMed4Change(Sender: TObject);
    procedure edWaitChange(Sender: TObject);
    procedure btnClr1Click(Sender: TObject);
    procedure btnClr2Click(Sender: TObject);
    procedure btnClr3Click(Sender: TObject);
    procedure btnClr4Click(Sender: TObject);
    procedure cbMed1Click(Sender: TObject);
    procedure cbMed2Click(Sender: TObject);
    procedure cbMed3Click(Sender: TObject);
    procedure cbMed4Click(Sender: TObject);
    procedure NotComplete;
    procedure NotComplete2;
    procedure Complete;
    procedure Complete2;
    procedure HideTasks;
    procedure DisableTasks;
    procedure Task1Enable;
    procedure Task2Enable;
    procedure Task3Enable;
    procedure Task4Enable;
    procedure cbTask1Change(Sender: TObject);
    procedure cbTask1Click(Sender: TObject);
    procedure cbTask2Change(Sender: TObject);
    procedure cbTask2Click(Sender: TObject);
    procedure cbTask3Change(Sender: TObject);
    procedure cbTask3Click(Sender: TObject);
    procedure cbTask4Change(Sender: TObject);
    procedure cbTask4Click(Sender: TObject);
    procedure cbxTask4Click(Sender: TObject);
    procedure cbxTask2Click(Sender: TObject);
    procedure cbxTask3Click(Sender: TObject);
    procedure cbxTask1Click(Sender: TObject);
    procedure btnTask1Click(Sender: TObject);
    procedure btnTask2Click(Sender: TObject);
    procedure btnTask3Click(Sender: TObject);
    procedure btnTask4Click(Sender: TObject);
    procedure cbCPTChange(Sender: TObject);
    procedure cbCPTClick(Sender: TObject);
    procedure cbCompChange(Sender: TObject);
    procedure cbCompClick(Sender: TObject);
    procedure edProcChange(Sender: TObject);
    procedure btnSecClick(Sender: TObject);
    procedure CheckMedStatus;
    procedure CheckSurgStatus;
    procedure cbResKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure edGCommChange(Sender: TObject);
    procedure cbSCChange(Sender: TObject);
    procedure cbSCClick(Sender: TObject);
    procedure edLocChange(Sender: TObject);
    procedure dbManualChange(Sender: TObject);
    procedure edTask1Change(Sender: TObject);
    procedure edTask2Change(Sender: TObject);
    procedure edTask3Change(Sender: TObject);
    procedure edTask4Change(Sender: TObject);
    procedure AddToListNote;
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmWait: TfrmWait;
  star0, star1, star2, star3, star4, star5, star6, star7, star8,star9, star10: integer;
  star11, star12, star13, star14, star15: integer;
  LProcIFN, LProcName, LatIFN, ResIFN, AttIFN, CompIFN, TypeIFN, StatIFN, DisIFN, SCIFN: string;
  ProcName, ProcCPT, CPTIFN, ListName, ListType, PatientDFN, List, Success: string;
  Change, OtChange, wlifn, Edit, Source: integer;
  Med1IFN, Med2IFN, Med3IFN, Med4IFN: string;
  Task1IFN, Task2IFN, Task3IFN, Task4IFN: string;
  Sec1IFN, Sec2IFN, Sec3IFN, Sec4IFN: string;

procedure Wait(WLData: TStrings; Source: integer; List: string);

implementation

{$R *.dfm}

uses SCMMain, uCore, fConsults, fOrder, fOther;

procedure Wait(WLData: TStrings; Source: integer; List: string);
// Source - 1 = new entry from request note
//          2 = edit entry
//          3 = direct entry
// List   - A = Action-Required List
//          W = Wait List
//          R = Request List
//          S = Scheduled List
var
  I, J, Local: integer;
  Data, Code: string;
begin
  frmWait := TfrmWait.Create(Application);
  with frmWait do
    begin
      ListType := List;
      Change   := 0;
      OtChange := 0;
      PutFlag  := 0;
      lbSec.Items.Create;
      if List = 'A' then
        begin
          ListName          := 'Action Required List';
          btnTran.Caption   := 'Put on Action Required List';
          pcMed.ActivePage  := TabSheet1;
          pcTask.ActivePage := TabSheet5;
          DisableMedClr;
          DisableTasks;
          lblWait.Caption  := ListName + lblWait.Caption;
        end;
      if List = 'W' then
        begin
          ListName := 'Wait List';
          HideMedClr;
          HideTasks;
          btnCon.Enabled := False;
          btnOrd.Enabled := False;
          lblWait.Caption := ListName + lblWait.Caption;
        end;
      Caption := Caption + ListName + ' for ' + piece(WLData[0], '^', 2);
      if UserSite <> 648 then  // for portland only
        begin
          lblEq.Enabled := False;
          edEq.Enabled  := False;
        end;
      if Source = 3 then Caption := 'Direct Entry on ' + ListName + ' for ' + piece(WLData[0], '^', 2);
      if Source <> 1 then
        begin
          lblManual.Visible := True;
          dbManual.Visible  := True;
        end;
      if (UsePTLD = 0) then
        begin
          lblLocal.Enabled := False;
          lblProc.Enabled  := False;
          cbProc.Enabled   := False;
          lblOR.Enabled    := False;
          edProc.Text      := piece(WLData[22], '^', 2);
          // if Source = 2 then edProc.Text := piece(WLData[22], '^', 3);
          lblStar0.Caption := '';
          ProcName         := edProc.Text;
          ProcCPT          := '';
          LProcIFN         := '';
          LProcName        := '';
          lblEq.Visible    := False;
          edEq.Visible     := False;
        end;
      if (UsePtld = 1) then
        begin
          CallV('APTWL GET PROC', []);
          cbProc.Items := RPCBrokerV.Results;
          Local := StrToInt(piece(WLData[22], '^', 5));
          if Local = 1 then  // portland procedure
            begin
              cbProc.Text := piece(WLData[22], '^', 2);
              LProcName   := cbProc.Text;
              LProcIFN    := piece(WLData[22], '^', 1);
              ProcName    := '';
              if LProcIFN <> '' then lblStar0.Caption := '';
            end;
          if Local = 0 then  // free text procedure
            begin
              edProc.Text := piece(WLData[22],'^', 2);
              ProcName    := edProc.Text;
              LProcName   := '';
              LProcIFN    := '';
              lblStar0.Caption := '';
            end;
          CPTIFN      := piece(WLData[22], '^', 3);
          cbCPT.Text  := piece(WLData[22], '^', 4);
          ProcCPT     := cbCPT.Text;
        end;
      PatientDFN  := piece(WLData[0], '^', 1);
      cbLat.Text  := piece(WLData[7], '^', 2);
      //cbPos.Text  := piece(WLData(42), '^', 2);
      memFind.Lines[0]  := WLData[8];
      edDiag.Text := WLData[9];
      memBrief.Lines[0] := WLData[10];
      cbRes.Text  := piece(WLData[11], '^', 2);
      ResIFN      := piece(WLData[11], '^', 1);
      cbAtt.Text  := piece(WLData[12], '^', 2);
      AttIFN      := piece(WLData[12], '^', 1);
      // edTime.Text := WLData[13];      // removed 1-14-08
      edLen.Text  := WLData[14];
      cbComp.Text := piece(WLData[15], '^', 2);
      edOrd.Text  := WLData[16];
      cbType.Text := piece(WLData[17], '^', 2);
      cbStat.Text := piece(WLData[18], '^', 2);
      cbDis.Text  := piece(WLData[19], '^', 2);
      edNeed.Text := WLData[20];
      edEq.Text   := WLData[21];
      NIFN        := StrToInt(WLData[26]);
      // secondary procedures, comments, proc location
      if Source = 1 then   // from parsed note
        begin
          if WLData[43] <> '' then
            begin
              lbSec.Items.Add(WLData[43]);
              btnSec.Color      := clRed;
              btnSec.Font.Color := clWhite;
            end;
          if WLData[44] <> '' then lbSec.Items.Add(WLData[44]);
          if WLData[45] <> '' then lbSec.Items.Add(WLData[45]);
          if WLData[46] <> '' then lbSec.Items.Add(WLData[46]);
          if WLData[47] <> '' then lbSec.Items.Add(WLData[47]);
          if WLData[48] <> '' then lbSec.Items.Add(WLData[48]);
          for J := 1 to 3 do edGComm.Lines.Add(piece(WLData[49], '^', J));
          edLoc.Text  := WLData[50];
          cbSC.Text   := WLData[51];
          SCIFN := '';
          if cbSC.Text <> '' then
            begin
              if (cbSC.Text = 'Yes') or (cbSC.Text = 'YES') then SCIFN := '1';
              if (cbSC.Text = 'No') or (cbSC.Text = 'NO') then SCIFN := '0';
            end;
        end;
      //
      CallV('APTWL GET CPT', []);
      cbCPT.Items := RPCBrokerV.Results;
      CallV('APTWL GET LATERALITY', []);
      cbLat.Items := RPCBrokerV.Results;
      for J := 0 to cbLat.Items.Count-1 do
        begin
          if piece(cbLat.Items[J], '^', 2) = cbLat.Text then
          begin
            LatIFN := piece(cbLat.Items[J], '^', 1);
            lblStar1.Caption := '';
            Break;
          end;
        end;
      CallV('APTWL GET PROVIDER', ['S', SpecIFN]);
      cbRes.Items := RPCBrokerV.Results;
      if (cbRes.Text = '') or (cbRes.Text = 'none') or (ResIFN <> '') then lblStar2.Caption := '';
      cbAtt.Items := RPCBrokerV.Results;
      if (cbAtt.Text = '') or (cbAtt.Text = 'none') or (AttIFN <> '') then lblStar3.Caption := '';
      CallV('APTWL GET COMPLEX', []);
      cbComp.Items := RPCBrokerV.Results;
      for J := 0 to cbComp.Items.Count-1 do
        begin
          if piece(cbComp.Items[J], '^', 2) = cbComp.Text then
          begin
            CompIFN := piece(cbComp.Items[J], '^', 1);
            lblStar15.Caption := '';
            Break;
          end;
        end;
      CallV('APTWL GET PTSTAT', []);
      cbStat.Items := RPCBrokerV.Results;
      for J := 0 to cbStat.Items.Count-1 do
        begin
          if piece(cbStat.Items[J], '^', 2) = cbStat.Text then
          begin
            StatIFN := piece(cbStat.Items[J], '^', 1);
            lblStar4.Caption := '';
            Break;
          end;
        end;
      CallV('APTWL GET DISPO', []);
      cbDis.Items := RPCBrokerV.Results;
      for J := 0 to cbDis.Items.Count-1 do
        begin
          if piece(cbDis.Items[J], '^', 2) = UpperCase(cbDis.Text) then
          begin
            DisIFN := piece(cbDis.Items[J], '^', 1);
            lblStar5.Caption := '';
            Break;
          end;
        end;
      CallV('APTWL GET TYPE', []);
      cbType.Items := RPCBrokerV.Results;
      for J := 0 to cbType.Items.Count-1 do
        begin
          if piece(cbType.Items[J], '^', 2) = cbType.Text then
          begin
            TypeIFN := piece(cbType.Items[J], '^', 1);
            lblStar6.Caption := '';
            Break;
          end;
        end;
      if List = 'A' then
        begin
          CallV('APTWL GET ISSUE LIST', []);
          cbMed1.Items  := RPCBrokerV.Results;
          cbMed2.Items  := RPCBrokerV.Results;
          cbMed3.Items  := RPCBrokerV.Results;
          cbMed4.Items  := RPCBrokerV.Results;
          CallV('APTWL GET TASK LIST', [SpecIFN]);
          cbTask1.Items := RPCBrokerV.Results;
          cbTask2.Items := RPCBrokerV.Results;
          cbTask3.Items := RPCBrokerV.Results;
          cbTask4.Items := RPCBrokerV.Results;
          if (Source = 1) or (Source = 3) then  // from request note
          begin
            cbMed1.Text      := piece(WLData[34], '^', 1);
            edMed1.Lines[0]  := piece(WLData[34], '^', 2);
            cbMed2.Text      := piece(WLData[35], '^', 1);
            edMed2.Lines[0]  := piece(WLData[35], '^', 2);
            cbMed3.Text      := piece(WLData[36], '^', 1);
            edMed3.Lines[0]  := piece(WLData[36], '^', 2);
            cbMed4.Text      := piece(WLData[37], '^', 1);
            edMed4.Lines[0]  := piece(WLData[37], '^', 2);
            cbTask1.Text     := piece(WLData[38], '^', 1);
            edTask1.Lines[0] := piece(WLData[38], '^', 2);
            cbTask2.Text     := piece(WLData[39], '^', 1);
            edTask2.Lines[0] := piece(WLData[39], '^', 2);
            cbTask3.Text     := piece(WLData[40], '^', 1);
            edTask3.Lines[0] := piece(WLData[40], '^', 2);
            cbTask4.Text     := piece(WLData[41], '^', 1);
            edTask4.Lines[0] := piece(WLData[41], '^', 2);
            if cbMed1.Text <> '' then
              begin
                TabSheet1.Highlighted := True;
                Med1Enable;
                for J := 0 to cbMed1.Items.Count -1 do
                  begin
                    if piece(cbMed1.Items[J], '^', 2) = cbMed1.Text then
                      begin
                        Med1IFN := piece(cbMed1.Items[J], '^', 1);
                        lblStar7.Caption := '';
                        Break;
                      end;
                  end;
              end
            else lblStar7.Caption := '';
            if cbMed2.Text <> '' then
              begin
                TabSheet2.Highlighted := True;
                Med2Enable;
                for J := 0 to cbMed2.Items.Count -1 do
                  begin
                    if piece(cbMed2.Items[J], '^', 2) = cbMed2.Text then
                      begin
                        Med2IFN := piece(cbMed2.Items[J], '^', 1);
                        lblStar8.Caption := '';
                        Break;
                      end;
                  end;
              end
            else lblStar8.Caption := '';
            if cbMed3.Text <> '' then
              begin
                TabSheet3.Highlighted := True;
                Med3Enable;
                for J := 0 to cbMed3.Items.Count -1 do
                  begin
                    if piece(cbMed3.Items[J], '^', 2) = cbMed3.Text then
                      begin
                        Med3IFN := piece(cbMed3.Items[J], '^', 1);
                        lblStar9.Caption := '';
                        Break;
                      end;
                  end;
              end
            else lblStar9.Caption := '';
            if cbMed4.Text <> '' then
              begin
                TabSheet4.Highlighted := True;
                Med4Enable;
                for J := 0 to cbMed4.Items.Count -1 do
                  begin
                    if piece(cbMed4.Items[J], '^', 2) = cbMed4.Text then
                      begin
                        Med4IFN := piece(cbMed4.Items[J], '^', 1);
                        lblStar10.Caption := '';
                        Break;
                      end;
                  end;
              end
            else lblStar10.Caption := '';
            if cbTask1.Text <> '' then
              begin
                TabSheet5.Highlighted := True;
                Task1Enable;
                for J := 0 to cbTask1.Items.Count -1 do
                  begin
                    if piece(cbTask1.Items[J], '^', 2) = cbTask1.Text then
                      begin
                        Task1IFN := piece(cbTask1.Items[J], '^', 1);
                        lblStar11.Caption := '';
                        Break;
                      end;
                  end;
              end
            else lblStar11.Caption := '';
            if cbTask2.Text <> '' then
              begin
                TabSheet6.Highlighted := True;
                Task2Enable;
                for J := 0 to cbTask2.Items.Count -1 do
                  begin
                    if piece(cbTask2.Items[J], '^', 2) = cbTask2.Text then
                      begin
                        Task2IFN := piece(cbTask2.Items[J], '^', 1);
                        lblStar12.Caption := '';
                        Break;
                      end;
                  end;
              end
            else lblStar12.Caption := '';
            if cbTask3.Text <> '' then
              begin
                TabSheet7.Highlighted := True;
                Task3Enable;
                for J := 0 to cbTask3.Items.Count -1 do
                  begin
                    if piece(cbTask3.Items[J], '^', 2) = cbTask3.Text then
                      begin
                        Task3IFN := piece(cbTask3.Items[J], '^', 1);
                        lblStar13.Caption := '';
                        Break;
                      end;
                  end;
              end
            else lblStar13.Caption := '';
            if cbTask4.Text <> '' then
              begin
                TabSheet8.Highlighted := True;
                Task4Enable;
                for J := 0 to cbTask4.Items.Count -1 do
                  begin
                    if piece(cbTask4.Items[J], '^', 2) = cbTask4.Text then
                      begin
                        Task4IFN := piece(cbTask4.Items[J], '^', 1);
                        lblStar14.Caption := '';
                        Break;
                      end;
                  end;
              end
            else lblStar14.Caption := '';
            CheckStatus;
          end;
        end;
      btnTran.Visible := False;
      btnSave.Visible := False;
      Edit := Source;
      if (Source = 1) or (Source = 3) or (SRM = 'G') then btnTran.Visible := True;
      if Source = 2 then  // editing
      begin
        if SRM = '' then
          begin
            btnSave.Visible := True;
            Caption  := 'Edit ' + ListName + ' Entry for ' + piece(WLData[0], '^', 2);
          end;
        wlifn    := StrToInt(WLData[24]);
        LProcIFN := piece(WLData[22], '^', 1);
        CPTIFN   := piece(WLData[22], '^', 3);
        LatIFN   := piece(WLData[7], '^', 1);
        ResIFN   := piece(WLData[11], '^', 1);
        AttIFN   := piece(WLData[12], '^', 1);
        CompIFN  := piece(WLData[15], '^', 1);
        TypeIFN  := piece(WLData[17], '^', 1);
        StatIFN  := piece(WLData[18], '^', 1);
        DisIFN   := piece(WLData[19], '^', 1);
        if WLData[55] <> '' then dbManual.FMDateTime := StrToFloat(piece(WLData[55], '^', 1));
        for J := 1 to 3 do edGComm.Lines.Add(piece(WLData[58], '^', J));
        edLoc.Text := WLData[59];
        cbSC.Text   := piece(WLData[61], '^', 2);
        SCIFN := '';
        if cbSC.Text <> '' then
          begin
            if (cbSC.Text = 'Yes') or (cbSC.Text = 'YES') then SCIFN := '1';
            if (cbSC.Text = 'No') or (cbSC.Text = 'NO') then SCIFN := '0';
          end;
        //if WLData[42] = 'YES' then cbxAnes.Checked := True;
        if list = 'A' then
          begin
            edMed1.Clear;
            edMed2.Clear;
            edMed3.Clear;
            edMed4.Clear;
            edTask1.Clear;
            edTask2.Clear;
            edTask3.Clear;
            edTask4.Clear;
            if WLData[34] <> '' then
              begin
                TabSheet1.Highlighted := True;
                cbMed1.Text   := piece(piece(WLData[34], '^', 1), ':', 2);
                Med1IFN       := piece(piece(WLData[34], '^', 1), ':', 1);
                edCon1.Text   := piece(WLData[34], '^', 4);
                edOrder1.Text := piece(WLData[34], '^', 6);
                if piece(WLdata[34], '^', 5) <> '' then cbxMed1.Checked := True;
                if WLData[38] <> '' then for I := 1 to 4 do edMed1.Lines.Add(piece(WLData[38], '^', I));
                Med1Enable;
                lblStar7.Caption := '';
              end
            else lblStar7.Caption := '';
            if WLData[35] <> '' then
              begin
                TabSheet2.Highlighted := True;
                cbMed2.Text   := piece(piece(WLData[35], '^', 1), ':', 2);
                Med2IFN       := piece(piece(WLData[35], '^', 1), ':', 1);
                edCon2.Text   := piece(WLData[35], '^', 4);
                edOrder2.Text := piece(WLData[35], '^', 6);
                if piece(WLdata[35], '^', 5) <> '' then cbxMed2.Checked := True;
                if WLData[39] <> '' then for I := 1 to 4 do edMed2.Lines.Add(piece(WLData[39], '^', I));
                Med2Enable;
                lblStar8.Caption := '';
              end
            else lblStar8.Caption := '';
            if WLData[36] <> '' then
              begin
                TabSheet3.Highlighted := True;
                cbMed3.Text   := piece(piece(WLData[36], '^', 1), ':', 2);
                Med3IFN       := piece(piece(WLData[36], '^', 1), ':', 1);
                edCon3.Text   := piece(WLData[36], '^', 4);
                edOrder3.Text := piece(WLData[36], '^', 6);
                if piece(WLdata[36], '^', 5) <> '' then cbxMed3.Checked := True;
                if WLData[40] <> '' then for I := 1 to 4 do edMed3.Lines.Add(piece(WLData[40], '^', I));
                Med3Enable;
                lblStar9.Caption := '';
              end
            else lblStar9.Caption := '';
            if WLData[37] <> '' then
              begin
                TabSheet4.Highlighted := True;
                cbMed4.Text   := piece(piece(WLData[37], '^', 1), ':', 2);
                Med4IFN       := piece(piece(WLData[37], '^', 1), ':', 1);
                edCon4.Text   := piece(WLData[37], '^', 4);
                edOrder4.Text := piece(WLData[37], '^', 6);
                if piece(WLdata[37], '^', 5) <> '' then cbxMed4.Checked := True;
                if WLData[41] <> '' then for I := 1 to 4 do edMed4.Lines.Add(piece(WLData[41], '^', I));
                Med4Enable;
                lblStar10.Caption := '';
              end
            else lblStar10.Caption := '';
            if WLData[43] <> '' then
              begin
                TabSheet5.Highlighted := True;
                cbTask1.Text   := piece(piece(WLData[43], '^', 1), ':', 2);
                Task1IFN       := piece(piece(WLData[43], '^', 1), ':', 1);
                if piece(WLData[43], '^', 4) <> '' then cbxTask1.Checked := True;
                if WLData[47] <> '' then for I := 1 to 4 do edTask1.Lines.Add(piece(WLData[47], '^', I));
                Task1Enable;
                lblStar11.Caption := '';
              end
            else lblStar11.Caption := '';
            if WLData[44] <> '' then
              begin
                TabSheet6.Highlighted := True;
                cbTask2.Text   := piece(piece(WLData[44], '^', 1), ':', 2);
                Task2IFN       := piece(piece(WLData[44], '^', 1), ':', 1);
                if piece(WLdata[44], '^', 4) <> '' then cbxTask2.Checked := True;
                if WLData[48] <> '' then for I := 1 to 4 do edTask2.Lines.Add(piece(WLData[48], '^', I));
                Task2Enable;
                lblStar12.Caption := '';
              end
            else lblStar12.Caption := '';
            if WLData[45] <> '' then
              begin
                TabSheet7.Highlighted := True;
                cbTask3.Text   := piece(piece(WLData[45], '^', 1), ':', 2);
                Task3IFN       := piece(piece(WLData[45], '^', 1), ':', 1);
                if piece(WLdata[45], '^', 4) <> '' then cbxTask3.Checked := True;
                if WLData[49] <> '' then for I := 1 to 4 do edTask3.Lines.Add(piece(WLData[49], '^', I));
                Task3Enable;
                lblStar13.Caption := '';
              end
            else lblStar13.Caption := '';
            if WLData[46] <> '' then
              begin
                TabSheet8.Highlighted := True;
                cbTask4.Text   := piece(piece(WLData[46], '^', 1), ':', 2);
                Task4IFN       := piece(piece(WLData[46], '^', 1), ':', 1);
                if piece(WLdata[46], '^', 4) <> '' then cbxTask4.Checked := True;
                if WLData[50] <> '' then for I := 1 to 4 do edTask4.Lines.Add(piece(WLData[50], '^', I));
                Task4Enable;
                lblStar14.Caption := '';
              end
            else lblStar14.Caption := '';
            CheckStatus;
            end;
          // secondary procedures
          if WLData[51] <> '' then
            begin
              lbSec.Items.Add(WLData[51]);
              btnSec.Color      := clRed;
              btnSec.Font.Color := clWhite;
            end;
          if WLData[52] <> '' then lbSec.Items.Add(WLData[52]);
          if WLData[53] <> '' then lbSec.Items.Add(WLData[53]);
          if WLData[54] <> '' then lbSec.Items.Add(WLData[54]);
          if WLData[56] <> '' then lbSec.Items.Add(WLData[56]);
          if WLData[57] <> '' then lbSec.Items.Add(WLData[57]);
          end;
      Change := 0;
      //if (UsePTLD = 1) then cbProc.SetFocus;
      //if (UsePTLD = 0) then edProc.SetFocus;
      ShowModal;
    end;
  frmWait.Release;
end;


procedure TfrmWait.btnCanClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmWait.cbResChange(Sender: TObject);
begin
  if cbRes.Text = '' then
    begin
      cbRes.DroppedDown := False;
      Exit;
    end;
  CallV('APTWL GET PROVIDER', ['S', SpecIFN, cbRes.Text]);
  cbRes.Items := RPCBrokerV.Results;
  cbRes.DroppedDown := True;
  Change := 1;
end;

procedure TfrmWait.cbAttChange(Sender: TObject);
begin
  if cbAtt.Text = '' then
    begin
      cbAtt.DroppedDown := False;
      Exit;
    end;
  CallV('APTWL GET PROVIDER', ['S', SpecIFN, cbAtt.Text]);
  cbAtt.Items := RPCBrokerV.Results;
  cbAtt.DroppedDown := True;
  Change := 1;
end;

procedure TfrmWait.btnTranClick(Sender: TObject);
var
  cnt: integer;
begin
  if CheckEdit = 0 then
    begin
      cnt := 0;
      MessageDlg('Please edit the data in all "starred" boxes', mtwarning, [mbOK], 0);
      if star0 = 1 then
        begin
          cbProc.Color := clSkyBlue;
          if cnt = 0 then
            begin
              cbProc.SetFocus;
              cnt := 1;
            end;
        end;
      if star1 = 1 then
        begin
          cbLat.Color := clSkyBlue;
          if cnt = 0 then
            begin
              cbLat.SetFocus;
              cnt := 1;
            end;
        end;
      if star2 = 1 then
        begin
          cbRes.Color := clSkyBlue;
          if cnt = 0 then
            begin
              cbRes.SetFocus;
              cnt := 1;
            end;
        end;
      if star3 = 1 then
        begin
          cbAtt.Color := clSkyBlue;
          if cnt = 0 then
            begin
              cbAtt.SetFocus;
              cnt := 1;
            end;
        end;
      if star4 = 1 then
        begin
          cbStat.Color := clSkyBlue;
          if cnt = 0 then
            begin
              cbStat.SetFocus;
              cnt := 1;
            end;
        end;
      if star5 = 1 then
        begin
          cbDis.Color := clSkyBlue;
          if cnt = 0 then
            begin
              cbDis.SetFocus;
              cnt := 1;
            end;
        end;
      if star6 = 1 then
        begin
          cbType.Color := clSkyBlue;
          if cnt = 0 then
            begin
              cbType.SetFocus;
              cnt := 1;
            end;
        end;
      if (list = 'W') then Exit;
      // issues
      if star7 = 1 then
        begin
          cbMed1.Color := clSkyBlue;
          if cnt = 0 then
            begin
              cbMed1.SetFocus;
              cnt := 1;
            end;
        end;
      if star8 = 1 then
        begin
          cbMed2.Color := clSkyBlue;
          if cnt = 0 then
            begin
              cbMed2.SetFocus;
              cnt := 1;
            end;
        end;
      if star9 = 1 then
        begin
          cbMed3.Color := clSkyBlue;
          if cnt = 0 then
            begin
              cbMed3.SetFocus;
              cnt := 1;
            end;
        end;
      if star10 = 1 then
        begin
          cbMed4.Color := clSkyBlue;
          if cnt = 0 then
            begin
              cbMed4.SetFocus;
              cnt := 1;
            end;
        end;
      // tasks
      if star11 = 1 then
        begin
          cbTask1.Color := clSkyBlue;
          if cnt = 0 then
            begin
              cbTask1.SetFocus;
              cnt := 1;
            end;
        end;
      if star12 = 1 then
        begin
          cbTask2.Color := clSkyBlue;
          if cnt = 0 then
            begin
              cbTask2.SetFocus;
              cnt := 1;
            end;
        end;
      if star13 = 1 then
        begin
          cbTask3.Color := clSkyBlue;
          if cnt = 0 then
            begin
              cbTask3.SetFocus;
              cnt := 1;
            end;
        end;
      if star14 = 1 then
        begin
          cbTask4.Color := clSkyBlue;
          if cnt = 0 then
            begin
              cbTask4.SetFocus;
              cnt := 1;
            end;
        end;
      // complexity
      if star15 = 1 then
        begin
          cbComp.Color := clSkyBlue;
          if cnt=0 then
            begin
              cbComp.SetFocus;
              cnt := 1;
            end;
        end;
      Exit;
    end;
  if SRM = 'G' then
    begin
      Change := 1;
      btnSaveClick(Self);
      Close;
    end;
  CollectData;
  Success := sCallV('APTWL PUT WAIT LIST', [lbFinal.Items, edMed1.Lines, edMed2.Lines, edMed3.Lines, edMed4.Lines, edTask1.Lines, edTask2.Lines, edTask3.Lines, edTask4.Lines, edWait.Lines, ListType, lbSec.Items, edGComm.Lines]);
  if piece(Success, '^', 1) = '0' then
    begin
      MessageDlg(piece(Success, '^', 2), mterror, [mbOK], 0);
      Exit;
    end;
  if piece(Success, '^', 1) = '1' then
    begin
      AddToListNote;
      Close;
    end;
end;

procedure TfrmWait.CollectData;
var
  I: integer;
begin
  if cbProc.Text = '' then LProcIFN := '';
  if cbCPT.Text  = '' then CPTIFN   := '';
  if cbLat.Text  = '' then LatIFN   := '';
  if cbRes.Text  = '' then ResIFN   := '';
  if cbAtt.Text  = '' then AttIFN   := '';
  if cbComp.Text = '' then CompIFN  := '';
  if cbType.Text = '' then TypeIFN  := '';
  if cbStat.Text = '' then StatIFN  := '';
  if cbDis.Text  = '' then DisIFN   := '';
  lbFinal.Clear;
  lbFinal.Items[0]  := LProcIFN + '^' + LProcName + '^' + ProcName + '^' + CPTIFN;
  lbFinal.Items[1]  := PatientDFN;
  lbFinal.Items[2]  := LatIFN + '^' + edLoc.Text;
  lbFinal.Items[3]  := memFind.Lines[0] + ' ' + memFind.Lines[1];
  lbFinal.Items[4]  := edDiag.Text;
  lbFinal.Items[5]  := memBrief.Lines[0] + ' ' + memBrief.Lines[1];
  lbFinal.Items[6]  := ResIFN;
  lbFinal.Items[7]  := AttIFN;
  lbFinal.Items[8]  := SCIFN; // 2-26-08  is procedure SC
  lbFinal.Items[9]  := edLen.Text;
  lbFinal.Items[10] := CompIFN;
  lbFinal.Items[11] := edOrd.Text;
  lbFinal.Items[12] := TypeIFN;
  lbFinal.Items[13] := StatIFN;
  lbFinal.Items[14] := DisIFN;
  lbFinal.Items[15] := edNeed.Text;
  lbFinal.Items[16] := edEq.Text;
  lbFinal.Items[17] := IntToStr(SpecIFN);
  lbFinal.Items[18] := IntToStr(NIFN);
  for I := 19 to 35 do lbFinal.Items[I] := '';
  if dbManual.Text <> '' then lbFinal.Items[33] := FloatToStr(dbManual.FMDateTime);
  if Source = 1 then lbFinal.Items[34] := IntToStr(PCPConsult);  // 1-31-08
  if ListType = 'A' then
    begin
      for I := 19 to 22 do lbFinal.Items[I] := '';
      if cbMed1.Text <> '' then lbFinal.Items[19] := Med1IFN + '^' + edCon1.Text + '^' + edOrder1.Text + '^' + BoolToStr(cbxMed1.Checked);
      if cbMed2.Text <> '' then lbFinal.Items[20] := Med2IFN + '^' + edCon2.Text + '^' + edOrder2.Text + '^' + BoolToStr(cbxMed2.Checked);
      if cbMed3.Text <> '' then lbFinal.Items[21] := Med3IFN + '^' + edCon3.Text + '^' + edOrder3.Text + '^' + BoolToStr(cbxMed3.Checked);
      if cbMed4.Text <> '' then lbFinal.Items[22] := Med4IFN + '^' + edCon4.Text + '^' + edOrder4.Text + '^' + BoolToStr(cbxMed4.Checked);
      lbFinal.Items[23] := lblMStat1.Caption;
      for I := 25 to 28 do lbFinal.Items[I] := '';
      if cbTask1.Text <> '' then lbFinal.Items[25] := Task1IFN + '^' + BoolToStr(cbxTask1.Checked);
      if cbTask2.Text <> '' then lbFinal.Items[26] := Task2IFN + '^' + BoolToStr(cbxTask2.Checked);
      if cbTask3.Text <> '' then lbFinal.Items[27] := Task3IFN + '^' + BoolToStr(cbxTask3.Checked);
      if cbTask4.Text <> '' then lbFinal.Items[28] := Task4IFN + '^' + BoolToStr(cbxTask4.Checked);
      lbFinal.Items[24] := lblSStat1.Caption;
    end;
  lbFinal.Items[35] := SRM;
end;

procedure TfrmWait.cbLatClick(Sender: TObject);
begin
  lblStar1.Caption := '';
  LatIFN := IntToStr(cbLat.ItemIEN);
  cbLat.Color := clWindow;
end;

procedure TfrmWait.cbResClick(Sender: TObject);
begin
  lblStar2.Caption := '';
  ResIFN := IntToStr(cbRes.ItemIEN);
  cbRes.Color := clWindow;
end;

procedure TfrmWait.cbAttClick(Sender: TObject);
begin
  lblStar3.Caption := '';
  AttIFN := IntToStr(cbAtt.ItemIEN);
  cbAtt.Color := clWindow;
end;

procedure TfrmWait.cbStatClick(Sender: TObject);
begin
  lblStar4.Caption := '';
  StatIFN := piece(cbStat.Items[cbStat.ItemIndex], '^', 1);
  cbStat.Color := clWindow;
end;

procedure TfrmWait.cbDisClick(Sender: TObject);
begin
  lblStar5.Caption := '';
  DisIFN := IntToStr(cbDis.ItemIEN);
  cbDis.Color := clWindow;
end;

function TfrmWait.CheckEdit(): integer;
begin
  Result := 1;
  if lblStar0.Caption = '>' then
    begin
     star0 := 1;
     Result := 0;
    end;
  if lblStar1.Caption = '>' then
    begin
     star1 := 1;
     Result := 0;
    end;
  if lblStar2.Caption = '>' then
    begin
      star2 := 1;
      Result := 0;
    end;
  if lblStar3.Caption = '>' then
    begin
      star3 := 1;
      Result := 0;
    end;
  if lblStar4.Caption = '>' then
    begin
      star4 := 1;
      Result := 0;
    end;
  if lblStar5.Caption = '>' then
    begin
      star5 := 1;
      Result := 0;
    end;
  if lblStar6.Caption = '>' then
    begin
      star6 := 1;
      Result := 0;
    end;
  if (list = 'W') then Exit;
  // issues
  if lblStar7.Caption = '<' then
    begin
      star7 := 1;
      Result := 0;
    end;
  if lblStar8.Caption = '<' then
    begin
      star8 := 1;
      Result := 0;
    end;
  if lblStar9.Caption = '<' then
    begin
      star9 := 1;
      Result := 0;
    end;
  if lblStar10.Caption = '<' then
    begin
      star10 := 1;
      Result := 0;
    end;
  // tasks
  if lblStar11.Caption = '<' then
    begin
      star11 := 1;
      Result := 0;
    end;
  if lblStar12.Caption = '<' then
    begin
      star12 := 1;
      Result := 0;
    end;
  if lblStar13.Caption = '<' then
    begin
      star13 := 1;
      Result := 0;
    end;
  if lblStar14.Caption = '<' then
    begin
      star14 := 1;
      Result := 0;
    end;
  if lblStar15.Caption = '>' then
    begin
      star15 := 1;
      Result := 0;
    end;
end;

procedure TfrmWait.cbProcChange(Sender: TObject);
begin
  if cbProc.Text = '' then
    begin
      cbProc.DroppedDown := False;
      Exit;
    end;
  cbProc.Items.Clear;
  CallV('APTWL GET PROC', [cbProc.Text]);
  cbProc.Items := RPCBrokerV.Results;
  cbProc.DroppedDown := True;
  Change := 1;
end;

procedure TfrmWait.cbProcClick(Sender: TObject);
begin
  lblStar0.Caption := '';
  LProcIFN  := IntToStr(cbProc.ItemIEN);
  LProcName := cbProc.Text;
  cbProc.Color := clWindow;
end;

procedure TfrmWait.cbTypeClick(Sender: TObject);
begin
  lblStar6.Caption := '';
  TypeIFN := cbType.ItemID;
  cbType.Color := clWindow;
end;

procedure TfrmWait.btnSaveClick(Sender: TObject);
begin
  if Change = 0 then
  begin
    ShowMessage('No changes were made!');
    Exit;
  end;
  CollectData;
  Success := sCallV('APTWL SAVE WAIT LIST', [SpecIFN, wlifn, ListType, lbFinal.Items, edMed1.Lines, edMed2.Lines, edMed3.Lines, edMed4.Lines, edTask1.Lines, edTask2.Lines, edTask3.Lines, edTask4.Lines, edWait.Lines, lbSec.Items, edGComm.Lines]);
  if piece(Success, '^', 1) = '0' then
    begin
      MessageDlg(piece(Success, '^', 2), mterror, [mbOK], 0);
      Exit;
    end;
  if SRM = 'G' then
    begin
      AddToListNote;
      Exit;
    end;
  MessageDlg(ListName + ' entry saved successfully.' + CRLF
     + 'Acession: ' + SpecAbbr + ' ' + piece(Success, '^', 2), mtinformation, [mbOK], 0);
  Close;
end;

procedure TfrmWait.cbLatChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmWait.memFindChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmWait.edDiagChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmWait.memBriefChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmWait.edTimeChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmWait.edLenChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmWait.edCompChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmWait.edOrdChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmWait.cbTypeChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmWait.cbStatChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmWait.cbDisChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmWait.edNeedChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmWait.edEqChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmWait.btnConClick(Sender: TObject);
begin
  CurrentConsult;
end;

procedure TfrmWait.HideMedClr;
begin
  lblMed.Visible    := False;
  lblMStat1.Visible := False;
  pcMed.Visible     := False;
  lblStar7.Caption  := '';
  lblStar8.Caption  := '';
  lblStar9.Caption  := '';
  lblStar10.Caption := '';
end;

procedure TfrmWait.HideTasks;
begin
  lblTask.Visible   := False;
  lblSStat1.Visible := False;
  pcTask.Visible    := False;
  lblStar11.Caption := '';
  lblStar12.Caption := '';
  lblStar13.Caption := '';
  lblStar14.Caption := '';
end;

procedure TfrmWait.btnOrdClick(Sender: TObject);
begin
  CurrentOrder;
end;

procedure TfrmWait.CheckStatus;
begin
  if (cbMed1.Text = '') and (cbMed2.Text = '') and (cbMed3.Text = '') and (cbMed4.Text = '') then lblMStat1.Caption := ''
  else CheckMedStatus;
  if (cbTask1.Text = '') and (cbTask2.Text = '') and (cbTask3.Text = '') and (cbTask4.Text = '') then lblSStat1.Caption := ''
  else CheckSurgStatus;
end;

procedure TfrmWait.CheckMedStatus;
begin
  if (cbMed1.Text <> '') and (cbxMed1.Checked = False) then
    begin
      NotComplete;
      Exit;
    end;
  if (cbMed2.Text <> '') and (cbxMed2.Checked = False) then
    begin
      NotComplete;
      Exit;
    end;
  if (cbMed3.Text <> '') and (cbxMed3.Checked = False) then
    begin
      NotComplete;
      Exit;
    end;
  if (cbMed4.Text <> '') and (cbxMed4.Checked = False) then
    begin
      NotComplete;
      Exit;
    end;
  Complete;
end;

procedure TfrmWait.CheckSurgStatus;
begin
  if (cbTask1.Text <> '') and (cbxTask1.Checked = False) then
      begin
        NotComplete2;
        Exit;
     end;
  if (cbTask2.Text <> '') and (cbxTask2.Checked = False) then
      begin
        NotComplete2;
        Exit;
     end;
  if (cbTask3.Text <> '') and (cbxTask3.Checked = False) then
      begin
        NotComplete2;
        Exit;
      end;
  if (cbTask4.Text <> '') and (cbxTask4.Checked = False) then
      begin
        NotComplete2;
        Exit;
      end;
  Complete2;
end;

procedure TfrmWait.cbMed1Change(Sender: TObject);
begin
  CheckStatus;
  Med1IFN := IntToStr(cbMed1.ItemIEN);
  Med1Enable;
  TabSheet1.Highlighted := True;
  Change := 1;
end;

procedure TfrmWait.cbxMed1Click(Sender: TObject);
begin
  CheckStatus;
  Change := 1;
end;

procedure TfrmWait.cbMed2Change(Sender: TObject);
begin
  CheckStatus;
  Med2IFN := IntToStr(cbMed2.ItemIEN);
  Med2Enable;
  TabSheet2.Highlighted := True;
  Change := 1;
end;

procedure TfrmWait.cbxMed2Click(Sender: TObject);
begin
  CheckStatus;
  Change := 1;
end;

procedure TfrmWait.cbMed3Change(Sender: TObject);
begin
  CheckStatus;
  Med3IFN := IntToStr(cbMed3.ItemIEN);
  Med3Enable;
  TabSheet3.Highlighted := True;
  Change := 1;
end;

procedure TfrmWait.cbxMed3Click(Sender: TObject);
begin
  CheckStatus;
  Change := 1;
end;

procedure TfrmWait.cbMed4Change(Sender: TObject);
begin
  CheckStatus;
  Med4IFN := IntToStr(cbMed4.ItemIEN);
  Med4Enable;
  TabSheet4.Highlighted := True;
  Change := 1;
end;

procedure TfrmWait.cbxMed4Click(Sender: TObject);
begin
  CheckStatus;
  Change := 1;
end;

procedure TfrmWait.DisableMedClr;
begin
  lblCon1.Enabled   := False;
  edCon1.Enabled    := False;
  lblOrder1.Enabled := False;
  edOrder1.Enabled  := False;
  lblCMed1.Enabled  := False;
  edMed1.Enabled    := False;
  cbxMed1.Enabled   := False;
  btnClr1.Enabled   := False;
  lblCon2.Enabled   := False;
  edCon2.Enabled    := False;
  lblOrder2.Enabled := False;
  edOrder2.Enabled  := False;
  lblCMed2.Enabled  := False;
  edMed2.Enabled    := False;
  cbxMed2.Enabled   := False;
  btnClr2.Enabled   := False;
  lblCon3.Enabled   := False;
  edCon3.Enabled    := False;
  lblOrder3.Enabled := False;
  edOrder3.Enabled  := False;
  lblCMed3.Enabled  := False;
  edMed3.Enabled    := False;
  cbxMed3.Enabled   := False;
  btnClr3.Enabled   := False;
  lblCon4.Enabled   := False;
  edCon4.Enabled    := False;
  lblOrder4.Enabled := False;
  edOrder4.Enabled  := False;
  lblCMed4.Enabled  := False;
  edMed4.Enabled    := False;
  cbxMed4.Enabled   := False;
  btnClr4.Enabled   := False;
  lblMStat1.Caption := '';
end;

procedure TfrmWait.DisableTasks;
begin
  lblTTask1.Enabled := False;
  edTask1.Enabled   := False;
  cbxTask1.Enabled  := False;
  btnTask1.Enabled  := False;
  lblTTask2.Enabled := False;
  edTask2.Enabled   := False;
  cbxTask2.Enabled  := False;
  btnTask2.Enabled  := False;
  lblTTask3.Enabled := False;
  edTask3.Enabled   := False;
  cbxTask3.Enabled  := False;
  btnTask3.Enabled  := False;
  lblTTask4.Enabled := False;
  edTask4.Enabled   := False;
  cbxTask4.Enabled  := False;
  btnTask4.Enabled  := False;
  lblSStat1.Caption := '';
end;

procedure TfrmWait.Med1Enable;
begin
  lblCon1.Enabled   := True;
  edCon1.Enabled    := True;
  lblOrder1.Enabled := True;
  edOrder1.Enabled  := True;
  lblCMed1.Enabled  := True;
  edMed1.Enabled    := True;
  cbxMed1.Enabled   := True;
  btnClr1.Enabled   := True;
end;

procedure TfrmWait.Med2Enable;
begin
  lblCon2.Enabled   := True;
  edCon2.Enabled    := True;
  lblOrder2.Enabled := True;
  edOrder2.Enabled  := True;
  lblCMed2.Enabled  := True;
  edMed2.Enabled    := True;
  cbxMed2.Enabled   := True;
  btnClr2.Enabled   := True;
end;

procedure TfrmWait.Med3Enable;
begin
  lblCon3.Enabled   := True;
  edCon3.Enabled    := True;
  lblOrder3.Enabled := True;
  edOrder3.Enabled  := True;
  lblCMed3.Enabled  := True;
  edMed3.Enabled    := True;
  cbxMed3.Enabled   := True;
  btnClr4.Enabled   := True;
end;

procedure TfrmWait.Med4Enable;
begin
  lblCon4.Enabled   := True;
  edCon4.Enabled    := True;
  lblOrder4.Enabled := True;
  edOrder4.Enabled  := True;
  lblCMed4.Enabled  := True;
  edMed4.Enabled    := True;
  cbxMed4.Enabled   := True;
  btnClr4.Enabled   := True;
end;

procedure TfrmWait.Task1Enable;
begin
  lblTTask1.Enabled := True;
  edTask1.Enabled   := True;
  cbxTask1.Enabled  := True;
  btnTask1.Enabled  := True;
end;

procedure TfrmWait.Task2Enable;
begin
  lblTTask2.Enabled := True;
  edTask2.Enabled   := True;
  cbxTask2.Enabled  := True;
  btnTask2.Enabled  := True;
end;

procedure TfrmWait.Task3Enable;
begin
  lblTTask3.Enabled := True;
  edTask3.Enabled   := True;
  cbxTask3.Enabled  := True;
  btnTask3.Enabled  := True;
end;

procedure TfrmWait.Task4Enable;
begin
  lblTTask4.Enabled := True;
  edTask4.Enabled   := True;
  cbxTask4.Enabled  := True;
  btnTask4.Enabled  := True;
end;

procedure TfrmWait.edCon1Change(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmWait.edOrder1Change(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmWait.edMed1Change(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmWait.edCon2Change(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmWait.edOrder2Change(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmWait.edMed2Change(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmWait.edCon3Change(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmWait.edOrder3Change(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmWait.edMed3Change(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmWait.edCon4Change(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmWait.edOrder4Change(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmWait.edMed4Change(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmWait.edWaitChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmWait.btnClr1Click(Sender: TObject);
begin
  cbMed1.Text      := '';
  edCon1.Text      := '';
  edOrder1.Text    := '';
  lblStar7.Caption := '';
  edMed1.Clear;
  cbxMed1.Checked  := False;
  TabSheet1.Highlighted := False;
  CheckStatus;
end;

procedure TfrmWait.btnClr2Click(Sender: TObject);
begin
  cbMed2.Text      := '';
  edCon2.Text      := '';
  edOrder2.Text    := '';
  lblStar8.Caption := '';
  edMed2.Clear;
  cbxMed2.Checked := False;
  TabSheet2.Highlighted := False;
  CheckStatus;
end;

procedure TfrmWait.btnClr3Click(Sender: TObject);
begin
  cbMed3.Text      := '';
  edCon3.Text      := '';
  edOrder3.Text    := '';
  lblStar9.Caption := '';
  edMed3.Clear;
  cbxMed3.Checked := False;
  TabSheet3.Highlighted := False;
  CheckStatus;
end;

procedure TfrmWait.btnClr4Click(Sender: TObject);
begin
  cbMed4.Text       := '';
  edCon4.Text       := '';
  edOrder4.Text     := '';
  lblStar10.Caption := '';
  edMed4.Clear;
  cbxMed4.Checked := False;
  TabSheet4.Highlighted := False;
  CheckStatus;
end;

procedure TfrmWait.cbMed1Click(Sender: TObject);
begin
  lblStar7.Caption := '';
  Med1IFN := IntToStr(cbMed1.ItemIEN);
  cbMed1.Color := clWindow;
end;

procedure TfrmWait.cbMed2Click(Sender: TObject);
begin
  lblStar8.Caption := '';
  Med2IFN := IntToStr(cbMed2.ItemIEN);
  cbMed2.Color := clWindow;
end;

procedure TfrmWait.cbMed3Click(Sender: TObject);
begin
  lblStar9.Caption := '';
  Med3IFN := IntToStr(cbMed3.ItemIEN);
  cbMed3.Color := clWindow;
end;

procedure TfrmWait.cbMed4Click(Sender: TObject);
begin
  lblStar10.Caption := '';
  Med4IFN := IntToStr(cbMed4.ItemIEN);
  cbMed4.Color := clWindow;
end;

procedure TfrmWait.NotComplete;
begin
  lblMStat1.Caption := 'Not Completed';
  lblMStat1.Font.Color := clRed ;
end;

procedure TfrmWait.Complete;
begin
  lblMStat1.Caption := 'Completed';
  lblMStat1.Font.Color := clGreen;
  CallV('APTWL SEND AR NOTIFICATION', [SpecIFN, wlifn, PtName]);
end;

procedure TfrmWait.cbTask1Change(Sender: TObject);
begin
  CheckStatus;
  Task1IFN := IntToStr(cbTask1.ItemIEN);
  Task1Enable;
  TabSheet5.Highlighted := True;
  Change := 1;
end;

procedure TfrmWait.cbTask1Click(Sender: TObject);
begin
  lblStar11.Caption := '';
  cbTask1.Color     := clWindow;
end;

procedure TfrmWait.cbTask2Change(Sender: TObject);
begin
  CheckStatus;
  Task2IFN := IntToStr(cbTask2.ItemIEN);
  Task2Enable;
  TabSheet6.Highlighted := True;
  Change := 1;
end;

procedure TfrmWait.cbTask2Click(Sender: TObject);
begin
  lblStar12.Caption := '';
  cbTask2.Color     := clWindow;
end;

procedure TfrmWait.cbTask3Change(Sender: TObject);
begin
  CheckStatus;
  Task3IFN := IntToStr(cbTask3.ItemIEN);
  Task3Enable;
  TabSheet7.Highlighted := True;
  Change := 1;
end;

procedure TfrmWait.cbTask3Click(Sender: TObject);
begin
  lblStar13.Caption := '';
  cbTask3.Color     := clWindow;
end;

procedure TfrmWait.cbTask4Change(Sender: TObject);
begin
  CheckStatus;
  Task4IFN := IntToStr(cbTask4.ItemIEN);
  Task4Enable;
  TabSheet8.Highlighted := True;
  Change := 1;
end;

procedure TfrmWait.cbTask4Click(Sender: TObject);
begin
  lblStar14.Caption := '';
  cbTask4.Color     := clWindow;
end;

procedure TfrmWait.cbxTask2Click(Sender: TObject);
begin
  CheckStatus;
  Change := 1;
end;

procedure TfrmWait.cbxTask3Click(Sender: TObject);
begin
  CheckStatus;
  Change := 1;
end;

procedure TfrmWait.cbxTask1Click(Sender: TObject);
begin
  CheckStatus;
  Change := 1;
end;

procedure TfrmWait.cbxTask4Click(Sender: TObject);
begin
  CheckStatus;
  Change := 1;
end;

procedure TfrmWait.btnTask1Click(Sender: TObject);
begin
  cbTask1.Text      := '';
  lblStar11.Caption := '';
  edTask1.Clear;
  cbxTask1.Checked  := False;
  TabSheet5.Highlighted := False;
  CheckStatus;
end;

procedure TfrmWait.btnTask2Click(Sender: TObject);
begin
  cbTask2.Text      := '';
  lblStar12.Caption := '';
  edTask2.Clear;
  cbxTask2.Checked  := False;
  TabSheet6.Highlighted := False;
  CheckStatus;
end;

procedure TfrmWait.btnTask3Click(Sender: TObject);
begin
  cbTask3.Text      := '';
  lblStar13.Caption := '';
  edTask3.Clear;
  cbxTask3.Checked  := False;
  TabSheet7.Highlighted := False;
  CheckStatus;
end;

procedure TfrmWait.btnTask4Click(Sender: TObject);
begin
  cbTask4.Text      := '';
  lblStar14.Caption := '';
  edTask4.Clear;
  cbxTask4.Checked  := False;
  TabSheet8.Highlighted := False;
  CheckStatus;
end;

procedure TfrmWait.cbCPTChange(Sender: TObject);
begin
  if cbCPT.Text = '' then
    begin
      cbCPT.DroppedDown := False;
      Exit;
    end;
  CallV('APTWL GET CPT', [cbCPT.Text]);
  cbCPT.Items := RPCBrokerV.Results;
  cbCPT.DroppedDown := True;
  Change := 1;
end;

procedure TfrmWait.cbCPTClick(Sender: TObject);
begin
  CPTIFN := IntToStr(cbCPT.ItemIEN);
end;

procedure TfrmWait.cbCompChange(Sender: TObject);
begin
  cbComp.DroppedDown := True;
  Change := 1;
end;

procedure TfrmWait.cbCompClick(Sender: TObject);
begin
  lblStar15.Caption := '';
  CompIFN := IntToStr(cbComp.ItemIEN);
  cbComp.Color := clWindow;
end;

procedure TfrmWait.edProcChange(Sender: TObject);
begin
  Change := 1;
  lblStar0.Caption := '';
  ProcName := edProc.Text;
end;

procedure TfrmWait.btnSecClick(Sender: TObject);
var
  I, Num: integer;
begin
  GetOther(lbSec, List);
  Num := lbSec.Items.Count;
  lbSec.Clear;
  with frmOther do
    begin
      if lbOther.Items.Count >0 then
        begin
          btnSec.Color      := clRed;
          btnSec.Font.Color := clWhite;
          for I := 0 to lbOther.Items.Count-1 do lbSec.Items.Add(lbOther.Items[I]);
        end
      else
        begin
          btnSec.Font.Color := clWindowText;
          btnSec.Color      := clBtnFace;
        end;
      if OtherChange = 1 then
        begin
          Change   := 1;
          OtChange := 1;
        end;
    end;
end;

procedure TfrmWait.NotComplete2;
begin
  lblSStat1.Caption := 'Not Completed';
  lblSStat1.Font.Color := clRed ;
end;

procedure TfrmWait.Complete2;
begin
  lblSStat1.Caption := 'Completed';
  lblSStat1.Font.Color := clGreen;
end;

procedure TfrmWait.cbResKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = 8 then
    begin
      if cbRes.Text = '' then
        begin
          lblStar2.Caption := '';
          ResIFN := '';
        end;
    end;
end;

procedure TfrmWait.edGCommChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmWait.cbSCChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmWait.cbSCClick(Sender: TObject);
begin
  SCIFN := IntToStr(cbSC.ItemIEN);
end;

procedure TfrmWait.edLocChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmWait.dbManualChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmWait.edTask1Change(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmWait.edTask2Change(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmWait.edTask3Change(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmWait.edTask4Change(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmWait.AddToListNote;
begin
  MessageDlg('Patient added to the ' + ListName + ' successfully.' + CRLF
      + 'Acession: ' + SpecAbbr + ' ' + piece(success, '^', 2), mtinformation, [mbOK], 0);
  if (Source = 1) or (SRM = 'G') then PutFlag := 1;
end;

end.
