unit fTree;
//  ptld/jit   7-1-08

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, ORCtrls, StdCtrls, ORNet, ORFn;

type
  TfrmTree = class(TForm)
    tvProc: TORTreeView;
    lbTemp: TORListBox;
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmTree: TfrmTree;

procedure DisplayTree;

implementation

{$R *.dfm}

uses SCMMain, fParam;

procedure DisplayTree;
var
  I: integer;
  PTreeNode1, PTreeNode2, PTreeNode3, PTreeNode4, PTreeNode5, tmpNode: TTreeNode;
  data, lev1nm, lev2nm, lev3nm, lev4nm, lev5nm: string;
  last1, last2, last3, last4, last5: string;
begin
  frmTree := TfrmTree.Create(Application);
  try
  with frmTree do
    begin
      CallV('APTWL GET TREE ROOTS', [SpecIFN]);
      lbTemp.Items := RPCBrokerV.Results;
      lev1nm  := '';
      lev2nm  := '';
      lev3nm  := '';
      lev4nm  := '';
      lev5nm  := '';
      for I := 0 to lbTemp.Items.Count -1 do
        begin
          data := lbTemp.Items[I];
          lev1nm := piece(data, '^', 1);
          lev2nm := piece(data, '^', 2);
          lev3nm := piece(data, '^', 3);
          lev4nm := piece(data, '^', 4);
          lev5nm := piece(data, '^', 5);
          if I = 0 then
            begin
              PTreeNode1 := tvProc.Items.Add(nil, lev1nm);
              TORTreeNode(PTreeNode1).StringData := lev1nm;
              last1 := lev1nm;
            end;
          if I > 0 then
            begin
              if (lev1nm <> '') and (lev1nm <> last1) then
                begin
                  tmpNode := tvProc.Items.Add(PTreeNode1, lev1nm);
                  TORTreeNode(tmpNode).StringData := lev1nm;
                  last1   := lev1nm;
                  PTreeNode1 := tmpNode;
                end;
              if (lev2nm <> '') and (lev2nm <> last2) then
                begin
                  tmpNode := tvProc.Items.AddChild(PTreeNode1, lev2nm);
                  TORTreeNode(tmpNode).StringData := lev2nm;
                  last2   := lev2nm;
                  PTreeNode2 := tmpNode;
                end;
              if (lev3nm <> '') and (lev3nm <> last3) then
                begin
                  tmpNode := tvProc.Items.AddChild(PTreeNode2, lev3nm);
                  TORTreeNode(tmpNode).StringData := lev3nm;
                  last3   := lev3nm;
                  PTreeNode3 := tmpNode;
                end;
              if (lev4nm <> '') and (lev4nm <> last4) then
                 begin
                  tmpNode := tvProc.Items.AddChild(PTreeNode3, lev4nm);
                  TORTreeNode(tmpNode).StringData := lev4nm;
                  last4   := lev4nm;
                  PTreeNode4 := tmpNode;
                end;
              if (lev5nm <> '') and (lev5nm <> last5) then
                 begin
                  tmpNode := tvProc.Items.AddChild(PTreeNode4, lev5nm);
                  TORTreeNode(tmpNode).StringData := lev5nm;
                  last5   := lev5nm;
                  PTreeNode5 := tmpNode;
                end;
            end;
        end;
      ShowModal;
    end;
  finally
    frmTree.Release;
  end;
end;

end.
