unit fTimeOut;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls;

type
  TfrmTimeOut = class(TForm)
    lblTime1: TLabel;
    lblTime2: TLabel;
    lblTime3: TLabel;
    btnTime: TButton;
    CountDown: TTimer;
    procedure btnTimeClick(Sender: TObject);
    procedure CountDownTimer(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmTimeOut: TfrmTimeOut;
  DispSec: integer;

procedure ApplicationTimeOut;

implementation

{$R *.dfm}

uses SCMMain;

procedure ApplicationTimeOut;
begin
  frmTimeOut := TfrmTimeOut.Create(Application);
  try
  with frmTimeOut do
    begin
      CountDown.Enabled := True;
      DispSec := 20;
      ShowModal;
    end;
  finally
    frmTimeOut.Release;
  end;
end;

procedure TfrmTimeOut.btnTimeClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmTimeOut.CountDownTimer(Sender: TObject);
begin
  DispSec := DispSec - 1;
  lblTime2.Caption := IntToStr(DispSec);
  if DispSec = 1 then lblTime3.Caption := 'second';
  if DispSec <6 then lblTime2.Font.Color := clRed;
  if DispSec <1 then frmSCMMain.Close;
end;

procedure TfrmTimeOut.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  Close;
end;

procedure TfrmTimeOut.FormClick(Sender: TObject);
begin
  Close;
end;

end.
