unit fTemp;
{ DATE CREATED:  9-99 }
{ CREATED BY:    user   user, PORTLAND VAMC }
{ DESCRIPTION:   CHILD OF fMailTo FOR SELECTING HOT LIST AND REMOTE PROVIDER }
{                NAMES }
{ MODIFIED:      2-22-00, 4-26-00 }

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, ORFn, ORCtrls;

type
  TfrmTemp = class(TForm)
    Panel1: TPanel;
    btnCancel: TButton;
    Label1: TLabel;
    Label2: TLabel;
    btnDone: TButton;
    lbTemp: TORListBox;
    lbFinal: TORListBox;
    Label3: TLabel;
    procedure btnCancelClick(Sender: TObject);
    procedure lbtempClick(Sender: TObject);
    procedure btnDoneClick(Sender: TObject);
    procedure frmTempCreate(Sender: TObject);
    procedure SiteCheck(Site: string);
  private
    { Private declarations }
  public
    { Public declarations }
    frmTemp: TfrmTemp;
  end;

var
  frmTemp: TfrmTemp;
  Cap: string;
  vaOK: integer;

procedure TempList(TempList: TListBox; Cap: string);

implementation

{$R *.DFM}

procedure TempList(TempList: TListBox; Cap: string);
var
  I: integer;
begin
  frmTemp := TfrmTemp.Create(Application);
  with frmTemp do
  begin
    Caption := Cap;
    lbTemp.Clear;
    for I := 0 to TempList.Items.Count-1 do lbTemp.Items.Add(TempList.Items[I]);
    ShowModal;
  end;
  frmTemp.Release;
end;

procedure TfrmTemp.btnCancelClick(Sender: TObject);
begin
  lbFinal.Clear;
  Close;
end;

procedure TfrmTemp.lbTempClick(Sender: TObject);
begin
  SiteCheck(piece(lbTemp.Items[lbtemp.ItemIndex], '^', 3));
  if vaOK = 0 then
    begin
      MessageDlg('Cannot send patient data to a non-VA site!!', mtinformation, [mbok], 0);
      Exit;
    end;
  lbFinal.Items.Add(piece(lbTemp.Items[lbTemp.ItemIndex], '^', 2) + '@' +
  piece(lbTemp.Items[lbTemp.ItemIndex], '^', 3));
end;

procedure TfrmTemp.btnDoneClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmTemp.frmTempCreate(Sender: TObject);
begin
  frmTemp.Caption := Cap;
end;

procedure TfrmTemp.SiteCheck(Site: string);
begin
  vaOK := 0;
  if piece(Site, '.', 2) = 'va' then vaOK := 1;
  if piece(Site, '.', 3) = 'va' then vaOK := 1;
  if piece(Site, '.', 2) = 'VA' then vaOK := 1;
  if piece(Site, '.', 3) = 'VA' then vaOK := 1;
end;

end.
