unit fSymptom;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ORCtrls, StdCtrls, ORNet, ORFn, ExtCtrls, Buttons;

type
  TfrmSymptom = class(TForm)
    lblSymptom: TLabel;
    lbSymptom: TORListBox;
    btnSAdd: TButton;
    btnSEdit: TButton;
    btnSDel: TButton;
    btnSExit: TButton;
    pnlSel: TPanel;
    lblSymptom1: TLabel;
    btnOK: TButton;
    edSymptom: TEdit;
    btnUp: TBitBtn;
    btnDown: TBitBtn;
    procedure btnSExitClick(Sender: TObject);
    procedure DisableSel;
    procedure EnableSel;
    procedure btnSAddClick(Sender: TObject);
    procedure lbSymptomClick(Sender: TObject);
    procedure btnSEditClick(Sender: TObject);
    procedure btnSDelClick(Sender: TObject);
    procedure edSymptomChange(Sender: TObject);
    procedure btnOKClick(Sender: TObject);
    procedure RefreshSympList;
    procedure DisableSMenu;
    procedure btnUpClick(Sender: TObject);
    procedure btnDownClick(Sender: TObject);
    procedure SaveSList;
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmSymptom: TfrmSymptom;
  SChange, SEdit, New: integer;
  SympIFN: string;

procedure GetSymptom;

implementation

{$R *.dfm}

uses fParam, SCMMain, fSubGroup;

procedure GetSymptom;
begin
  frmSymptom := TfrmSymptom.Create(Application);
  try
  with frmSymptom do
    begin
      if GroupType = 'S' then lblSymptom.Caption := 'Symptoms for SubGroup ' + SGroupName
      else lblSymptom.Caption := 'Symptoms for ' + GroupName;
      RefreshSympList;
      SChange := 0;
      SEdit  := 0;
      SympIFN := '';
      //DisableSel;
      DisableSel;
      DisableSMenu;
      ShowModal;
    end;
  finally
    frmSymptom.Release;
  end;
end;

procedure TfrmSymptom.btnSExitClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmSymptom.DisableSel;
begin
  lblSymptom1.Enabled := False;
  edSymptom.Enabled   := False;
  btnOK.Enabled       := False;
  pnlSel.Enabled      := False;
end;

procedure TfrmSymptom.EnableSel;
begin
  lblSymptom1.Enabled := True;
  edSymptom.Enabled   := True;
  btnOK.Enabled       := True;
  pnlSel.Enabled      := True;
end;

procedure TfrmSymptom.btnSAddClick(Sender: TObject);
begin
  EnableSel;
  SEdit := 0;
  edSymptom.Text := '';
  lblSymptom1.Caption := 'Enter Symptom Name:';
  edSymptom.SetFocus;
end;

procedure TfrmSymptom.lbSymptomClick(Sender: TObject);
begin
  if lbSymptom.Items.Count = 0 then Exit;
  SympIFN := IntToStr(lbSymptom.ItemIEN);
  btnSEdit.Enabled := True;
  btnSDel.Enabled  := True;
  btnUp.Enabled    := True;
  btnDown.Enabled  := True;
end;

procedure TfrmSymptom.btnSEditClick(Sender: TObject);
begin
  EnableSel;
  lblSymptom1.Caption := 'Edit Symptom Name:';
  edSymptom.Text := piece(lbSymptom.Items[lbSymptom.ItemIndex], '^', 2);
  SEdit := 1;
  edSymptom.SetFocus;
end;

procedure TfrmSymptom.btnSDelClick(Sender: TObject);
begin
  edSymptom.Text := '';
  if MessageDlg('Are you sure you want to delete ' + piece(lbSymptom.Items[lbSymptom.ItemIndex], '^', 2), mtInformation, [mbYes,mbNo],0) = mrYes then
    begin
      CallV('APTWL DEL SPEC GRP SYMP', [SpecIFN, GroupIFN, SGroupIFN, SympIFN]);
      RefreshSympList;
    end;
  DisableSel;
  DisableSMenu;
end;

procedure TfrmSymptom.edSymptomChange(Sender: TObject);
begin
  SChange := 1;
  btnOK.Default := True;
end;

procedure TfrmSymptom.btnOKClick(Sender: TObject);
begin
  if edSymptom.Text = '' then
    begin
      DisableSel;
      Exit;
    end;
  if SEdit = 1 then
    begin
      if SChange = 0 then
        begin
          DisableSel;
          Exit;
        end;
      CallV('APTWL EDIT SPEC GRP SYMP', [SpecIFN, GroupIFN, SGroupIFN, SympIFN, edSymptom.Text]);
      RefreshSympList;
      SEdit  := 0;
      SChange := 0;
      edSymptom.Text := '';
    end
  else
    begin
      CallV('APTWL PUT SPEC GRP SYMP', [SpecIFN, GroupIFN, SGroupIFN, edSymptom.Text]);
      RefreshSympList;
      edSymptom.Text := '';
    end;
  DisableSel;
  DisableSMenu;
  btnOK.Default := False;
end;

procedure TfrmSymptom.RefreshSympList;
begin
  if GroupType = 'G' then CallV('APTWL GET SPEC GRP SYMP', [SpecIFN, GroupIFN])
  else CallV('APTWL GET SPEC SGRP SYMP', [SpecIFN, GroupIFN, SGroupIFN]);
  lbSymptom.Items := RPCBrokerV.Results;
end;

procedure TfrmSymptom.DisableSMenu;
begin
  btnSEdit.Enabled := False;
  btnSDel.Enabled  := False;
  btnSAdd.Enabled  := True;
end;

procedure TfrmSymptom.btnUpClick(Sender: TObject);
begin
  New := lbSymptom.ItemIndex - 1;
  SaveSList;
end;

procedure TfrmSymptom.btnDownClick(Sender: TObject);
begin
  New := lbSymptom.ItemIndex + 1;
  SaveSList;
end;

procedure TfrmSymptom.SaveSList;
begin
  lbSymptom.Items.Move(lbSymptom.ItemIndex, New);
  lbSymptom.ItemIndex := New;
  if SGroupIFN = '' then CallV('APTWL PUT SPEC PROC LST', [SpecIFN, GroupIFN, 5, lbSymptom.Items])
  else CallV('APTWL PUT SPEC PROC SG LST', [SpecIFN, GroupIFN, SGroupIFN, 4, lbSymptom.Items]);
end;

end.
