unit fSubGroup;
// ptld/jit  6-26-08

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, ORCtrls, ORNet, ORFn, Buttons;

type
  TfrmSubGroup = class(TForm)
    lblSGroup: TLabel;
    lbSGroup: TORListBox;
    btnSGAdd: TButton;
    btnSGEdit: TButton;
    btnSGDel: TButton;
    pnlSGroup: TPanel;
    lblSGroup2: TLabel;
    edSGroup: TEdit;
    btnSGOK: TButton;
    btnSAProc: TButton;
    btnSADiag: TButton;
    btnSASymp: TButton;
    btnExit: TButton;
    btnSATree: TButton;
    btnUp: TBitBtn;
    btnDown: TBitBtn;
    procedure btnSAProcClick(Sender: TObject);
    procedure lbSGroupClick(Sender: TObject);
    procedure DisableSel;
    procedure EnableSel;
    procedure btnSGAddClick(Sender: TObject);
    procedure btnSGEditClick(Sender: TObject);
    procedure btnSGOKClick(Sender: TObject);
    procedure btnSADiagClick(Sender: TObject);
    procedure btnSGDelClick(Sender: TObject);
    procedure btnSASympClick(Sender: TObject);
    procedure btnExitClick(Sender: TObject);
    procedure RefreshSGroupList;
    procedure edSGroupChange(Sender: TObject);
    procedure DisableSGroup;
    procedure EnableSGroup;
    procedure btnSATreeClick(Sender: TObject);
    procedure DisableSGMenu;
    procedure EnableSGMenu;
    procedure DisableLMenu;
    procedure btnDownClick(Sender: TObject);
    procedure btnUpClick(Sender: TObject);
    procedure SaveSGList;
  private
    { Private declarations }
  public
    { Public declarations }
    frmSubGroup: TfrmSubGroup;
  end;

var
  frmSubGroup: TfrmSubGroup;
  SGChange, SGEdit, New: integer;

procedure GetSubGroup;

implementation

{$R *.dfm}

uses fParam, fProcedure, fDiagnosis, fSymptom, SCMMain, fTree;

procedure GetSubGroup;
begin
  frmSubGroup := TfrmSubGroup.Create(Application);
  try
  with frmSubGroup do
    begin
      lblSGroup.Caption := 'Sub Groups for ' + GroupName;
      RefreshSGroupList;
      DisableSel;
      DisableSGMenu;
      SGChange   := 0;
      SGEdit     := 0;
      SGroupIFN  := '';
      SGroupName := '';
      ShowModal;
    end;
  finally
    frmSubGroup.Release;
  end;
end;

procedure TfrmSubGroup.btnSAProcClick(Sender: TObject);
begin
  DisableSGroup;
  edSGroup.Text := '';
  GetProcedures;
end;

procedure TfrmSubGroup.lbSGroupClick(Sender: TObject);
begin
  if lbSGroup.Items.Count = 0 then Exit;
  SGroupName := piece(lbSGroup.Items[lbSGroup.ItemIndex], '^', 2);
  SGroupIFN  := IntToStr(lbSGroup.ItemIEN);
  GroupType  := 'S';
  btnSGEdit.Enabled := True;
  btnSGDel.Enabled  := True;
  btnUp.Enabled     := True;
  btnDown.Enabled   := True;
  EnableSGMenu;
end;

procedure TfrmSubGroup.DisableSel;
begin
  btnSGEdit.Enabled  := False;
  btnSGDel.Enabled   := False;
  pnlSGroup.Enabled  := False;
  lblSGroup2.Enabled := False;
  edSGroup.Enabled   := False;
  btnSGOK.Enabled    := False;
end;

procedure TfrmSubGroup.EnableSel;
begin
  btnSGEdit.Enabled  := True;
  btnSGDel.Enabled   := True;
  pnlSGroup.Enabled  := True;
  lblSGroup2.Enabled := True;
  edSGroup.Enabled   := True;
  btnSGOK.Enabled    := True;
end;

procedure TfrmSubGroup.btnSGAddClick(Sender: TObject);
begin
  pnlSGroup.Enabled  := True;
  lblSGroup2.Enabled := True;
  edSGroup.Enabled   := True;
  btnSGOK.Enabled    := True;
  DisableSGMenu;
  SGEdit := 0;
  lblSGroup2.Caption := 'Enter SubGroup Name:';
  edSGroup.Text := '';
  edSGroup.SetFocus;
end;

procedure TfrmSubGroup.btnSGEditClick(Sender: TObject);
begin
  pnlSGroup.Enabled  := True;
  lblSGroup2.Enabled := True;
  edSGroup.Enabled   := True;
  btnSGOK.Enabled    := True;
  DisableSGMenu;
  lblSGroup2.Caption := 'Edit SubGroup Name:';
  edSGroup.Text      := piece(lbSGroup.Items[lbSGroup.ItemIndex], '^', 2);
  SGEdit := 1;
  edSGroup.SetFocus;
end;

procedure TfrmSubGroup.btnSGOKClick(Sender: TObject);
var
  success: string;
begin
  if edSGroup.Text = '' then
    begin
      DisableSel;
      Exit;
    end;
  if SGEdit = 1 then
    begin
      if SGChange = 0 then
        begin
          DisableSel;
          Exit;
        end;
      CallV('APTWL EDIT SPEC PROC SGRP', [SpecIFN, GroupIFN, SGroupIFN, edSGroup.Text]);
      RefreshSGroupList;
      SGEdit  := 0;
      SGChange := 0;
      edSGroup.Text := '';
    end
  else
    begin
      success := sCallV('APTWL PUT SPEC PROC SGRP', [SpecIFN, GroupIFN, edSGroup.Text]);
      RefreshSGroupList;
      edSGroup.Text := '';
    end;
  DisableSel;
  btnSGOK.Default := False;
end;

procedure TfrmSubGroup.btnSADiagClick(Sender: TObject);
begin
  DisableSGroup;
  edSGroup.Text := '';
  GetDiagnosis;
end;

procedure TfrmSubGroup.btnSGDelClick(Sender: TObject);
var
  Result: string;
begin
  edSGroup.Text := '';
  DisableSGMenu;
  Result := sCallV('APTWL SGRP HAS CHILD', [SpecIFN, GroupIFN, SGroupIFN]);
  if Result <> '' then MessageDlg('This SubGroup has ' + Result, mtinformation, [mbOK],0);
  if MessageDlg('Are you sure you want to delete ' + piece(lbSGroup.Items[lbSGroup.ItemIndex], '^', 2), mtInformation, [mbYes,mbNo],0) = mrYes then
    begin
      CallV('APTWL DEL SPEC PROC SGRP', [SpecIFN, GroupIFN, SGroupIFN]);
      RefreshSGroupList;
    end;
  DisableSel;
end;

procedure TfrmSubGroup.btnSASympClick(Sender: TObject);
begin
  DisableSGroup;
  edSGroup.Text := '';
  GetSymptom;
end;

procedure TfrmSubGroup.btnExitClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmSubGroup.RefreshSGroupList;
begin
  CallV('APTWL GET SPEC GRP SUBG', [SpecIFN, GroupIFN]);
  lbSGroup.Items := RPCBrokerV.Results;
end;

procedure TfrmSubGroup.edSGroupChange(Sender: TObject);
begin
  SGChange := 1;
  btnSGOK.Default := True;
end;

procedure TfrmSubGroup.DisableSGroup;
begin
  pnlSGroup.Enabled  := False;
  lblSGroup2.Enabled := False;
  edSGroup.Enabled   := False;
  btnSGOK.Enabled    := False;
end;

procedure TfrmSubGroup.EnableSGroup;
begin
  pnlSGroup.Enabled  := True;
  lblSGroup2.Enabled := True;
  edSGroup.Enabled   := True;
  btnSGOK.Enabled    := True;
end;

procedure TfrmSubGroup.btnSATreeClick(Sender: TObject);
begin
  DisplayTree;
end;

procedure TfrmSubGroup.DisableSGMenu;
begin
  btnSAProc.Enabled := False;
  btnSADiag.Enabled := False;
  btnSASymp.Enabled := False;
end;

procedure TfrmSubGroup.EnableSGMenu;
begin
  btnSAProc.Enabled := True;
  btnSADiag.Enabled := True;
  btnSASymp.Enabled := True;
end;

procedure TfrmSubGroup.DisableLMenu;
begin
  btnSGEdit.Enabled := False;
  btnSGDel.Enabled  := False;
  btnSGAdd.Enabled  := True;
end;

procedure TfrmSubGroup.btnDownClick(Sender: TObject);
begin
  New := lbSGroup.ItemIndex + 1;
  SaveSGList;
end;

procedure TfrmSubGroup.btnUpClick(Sender: TObject);
begin
  New := lbSGroup.ItemIndex - 1;
  SaveSGList;
end;

procedure TfrmSubGroup.SaveSGList;
begin
  lbSGroup.Items.Move(lbSGroup.ItemIndex, New);
  lbSGroup.ItemIndex := New;
  CallV('APTWL PUT SPEC PROC LST', [SpecIFN, GroupIFN, 1, lbSGroup.Items]);
end;

end.
