unit fRealTime;
// ptld/jit   8-31-09

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids, ORCtrls, ComCtrls, ORFn, ORNet, StdCtrls, ExtCtrls;

type
  TfrmRealTime = class(TForm)
    stgrTop: TCaptionStringGrid;
    hcTop: THeaderControl;
    hcMid: THeaderControl;
    stgrMid: TCaptionStringGrid;
    btnClose: TButton;
    timStart: TTimer;
    lbTemp: TORListBox;
    timRefresh: TTimer;
    lblCount: TLabel;
    hcBot: THeaderControl;
    stgrBot: TCaptionStringGrid;
    timScroll: TTimer;
    procedure stgrTopClick(Sender: TObject);
    procedure btnCloseClick(Sender: TObject);
    procedure timStartTimer(Sender: TObject);
    procedure FillReal;
    procedure ClearCells;
    procedure timRefreshTimer(Sender: TObject);
    procedure RefreshReal;
    procedure GetData;
    procedure timScrollTimer(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmRealTime: TfrmRealTime;
  RCount, scroll: integer;
  Data, Room, OPIFN, SpecN, Info, IType, IName, header: string;
  PPatN, PProc, PPatIn, PatN, Proc, Hold, Anti, AnStrt, PatIn, OpStrt, OpEnd, PatOut, AnEnd: string;
  NPatn, NProc, NHold, NAnti, NAnSt, LPatN, LProc, LOpEnd, Att, LPatIn, LPatOut, LPACU: string;
  PPatOut, PPACU: string;

procedure GetRealTime(OpDate: string);

implementation

{$R *.dfm}

uses SCMMain;

procedure GetRealTime(OpDate: string);
begin
  frmRealTime := TfrmRealTime.Create(Application);
  try
  with frmRealTime do
    begin
      RCount := 0;
      scroll := 0;
      frmRealTime.Caption :=  'Real Time OR Activity for ' + DateToStr(Date);
      ShowModal;
    end;
  finally
    frmRealTime.Release;
  end;
end;

procedure TfrmRealTime.stgrTopClick(Sender: TObject);
begin
  RefreshReal;
end;

procedure TfrmRealTime.btnCloseClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmRealTime.timStartTimer(Sender: TObject);
begin
  timStart.Enabled := False;
  RefreshReal;
  timRefresh.Enabled := True;
end;

procedure TfrmRealTime.FillReal;
var
  Cell: TRect;
  xcoord, ycoord, ACol, ARow, Quit: integer;
  Block, ID, glw, J, x, y: integer;
begin
  if lbTemp.Items.Count = 0 then Exit;
  ClearCells;
  Quit := 0;
  // first row
  for Block := 0 to 4 do
    begin
      Data   := lbTemp.Items[Block];
      if Data = '' then
        begin
          Quit := 1;
          Break;
        end;
      GetData;
      stgrTop.Canvas.Brush.Style := bsSolid;
      stgrTop.Canvas.Font.Color  := clBlack;
      stgrTop.Canvas.Font.Size   := 8;
      hcTop.Sections[Block].Text := '      ' + Room;
      ACol := Block;
      ARow := 0;
      Cell := stgrTop.CellRect(ACol, ARow);
      stgrTop.Canvas.FillRect(Cell);
      glw := stgrTop.GridLineWidth;
      xcoord := ACol * (stgrTop.DefaultColWidth + glw) + 6;
      ycoord := ARow * (stgrTop.DefaultRowHeight + glw) + 4;
      if PPatN <> '' then
        begin
          if PPatN = 'NO SCHEDULED CASES' then
            begin
              stgrTop.Canvas.Font.Color := clPurple;
              stgrTop.Canvas.Font.Style := [fsBold];
              stgrTop.Canvas.TextOut(xcoord, ycoord, PPatN);
              Quit := 1;
              Break;
            end;
          stgrTop.Canvas.Font.Color := clGreen;
          stgrTop.Canvas.TextOut(xcoord, ycoord, 'Previous: ' + PPatN);
          stgrTop.Canvas.Font.Color := clBlack;
          ycoord := ycoord + 12;
          stgrTop.Canvas.TextOut(xcoord, ycoord, PProc);
          ycoord := ycoord + 12;
          xcoord := xcoord + 8;
          stgrTop.Canvas.TextOut(xcoord, ycoord, 'Pat In:        ' + PPatIn);
          ycoord := ycoord + 12;
          stgrTop.Canvas.TextOut(xcoord, ycoord, 'Pat Out:      ' + PPatOut);
          ycoord := ycoord + 12;
          stgrTop.Canvas.TextOut(xcoord, ycoord, 'PACU Out: ' + PPACU);
          xcoord := xcoord - 8;
          ycoord := ycoord + 24;
        end;
      if OPIFN <> '' then
        begin
          stgrTop.Canvas.Font.Color := clRed;
          stgrTop.Canvas.TextOut(xcoord, ycoord, 'In Progress: ' + PatN);
          stgrTop.Canvas.Font.Color := clBlack;
          ycoord := ycoord + 12;
          stgrTop.Canvas.TextOut(xcoord, ycoord, SpecN);
          ycoord := ycoord + 12;
          stgrTop.Canvas.TextOut(xcoord, ycoord, Proc);
          ycoord := ycoord + 12;
          stgrTop.Canvas.TextOut(xcoord, ycoord, Att);
          ycoord := ycoord + 12;
          xcoord := xcoord + 8;
          stgrTop.Canvas.TextOut(xcoord, ycoord, 'Hold Area:   ' + Hold);
          ycoord := ycoord + 12;
          stgrTop.Canvas.TextOut(xcoord, ycoord, 'Anes Start:  ' + AnStrt);
          ycoord := ycoord + 12;
          stgrTop.Canvas.TextOut(xcoord, ycoord, 'Antibiotic:    ' + Anti);
          ycoord := ycoord + 12;
          stgrTop.Canvas.TextOut(xcoord, ycoord, 'Patient In:   ' + PatIn);
          ycoord := ycoord + 12;
          stgrTop.Canvas.TextOut(xcoord, ycoord, 'Op Start:     ' + OpStrt);
          ycoord := ycoord + 12;
          stgrTop.Canvas.TextOut(xcoord, ycoord, 'Op End:      ' + OpEnd);
          ycoord := ycoord + 12;
          stgrTop.Canvas.TextOut(xcoord, ycoord, 'Patient Out: ' + PatOut);
          ycoord := ycoord + 12;
          stgrTop.Canvas.TextOut(xcoord, ycoord, 'Anes End:    ' + AnEnd);
          ycoord := ycoord + 24;
          xcoord := xcoord - 8;
        end;
      if NPatN <> '' then
        begin
          if (PPatN <> '') or (PatN <> '') then
            begin
              header := 'Next: ';
              stgrTop.Canvas.Font.Color := clOlive;
            end
          else
            begin
              header := 'First: ';
              stgrTop.Canvas.Font.Color := clBlue;
            end;
          stgrTop.Canvas.TextOut(xcoord, ycoord, header + NPatN);
          stgrTop.Canvas.Font.Color := clBlack;
          ycoord := ycoord + 12;
          stgrTop.Canvas.TextOut(xcoord, ycoord, NProc);
          ycoord := ycoord + 12;
          xcoord := xcoord + 8;
          stgrTop.Canvas.TextOut(xcoord, ycoord, 'Hold Area:   ' + NHold);
          ycoord := ycoord + 12;
          {stgrTop.Canvas.TextOut(xcoord, ycoord, 'Antibiotic:    ' + NAnti);
          ycoord := ycoord + 12;
          stgrTop.Canvas.TextOut(xcoord, ycoord, 'Anes Start: ' + NAnSt);}
          xcoord := xcoord - 8;
        end;
      if LPatN <> '' then
        begin
          stgrTop.Canvas.Font.Color := clPurple;
          stgrTop.Canvas.TextOut(xcoord, ycoord, 'Last: ' + LPatN);
          stgrTop.Canvas.Font.Color := clBlack;
          ycoord := ycoord + 12;
          stgrTop.Canvas.TextOut(xcoord, ycoord, LProc);
          ycoord := ycoord + 12;
          xcoord := xcoord + 8;
          stgrTop.Canvas.TextOut(xcoord, ycoord, 'Pat In:        ' + LPatIn);
          ycoord := ycoord + 12;
          stgrTop.Canvas.TextOut(xcoord, ycoord, 'Pat Out:     ' + LPatOut);
          ycoord := ycoord + 12;
          stgrTop.Canvas.TextOut(xcoord, ycoord, 'PACU Out: ' + LPACU);
          xcoord := xcoord - 8;
        end;
      ycoord := ycoord + 24;
    end;
  if Quit = 1 then Exit;
  // second row
  for Block := 0 to 4 do
    begin
      Data   := lbTemp.Items[Block + 5];
      if Data = '' then
        begin
          Quit := 1;
          Break;
        end;
      GetData;
      stgrMid.Canvas.Brush.Style := bsSolid;
      stgrMid.Canvas.Font.Color  := clBlack;
      stgrMid.Canvas.Font.Size   := 8;
      hcMid.Sections[Block].Text := '      ' + Room;
      ACol := Block;
      ARow := 0;
      Cell := stgrMid.CellRect(ACol, ARow);
      stgrMid.Canvas.FillRect(Cell);
      glw := stgrMid.GridLineWidth;
      xcoord := ACol * (stgrMid.DefaultColWidth + glw) + 6;
      ycoord := ARow * (stgrMid.DefaultRowHeight + glw) + 4;
      if PPatN <> '' then
        begin
          stgrMid.Canvas.Font.Color := clGreen;
          stgrMid.Canvas.TextOut(xcoord, ycoord, 'Previous: ' + PPatN);
          stgrMid.Canvas.Font.Color := clBlack;
          ycoord := ycoord + 12;
          stgrMid.Canvas.TextOut(xcoord, ycoord, PProc);
          ycoord := ycoord + 12;
          xcoord := xcoord + 8;
          stgrMid.Canvas.TextOut(xcoord, ycoord, 'Pat In:         ' + PPatIn);
          ycoord := ycoord + 12;
          stgrMid.Canvas.TextOut(xcoord, ycoord, 'Pat Out:      ' + PPatOut);
          ycoord := ycoord + 12;
          stgrMid.Canvas.TextOut(xcoord, ycoord, 'PACU Out: ' + PPACU);
          xcoord := xcoord - 8;
          ycoord := ycoord + 24;
        end;
      if OPIFN <> '' then
        begin
          stgrMid.Canvas.Font.Color := clRed;
          stgrMid.Canvas.TextOut(xcoord, ycoord, 'In Progress: ' + PatN);
          stgrMid.Canvas.Font.Color := clBlack;
          ycoord := ycoord + 12;
          stgrMid.Canvas.TextOut(xcoord, ycoord, SpecN);
          ycoord := ycoord + 12;
          stgrMid.Canvas.TextOut(xcoord, ycoord, Proc);
          ycoord := ycoord + 12;
          stgrMid.Canvas.TextOut(xcoord, ycoord, Att);
          ycoord := ycoord + 12;
          xcoord := xcoord + 8;
          stgrMid.Canvas.TextOut(xcoord, ycoord, 'Hold Area:   ' + Hold);
          ycoord := ycoord + 12;
          stgrMid.Canvas.TextOut(xcoord, ycoord, 'Anes Start:  ' + AnStrt);
          ycoord := ycoord + 12;
          stgrMid.Canvas.TextOut(xcoord, ycoord, 'Antibiotic:    ' + Anti);
          ycoord := ycoord + 12;
          stgrMid.Canvas.TextOut(xcoord, ycoord, 'Patient In:   ' + PatIn);
          ycoord := ycoord + 12;
          stgrMid.Canvas.TextOut(xcoord, ycoord, 'Op Start:     ' + OpStrt);
          ycoord := ycoord + 12;
          stgrMid.Canvas.TextOut(xcoord, ycoord, 'Op End:      ' + OpEnd);
          ycoord := ycoord + 12;
          stgrMid.Canvas.TextOut(xcoord, ycoord, 'Patient Out: ' + PatOut);
          ycoord := ycoord + 12;
          stgrMid.Canvas.TextOut(xcoord, ycoord, 'Anes End:    ' + AnEnd);
          ycoord := ycoord + 24;
          xcoord := xcoord - 8;
        end;
      if NPatN <> '' then
        begin
          if (PPatN <> '') or (PatN <> '') then
            begin
              header := 'Next: ';
              stgrMid.Canvas.Font.Color := clOlive;
            end
          else
            begin
              header := 'First: ';
              stgrMid.Canvas.Font.Color := clBlue;
            end;
          stgrMid.Canvas.TextOut(xcoord, ycoord, header + NPatN);
          stgrMid.Canvas.Font.Color := clBlack;
          ycoord := ycoord + 12;
          stgrMid.Canvas.TextOut(xcoord, ycoord, NProc);
          ycoord := ycoord + 12;
          xcoord := xcoord + 8;
          stgrMid.Canvas.TextOut(xcoord, ycoord, 'Hold Area:   ' + NHold);
          ycoord := ycoord + 12;
          {stgrMid.Canvas.TextOut(xcoord, ycoord, 'Antibiotic:    ' + NAnti);
          ycoord := ycoord + 12;
          stgrMid.Canvas.TextOut(xcoord, ycoord, 'Anes Start: ' + NAnSt); }
          xcoord := xcoord - 8;
        end;
      if LPatN <> '' then
        begin
          stgrMid.Canvas.Font.Color := clPurple;
          stgrMid.Canvas.TextOut(xcoord, ycoord, 'Last: ' + LPatN);
          stgrMid.Canvas.Font.Color := clBlack;
          ycoord := ycoord + 12;
          stgrMid.Canvas.TextOut(xcoord, ycoord, LProc);
          ycoord := ycoord + 12;
          xcoord := xcoord + 8;
          stgrMid.Canvas.TextOut(xcoord, ycoord, 'Pat In:        ' + LPatIn);
          ycoord := ycoord + 12;
          stgrMid.Canvas.TextOut(xcoord, ycoord, 'Pat Out:     ' + LPatOut);
          ycoord := ycoord + 12;
          stgrMid.Canvas.TextOut(xcoord, ycoord, 'PACU Out: ' + LPACU);
          xcoord := xcoord - 8;
        end;
      ycoord := ycoord + 24;
    end;
  if Quit = 1 then Exit;
  // third row
  for Block := 0 to 4 do
    begin
      Data   := lbTemp.Items[Block + 10];
      if Data = '' then
        begin
          Quit := 1;
          Break;
        end;
      GetData;
      stgrBot.Canvas.Brush.Style := bsSolid;
      stgrBot.Canvas.Font.Color  := clBlack;
      stgrBot.Canvas.Font.Size   := 8;
      hcBot.Sections[Block].Text := '      ' + Room;
      ACol := Block;
      ARow := 0;
      Cell := stgrBot.CellRect(ACol, ARow);
      stgrBot.Canvas.FillRect(Cell);
      glw := stgrBot.GridLineWidth;
      xcoord := ACol * (stgrBot.DefaultColWidth + glw) + 6;
      ycoord := ARow * (stgrBot.DefaultRowHeight + glw) + 4;
      if PPatN <> '' then
        begin
          stgrBot.Canvas.Font.Color := clGreen;
          stgrBot.Canvas.TextOut(xcoord, ycoord, 'Previous: ' + PPatN);
          stgrBot.Canvas.Font.Color := clBlack;
          ycoord := ycoord + 12;
          stgrBot.Canvas.TextOut(xcoord, ycoord, PProc);
          ycoord := ycoord + 12;
          xcoord := xcoord + 8;
          stgrBot.Canvas.TextOut(xcoord, ycoord, 'Pat In:       ' + PPatIn);
          ycoord := ycoord + 12;
          stgrBot.Canvas.TextOut(xcoord, ycoord, 'Pat Out:     ' + PPatOut);
          ycoord := ycoord + 12;
          stgrBot.Canvas.TextOut(xcoord, ycoord, 'PACU Out: ' + PPACU);
          xcoord := xcoord - 8;
          ycoord := ycoord + 24;
        end;
      if OPIFN <> '' then
        begin
          stgrBot.Canvas.Font.Color := clRed;
          stgrBot.Canvas.TextOut(xcoord, ycoord, 'In Progress: ' + PatN);
          stgrBot.Canvas.Font.Color := clBlack;
          ycoord := ycoord + 12;
          stgrBot.Canvas.TextOut(xcoord, ycoord, SpecN);
          ycoord := ycoord + 12;
          stgrBot.Canvas.TextOut(xcoord, ycoord, Proc);
          ycoord := ycoord + 12;
          stgrBot.Canvas.TextOut(xcoord, ycoord, Att);
          ycoord := ycoord + 12;
          xcoord := xcoord + 8;
          stgrBot.Canvas.TextOut(xcoord, ycoord, 'Hold Area:   ' + Hold);
          ycoord := ycoord + 12;
          stgrBot.Canvas.TextOut(xcoord, ycoord, 'Anes Start:  ' + AnStrt);
          ycoord := ycoord + 12;
          stgrBot.Canvas.TextOut(xcoord, ycoord, 'Antibiotic:    ' + Anti);
          ycoord := ycoord + 12;
          stgrBot.Canvas.TextOut(xcoord, ycoord, 'Patient In:   ' + PatIn);
          ycoord := ycoord + 12;
          stgrBot.Canvas.TextOut(xcoord, ycoord, 'Op Start:     ' + OpStrt);
          ycoord := ycoord + 12;
          stgrBot.Canvas.TextOut(xcoord, ycoord, 'Op End:      ' + OpEnd);
          ycoord := ycoord + 12;
          stgrBot.Canvas.TextOut(xcoord, ycoord, 'Patient Out: ' + PatOut);
          ycoord := ycoord + 12;
          stgrBot.Canvas.TextOut(xcoord, ycoord, 'Anes End:    ' + AnEnd);
          ycoord := ycoord + 24;
          xcoord := xcoord - 8;
        end;
      if NPatN <> '' then
        begin
          if (PPatN <> '') or (PatN <> '') then
            begin
              header := 'Next: ';
              stgrBot.Canvas.Font.Color := clOlive;
            end
          else
            begin
              header := 'First: ';
              stgrBot.Canvas.Font.Color := clBlue;
            end;
          stgrBot.Canvas.TextOut(xcoord, ycoord, header + NPatN);
          stgrBot.Canvas.Font.Color := clBlack;
          ycoord := ycoord + 12;
          stgrBot.Canvas.TextOut(xcoord, ycoord, NProc);
          ycoord := ycoord + 12;
          xcoord := xcoord + 8;
          stgrBot.Canvas.TextOut(xcoord, ycoord, 'Hold Area:   ' + NHold);
          ycoord := ycoord + 12;
          {stgrBot.Canvas.TextOut(xcoord, ycoord, 'Antibiotic:    ' + NAnti);
          ycoord := ycoord + 12;
          stgrBot.Canvas.TextOut(xcoord, ycoord, 'Anes Start: ' + NAnSt);}
          xcoord := xcoord - 8;
        end;
      if LPatN <> '' then
        begin
          stgrBot.Canvas.Font.Color := clPurple;
          stgrBot.Canvas.TextOut(xcoord, ycoord, 'Last: ' + LPatN);
          stgrBot.Canvas.Font.Color := clBlack;
          ycoord := ycoord + 12;
          stgrBot.Canvas.TextOut(xcoord, ycoord, LProc);
          ycoord := ycoord + 12;
          xcoord := xcoord + 8;
          stgrTop.Canvas.TextOut(xcoord, ycoord, 'Pat In:     ' + LPatIn);
          ycoord := ycoord + 12;
          stgrTop.Canvas.TextOut(xcoord, ycoord, 'Pat Out:   ' + LPatOut);
          ycoord := ycoord + 12;
          stgrTop.Canvas.TextOut(xcoord, ycoord, 'PACU Out: ' + LPACU);
          xcoord := xcoord - 8;
        end;
      ycoord := ycoord + 24;
    end;
end;

procedure TfrmRealTime.ClearCells;
var
  Block, J, ACol, ARow: integer;
  Cell: TRect;
begin
  for J := 0 to 4 do hcTop.Sections[J].Text := '';
  for J := 0 to 4 do hcMid.Sections[J].Text := '';
  for J := 0 to 4 do hcBot.Sections[J].Text := '';
  stgrTop.Canvas.Brush.Color := clWindow;
  stgrTop.Canvas.Brush.Style := bsSolid;
  for Block := 0 to 4 do
    begin
      ACol := Block;
      ARow := 0;
      Cell := stgrTop.CellRect(ACol, ARow);
      stgrTop.Canvas.FillRect(Cell);
    end;
  stgrMid.Canvas.Brush.Color := clWindow;
  stgrMid.Canvas.Brush.Style := bsSolid;
  for Block := 0 to 4 do
    begin
      ACol := Block;
      ARow := 0;
      Cell := stgrMid.CellRect(ACol, ARow);
      stgrMid.Canvas.FillRect(Cell);
    end;
  stgrBot.Canvas.Brush.Color := clWindow;
  stgrBot.Canvas.Brush.Style := bsSolid;
  for Block := 0 to 4 do
    begin
      ACol := Block;
      ARow := 0;
      Cell := stgrBot.CellRect(ACol, ARow);
      stgrBot.Canvas.FillRect(Cell);
    end;
end;

procedure TfrmRealTime.timRefreshTimer(Sender: TObject);
begin
  RCount := RCount + 1;
  lblCount.Caption := IntToStr(60 - RCount);
  if RCount = 60 then
    begin
      timRefresh.Enabled := False;
      RefreshReal;
      RCount := 0;
      timRefresh.Enabled := True;
    end;
end;

procedure TfrmRealTime.RefreshReal;
begin
  CallV('APTWL GET REALTIME', []);
  lbTemp.Items := RPCBrokerV.Results;
  FillReal;
end;

procedure TfrmRealTime.GetData;
begin
  Room    := piece(Data, '^', 1);
  PPatN   := piece(Data, '^', 2);
  PProc   := piece(Data, '^', 3);
  PPatIn  := piece(Data, '^', 4);
  OPIFN   := piece(Data, '^', 5);
  SpecN   := piece(Data, '^', 6);
  PatN    := piece(Data, '^', 7);
  Proc    := piece(Data, '^', 8);
  Hold    := piece(Data, '^', 9);
  Anti    := piece(Data, '^', 10);
  AnStrt  := piece(Data, '^', 11);
  PatIn   := piece(Data, '^', 12);
  OpStrt  := piece(Data, '^', 13);
  OpEnd   := piece(Data, '^', 14);
  PatOut  := piece(Data, '^', 15);
  AnEnd   := piece(Data, '^', 16);
  Att     := piece(Data, '^', 17);
  NPatN   := piece(Data, '^', 18);
  NProc   := piece(Data, '^', 19);
  NHold   := piece(Data, '^', 20);
  NAnti   := piece(Data, '^', 21);
  NAnSt   := piece(Data, '^', 22);
  LPatN   := piece(Data, '^', 23);
  LProc   := piece(Data, '^', 24);
  LPatIn  := piece(Data, '^', 25);
  LPatOut := piece(Data, '^', 26);
  LPACU   := piece(Data, '^', 27);
  PPatOut := piece(Data, '^', 28);
  PPACU   := piece(Data, '^', 29);
end;

procedure TfrmRealTime.timScrollTimer(Sender: TObject);
// refresh after scrolling back to home
begin
  if stgrTop.Top < 25 then scroll := 1;
  if scroll = 0 then Exit;
  if (scroll = 1) and (stgrTop.Top = 25) then
    begin
      RefreshReal;
      scroll := 0;
    end;
end;

end.
