unit fEditReq;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ORCtrls, ORNet, ORFn, ExtCtrls;

type
  TfrmEditReq = class(TForm)
    lblPatient: TLabel;
    lblCase: TLabel;
    lblProc: TLabel;
    lblSurg: TLabel;
    lblAtt: TLabel;
    lblPos: TLabel;
    lblType: TLabel;
    lblOrder: TLabel;
    lblLen: TLabel;
    lblEquip: TLabel;
    lblComm: TLabel;
    memEdit: TMemo;
    cbESurg: TORComboBox;
    cbEAtt: TORComboBox;
    cbEType: TORComboBox;
    cbEPos: TORComboBox;
    edEOrder: TEdit;
    edELen: TEdit;
    edEEquip: TEdit;
    btnESave: TButton;
    btnEExit: TButton;
    lbETemp: TORListBox;
    edEProc: TEdit;
    cbEAnes: TORComboBox;
    lblAnes: TLabel;
    lstOther: TListBox;
    btnESec: TPanel;
    btnConc: TButton;
    lstTemp: TListBox;
    edConc: TEdit;
    procedure btnEExitClick(Sender: TObject);
    procedure btnESaveClick(Sender: TObject);
    procedure cbESurgChange(Sender: TObject);
    procedure cbESurgClick(Sender: TObject);
    procedure cbEAttChange(Sender: TObject);
    procedure cbEAttClick(Sender: TObject);
    procedure cbEPosClick(Sender: TObject);
    procedure cbETypeClick(Sender: TObject);
    procedure edEEquipChange(Sender: TObject);
    procedure memEditChange(Sender: TObject);
    procedure btnESecClick(Sender: TObject);
    procedure cbEAnesChange(Sender: TObject);
    procedure cbEAnesClick(Sender: TObject);
    procedure btnConcClick(Sender: TObject);
    procedure edConcChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmEditReq: TfrmEditReq;
  SurgIFN, AttIFN, AnesIFN, PosIFN, TypeIFN, ConcIFN: string;
  Change, otChange: integer;

procedure EditRequest(SpecIFN: integer);

implementation

{$R *.dfm}

uses SCMMain, fSched, fOther, fOps;

procedure EditRequest(SpecIFN: integer);
var
  L: integer;
begin
  frmEditReq := TfrmEditReq.Create(Application);
  try
  with frmEditReq do
    begin
      lblPatient.Caption := SchedPt;
      lblCase.Caption := 'Case: ' + SchedCase;
      edConc.Text   := '';
      CallV('APTWL GET EDIT REQ', [SchedCase]);
      lbETemp.Items := RPCBrokerV.Results;
      edEProc.Text  := lbETemp.Items[0];
      cbESurg.Text  := piece(lbETemp.Items[1], '^', 2);
      SurgIFN       := piece(lbETemp.Items[1], '^', 1);
      cbEAtt.Text   := piece(lbETemp.Items[2], '^', 2);
      AttIFN        := piece(lbETemp.Items[2], '^', 1);
      cbEAnes.Text  := piece(lbETemp.Items[3], '^', 2);
      AnesIFN       := piece(lbETemp.Items[3], '^', 1);
      cbEPos.Text   := piece(lbETemp.Items[4], '^', 2);
      PosIFN        := piece(lbETemp.Items[4], '^', 1);
      cbEType.Text  := piece(lbETemp.Items[5], '^', 2);
      TypeIFN       := piece(lbETemp.Items[5], '^', 1);
      edEOrder.Text := lbETemp.Items[6];
      edELen.Text   := lbETemp.Items[7];
      edEEquip.Text := lbETemp.Items[8];
      for L := 9 to 11 do
        begin
          if lbETemp.Items[L] <> '' then memEdit.Lines.Add(lbETemp.Items[L]);
        end;
      if lbETemp.Items[12] <> '' then
        begin
          lstOther.Items.Add(lbETemp.Items[12]);
          btnESec.Color      := clRed;
          btnESec.Font.Color := clWhite;
        end;
      if lbETemp.Items[13] <> '' then lstOther.Items.Add(lbETemp.Items[13]);
      if lbETemp.Items[14] <> '' then lstOther.Items.Add(lbETemp.Items[14]);
      if lbETemp.Items[15] <> '' then lstOther.Items.Add(lbETemp.Items[15]);
      if lbETemp.Items[16] <> '' then lstOther.Items.Add(lbETemp.Items[16]);
      if lbETemp.Items[17] <> '' then lstOther.Items.Add(lbETemp.Items[17]);
      if lbETemp.Items[18] <> '' then
        begin
          ConcIFN     := piece(lbETemp.Items[18], '^', 1);
          edConc.Text := piece(lbETemp.Items[18], '^', 2) + '  ' + piece(lbETemp.Items[18], '^', 3);
        end;
      CallV('APTWL GET PROVIDER', ['S', SpecIFN]);
      cbESurg.Items := RPCBrokerV.Results;
      cbEATT.Items  := RPCBrokerV.Results;
      CallV('APTWL GET PROVIDER', ['A', SpecIFN]);
      cbEAnes.Items := RPCBrokerV.Results;
      CallV('APTWL GET SURG POSITION', []);
      cbEPos.Items  := RPCBrokerV.Results;
      CallV('APTWL GET TYPE', []);
      cbEType.Items := RPCBrokerV.Results;
      Change        := 0;
      ShowModal;
    end;
  finally
    frmEditReq.Release;
  end;
end;

procedure TfrmEditReq.btnEExitClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmEditReq.btnESaveClick(Sender: TObject);
begin
  if Change = 0 then
    begin
      MessageDlg('No changes were made!', mtinformation, [mbOK], 0);
      Exit;
    end;
  lbETemp.Items.Clear;
  lbETemp.Items.Add(edEProc.Text);
  lbETemp.Items.Add(SurgIFN);
  lbETemp.Items.Add(AttIFN);
  lbETemp.Items.Add(AnesIFN);
  lbETemp.Items.Add(PosIFN);
  lbETemp.Items.Add(TypeIFN);
  lbETemp.Items.Add(edEOrder.Text);
  lbETemp.Items.Add(edELen.Text);
  lbETemp.Items.Add(edEEquip.Text);
  lbETemp.Items.Add(ConcIFN);         // 4-30-08
  CallV('APTWL PUT EDITED REQ', [SchedCase, lbETemp.Items, memEdit.Lines, lstOther.Items]);
  Close;
end;

procedure TfrmEditReq.cbESurgChange(Sender: TObject);
begin
  if cbESurg.Text = '' then Exit;
  CallV('APTWL GET PROVIDER', ['S', SpecIFN, cbESurg.Text]);
  cbESurg.Items := RPCBrokerV.Results;
end;

procedure TfrmEditReq.cbESurgClick(Sender: TObject);
begin
  SurgIFN := IntToStr(cbESurg.ItemIEN);
  Change  := 1;
end;

procedure TfrmEditReq.cbEAttChange(Sender: TObject);
begin
  if cbEAtt.Text = '' then Exit;
  CallV('APTWL GET PROVIDER', ['S', SpecIFN, cbEAtt.Text]);
  cbEAtt.Items := RPCBrokerV.Results;
end;

procedure TfrmEditReq.cbEAttClick(Sender: TObject);
begin
  AttIFN := IntToStr(cbEAtt.ItemIEN);
  Change := 1;
end;

procedure TfrmEditReq.cbEPosClick(Sender: TObject);
begin
  PosIFN := IntToStr(cbEPos.ItemIEN);
  Change := 1;
end;

procedure TfrmEditReq.cbETypeClick(Sender: TObject);
begin
  TypeIFN := IntToStr(cbEType.ItemIEN);
  Change  := 1;
end;

procedure TfrmEditReq.edEEquipChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmEditReq.memEditChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmEditReq.btnESecClick(Sender: TObject);
var
  I, Num: integer;
  List: string;
begin
  List := 'R';
  GetOther(lstOther, List);
  Num := lstOther.Items.Count;
  lstOther.Clear;
  with frmOther do
    begin
      if lbOther.Items.Count >0 then
        begin
          btnESec.Color      := clRed;
          btnESec.Font.Color := clWhite;
          for I := 0 to lbOther.Items.Count-1 do lstOther.Items.Add(lbOther.Items[I]);
        end
      else
        begin
          btnESec.Color      := clBtnFace;
          btnESec.Font.Color := clWindowText;
        end;
      if OtherChange = 1 then
        begin
          Change   := 1;
          OtChange := 1;
        end;
    end;
end;


procedure TfrmEditReq.cbEAnesChange(Sender: TObject);
begin
  if cbEAnes.Text = '' then Exit;
  CallV('APTWL GET PROVIDER', ['S', SpecIFN, cbEAnes.Text]);
  cbEAnes.Items := RPCBrokerV.Results;
end;

procedure TfrmEditReq.cbEAnesClick(Sender: TObject);
begin
  AnesIFN := IntToStr(cbEAnes.ItemIEN);
  Change := 1;
end;

procedure TfrmEditReq.btnConcClick(Sender: TObject);
begin
  lstTemp.Items.Add('abc');
  OpsList(3, lstTemp);
  if piece(SelectCase, '^', 1) <> '0' then
    begin
      Change      := 1;
      ConcIFN     := piece(SelectCase, '^', 2);
      edConc.Text := piece(SelectCase, '^', 3) + ' ' + piece(SelectCase, '^', 4);
    end;
end;

procedure TfrmEditReq.edConcChange(Sender: TObject);
begin
  if edConc.Text = '' then
    begin
      ConcIFN := '';
      Change  := 1;
    end;
end;

end.
