unit fDSched;
// ptld/jit   4-14-07

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, ORFn, ORNet, StdCtrls, ORDtTm, ORCtrls, Buttons;

type
  TfrmDSched = class(TForm)
    pnlTop: TPanel;
    pnlMain: TPanel;
    lbDSched: TORListBox;
    dbDSched: TORDateBox;
    lblDSched: TLabel;
    btnPrint: TButton;
    pnlBottom: TPanel;
    cbPAnes: TORComboBox;
    cbAAnes: TORComboBox;
    lblPAnes: TLabel;
    lblAAnes: TLabel;
    lblSel: TLabel;
    lbSel: TORListBox;
    lblSign: TLabel;
    btnDel: TButton;
    btnDet: TButton;
    btnExit: TBitBtn;
    pnlAct: TPanel;
    btnEnter: TButton;
    btnClear: TButton;
    lbPTemp: TORListBox;
    procedure dbDSchedChange(Sender: TObject);
    procedure btnPrintClick(Sender: TObject);
    procedure lbDSchedClick(Sender: TObject);
    procedure DisableAnes;
    procedure EnableAnes;
    procedure cbPAnesChange(Sender: TObject);
    procedure cbPAnesClick(Sender: TObject);
    procedure cbAAnesChange(Sender: TObject);
    procedure cbAAnesClick(Sender: TObject);
    procedure lbDSchedDblClick(Sender: TObject);
    procedure btnEnterClick(Sender: TObject);
    procedure lbSelClick(Sender: TObject);
    procedure btnDelClick(Sender: TObject);
    procedure pnlBottomClick(Sender: TObject);
    procedure btnClearClick(Sender: TObject);
    procedure btnDetClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmDSched: TfrmDSched;
  PAnesIFN, AAnesIFN, lastCase: integer;

procedure DisplaySchedule;

implementation

{$R *.dfm}

uses SCMMain, fGenPrint, fRptBox, rLocal;

procedure DisplaySchedule;
begin
  frmDSched := TfrmDSched.Create(Application);
  try
  with frmDSched do
    begin
      if Tool = 2 then
        begin
          pnlBottom.Visible := True;
          //btnPrint.Enabled  := False;
          btnDel.Enabled    := False;
          btnDet.Enabled    := False;
          DisableAnes;
          lbSel.Items.Clear;
          PAnesIFN := 0;
          AAnesIFN := 0;
          lastCase := 0;
        end;
      ShowModal;
    end;
  finally
    frmDSched.Release;
  end;
end;

procedure TfrmDSched.dbDSchedChange(Sender: TObject);
begin
  CallV('APTWL GET SCHED FOR DISPLAY', [dbDSched.FMDateTime, Tool]);
  if RPCBrokerV.Results.Count >1 then
    begin
      btnPrint.Enabled := True;
      lbDSched.Clear;
      Caption := 'Surgery Schedule for ' + dbDSched.Text;
      lbDSched.Items   := RPCBrokerV.Results;
      if lastCase > lbDSched.Items.Count then lastCase := lbDSched.Items.Count;
      if lastCase > 0 then lbDSched.ItemIndex := lastCase;
      CallV('APTWL GET PROVIDER', ['A', 0]);
      cbPAnes.Items := RPCBrokerV.Results;
      cbAAnes.Items := RPCBrokerV.Results;
    end;
end;

procedure TfrmDSched.btnPrintClick(Sender: TObject);
var
  Title, SchedDate: string;
begin
  lbPTemp.Items.Clear;
  SchedDate := FloatToStr(dbDSched.FMDateTime);
  Title := frmDSched.Caption;
  GenPrint(lbDSched, Title, lbDSched.Pieces, lbDSched.TabPositions, lbPTemp, SchedDate);
end;

procedure TfrmDSched.lbDSchedClick(Sender: TObject);
var
  data, sel: string;
  J: integer;
begin
  if Tool = 3 then Exit;
  ResetTimeOut;
  sel := lbDSched.Items[lbDSched.ItemIndex];
  lastCase := lbDSched.ItemIndex;
  for J := 0 to lbSel.Items.Count -1 do
    begin
      if piece(sel, '^', 2) = piece(lbSel.Items[J], '^', 1) then Exit;
    end;
  if piece(sel, '^', 2) <> '' then
    begin
      data :=  piece(sel, '^', 2) + '^' + piece(sel, '^', 3) + '^' + piece(sel, '^', 4);
      lbSel.Items.Add(data);
      EnableAnes;
    end;
end;

procedure TfrmDSched.EnableAnes;
begin
  lblPAnes.Enabled := True;
  cbPAnes.Enabled  := True;
  lblAAnes.Enabled := True;
  cbAAnes.Enabled  := True;
  lblSign.Enabled  := True;
  btnEnter.Enabled := True;
end;

procedure TfrmDSched.DisableAnes;
begin
  lblAAnes.Enabled := False;
  cbPAnes.Enabled  := False;
  lblPAnes.Enabled := False;
  cbAAnes.Enabled  := False;
  lblSign.Enabled  := False;
  btnEnter.Enabled := False;
  btnClear.Enabled := False;
  cbPAnes.Text     := '';
  cbAAnes.Text     := '';
end;

procedure TfrmDSched.cbPAnesChange(Sender: TObject);
begin
  if cbPAnes.Text = '' then
    begin
      cbPAnes.DroppedDown := False;
      PAnesIFN := 0;
      Exit;
    end;
  CallV('APTWL GET PROVIDER', ['A', 0, cbPAnes.Text]);
  cbPAnes.Items := RPCBrokerV.Results;
  cbPAnes.DroppedDown := True;
end;

procedure TfrmDSched.cbPAnesClick(Sender: TObject);
begin
  PAnesIFN := cbPAnes.ItemIEN;
  btnClear.Enabled := True;
end;

procedure TfrmDSched.cbAAnesChange(Sender: TObject);
begin
  if cbAAnes.Text = '' then
    begin
      cbAAnes.DroppedDown := False;
      AAnesIFN := 0;
      Exit;
    end;
  CallV('APTWL GET PROVIDER', ['A', 0, cbAAnes.Text]);
  cbAAnes.Items := RPCBrokerV.Results;
  cbAAnes.DroppedDown := True;
end;

procedure TfrmDSched.cbAAnesClick(Sender: TObject);
begin
  AAnesIFN := cbAAnes.ItemIEN;
  btnClear.Enabled := True;
end;

procedure TfrmDSched.lbDSchedDblClick(Sender: TObject);
begin
  if Tool = 2 then Exit;
  CallV('APTWL GET REQ DETAIL', [piece(lbDSched.Items[lbDSched.ItemIndex], '^', 2), 'R']);
  ReportBox(RPCBrokerV.Results, 'Surgery Request Detail for ' + piece(lbDSched.Items[lbDSched.ItemIndex], '^', 3), True);
end;

procedure TfrmDSched.btnEnterClick(Sender: TObject);
var
  J: integer;
  list, Success: string;
begin
  if lbSel.Items.Count = 0 then Exit;
  list := '';
  if cbPAnes.Text = '' then PAnesIFN := 0;
  if cbAAnes.Text = '' then AAnesIFN := 0;
  for J := 0 to lbSel.Items.Count -1 do
    begin
      if J = 0 then list := piece(lbSel.Items[J], '^', 1)
      else list := list + '^' + piece(lbSel.Items[J], '^', 1);
    end;
  Success := sCallV('APTWL PUT ANES', [list, PAnesIFN, AAnesIFN]);
  if piece(Success, '^', 1) = '0' then
    begin
      MessageDlg('Could not add anesthesiologists name to cases', mtwarning, [mbOK], 0);
      Exit;
    end;
  dbDSchedChange(Self);
  lbSel.Items.Clear;
  DisableAnes;
  btnClear.Enabled := False;
end;

procedure TfrmDSched.lbSelClick(Sender: TObject);
begin
  btnDel.Enabled := True;
  btnDet.Enabled := True;
end;

procedure TfrmDSched.btnDelClick(Sender: TObject);
begin
  lbSel.Items.Delete(lbSel.ItemIndex);
  btnDel.Enabled := False;
  if lbSel.Items.Count = 0 then
    begin
      DisableAnes;
      btnEnter.Enabled := False;
      btnClear.Enabled := False;
      btnDet.Enabled   := False;
    end;
end;

procedure TfrmDSched.pnlBottomClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmDSched.btnClearClick(Sender: TObject);
begin
  cbPAnes.Text := '';
  cbAAnes.Text := '';
  btnClear.Enabled := False;
end;

procedure TfrmDSched.btnDetClick(Sender: TObject);
begin
  CallV('APTWL GET REQ DETAIL', [piece(lbDSched.Items[lbDSched.ItemIndex], '^', 2), 'R']);
  ReportBox(RPCBrokerV.Results, 'Surgery Request Detail for ' + piece(lbSel.Items[lbSel.ItemIndex], '^', 1), True);
end;

end.
