unit fCurrentWait;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, CheckLst, ORCtrls, ComCtrls, ExtCtrls, Grids,
  ORNet, ORFn, Buttons;

type
  TfrmCurrentWait = class(TForm)
    pnlMain: TPanel;
    hcWait: THeaderControl;
    lbWait: TORListBox;
    lbTemp: TListBox;
    lblCan: TLabel;
    btnOK: TButton;
    btnQuit: TButton;
    cbCan: TORComboBox;
    pnl0: TPanel;
    pnl1: TPanel;
    pnl2: TPanel;
    pnl3: TPanel;
    pnl4: TPanel;
    pnl5: TPanel;
    pnl6: TPanel;
    pnl7: TPanel;
    pnl8: TPanel;
    edComm: TCaptionRichEdit;
    lblComm: TLabel;
    btnCommOK: TButton;
    btnCommQuit: TButton;
    pnlAR: TPanel;
    btnARWait: TButton;
    btnARDetail: TButton;
    btnARAudit: TButton;
    btnARNote: TButton;
    btnAREdit: TButton;
    btnARCan: TButton;
    btnARPrint: TButton;
    pnlWL: TPanel;
    btnWReq: TButton;
    btnDetail: TButton;
    btnAudit: TButton;
    btnNote: TButton;
    btnEdit: TButton;
    btnCan: TButton;
    btnPrint: TButton;
    btnAct: TButton;
    btnExit: TBitBtn;
    btnARReq: TButton;
    pnl9: TPanel;
    btnAROut: TButton;
    btnOut: TButton;
    lbPTemp: TORListBox;
    btnARPRD: TButton;
    btnPRD: TButton;
    btnPatInq: TButton;
    pnl10: TPanel;
    btnSusp: TButton;
    btnRem: TButton;
    btnARSusp: TButton;
    btnARRem: TButton;
    procedure btnExitClick(Sender: TObject);
    procedure btnPrintClick(Sender: TObject);
    procedure hcWaitSectionClick(HeaderControl: THeaderControl; Section: THeaderSection);
    procedure btnWReqClick(Sender: TObject);
    procedure btnDetailClick(Sender: TObject);
    procedure btnAuditClick(Sender: TObject);
    procedure lbWaitClick(Sender: TObject);
    procedure btnEditClick(Sender: TObject);
    procedure btnCanClick(Sender: TObject);
    procedure btnQuitClick(Sender: TObject);
    procedure btnOKClick(Sender: TObject);
    procedure btnNoteClick(Sender: TObject);
    procedure ColorBar(Sect: integer);
    procedure SetColor(barcolor: TColor; Sect: integer);
    procedure btnActClick(Sender: TObject);
    procedure DisplayCancel;
    procedure HideCancel;
    procedure DisplayComm;
    procedure HideComm;
    procedure btnCommOKClick(Sender: TObject);
    procedure btnCommQuitClick(Sender: TObject);
    procedure DisableMenu;
    procedure EnableMenu;
    procedure RefreshWL;
    procedure Action;
    procedure btnARReqClick(Sender: TObject);
    procedure cbCanChange(Sender: TObject);
    procedure btnAROutClick(Sender: TObject);
    procedure btnOutClick(Sender: TObject);
    procedure btnARWaitClick(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure btnPRDClick(Sender: TObject);
    procedure btnARPRDClick(Sender: TObject);
    procedure lbWaitMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure cbCanClick(Sender: TObject);
    function IsMedComplete(): integer;
    procedure ReadOnly;
    procedure btnPatInqClick(Sender: TObject);
    procedure btnSuspClick(Sender: TObject);
    procedure btnARSuspClick(Sender: TObject);
    procedure btnARRemClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmCurrentWait: TfrmCurrentWait;
  sort, wlifn, lastsect, waitsort, ptsort, CanIFN, lastCase: integer;
  list, ListName, Act: string;

procedure CurrentWait(status: string);

implementation

{$R *.dfm}

uses fRptBox, SCMMain, fRequest, fWait, fGenPrint, uCore,
     rLocal, fDelay, fCodeKey, fPatInq, fSuspense;

procedure CurrentWait(status: string);
var
  x: string;
begin
  frmCurrentWait := TfrmCurrentWait.Create(Application);
  try
  with frmCurrentWait do
    begin
      sort     := 1;
      waitsort := 1;
      ptsort   := 0;
      lastsect := 1;
      lastCase := 0;
      CallV('APTWL GET WL CANCEL', []);
      cbCan.Items       := RPCBrokerV.Results;
      HideComm;
      DisableMenu;
      if status = 'A' then
        begin
          ListName := 'Action Required';
          pnlAR.Visible  := True;
          pnlAR.BringToFront;
          pnlWL.Visible  := False;
          btnAct.Visible := False;
          btnARWait.Caption := 'Move AR Entry to Wait List';
          hcWait.Sections[1].Text := 'AR List Date';
        end;
      if status = 'W' then
        begin
          ListName := 'Wait';
          hcWait.Sections[10].Text := 'Codes';
          pnlWL.BringToFront;
        end;
      list := status;
      Title := 'Current ' + SpecName + ' ' + ListName + ' List';
      RefreshWL;
      pnl1.Color := clBlue;
      if UserFac= 5 then ReadOnly;
      ShowModal;
    end;
  finally
    frmCurrentWait.Release;
  end;
end;

procedure TfrmCurrentWait.btnExitClick(Sender: TObject);
begin
  Close;
end;

{procedure TfrmCurrentWait.FillGrid;
var
  J, K: integer;
  node, data: string;
  Rect: TRect;
begin
  for J := 0 to lbTemp.Items.Count-1 do
    begin
      node := lbTemp.Items[J];
      for K := 1 to 6 do
        begin
          data := piece(node, '^', K);
          Rect := grdWait.CellRect((K-1), J);
          grdWait.Canvas.Font := Font;
          grdWait.Canvas.TextRect(Rect, Rect.Left + 3, Rect.Top + 4, data);
        end;
    end;
end;}

procedure TfrmCurrentWait.btnPrintClick(Sender: TObject);
var
  Title: string;
  J: integer;
begin
  lbPTemp.Items.Clear;
  for J := 0 to hcWait.Sections.Count-1 do lbPTemp.Items.Add(hcWait.Sections[J].Text);
  Title := frmCurrentWait.Caption;
  GenPrint(lbWait, Title, lbWait.Pieces, lbWait.TabPositions, lbPTemp, '');
end;

procedure TfrmCurrentWait.hcWaitSectionClick(HeaderControl: THeaderControl;
  Section: THeaderSection);
var
  i: integer;
begin
  if Section.ID = 10 then
    begin
      ShowCodeKey;
      Exit;
    end;
  if piece(lbWait.Items[0], '^',1) = '*' then Exit;
  if lbWait.Items.Count = 1 then Exit;
  lbWait.Clear;
  DisableMenu;
  for i := 0 to hcWait.Sections.Count -1 do
    begin
      if(Section = hcWait.Sections[i]) then
        begin
          Sort := i;
          ColorBar(i);
          break;
        end;
    end;
  // get direction for sort by date
  if (Sort = 1) or (Sort = 9) then
    begin
      if waitsort = 1 then waitsort := 0
      else waitsort := 1;
    end;
  // get direction for sort by patient
  if Sort = 2 then
    begin
      if ptsort = 1 then ptsort := 0
      else ptsort := 1;
    end;
  RefreshWL;
end;

procedure TfrmCurrentWait.btnWReqClick(Sender: TObject);
begin
  if list = 'A' then
    begin
      if (piece(lbWait.Items[lbWait.ItemIndex], '^', 12) <> 'YES') then
        begin
          if MessageDlg('This entry for ' + PtName + ' does not have surgical clearance.', mtwarning, [mbOK, mbIgnore], 0) = mrOK then Exit;
        end;
    end;
  btnARReqClick(Self);
end;

procedure TfrmCurrentWait.btnDetailClick(Sender: TObject);
begin
  CallV('APTWL GET WL DETAIL', [SpecIFN, wlifn, list]);
  ReportBox(RPCBrokerV.Results, ListName + ' List Detail for ' + PtName, True);
end;

procedure TfrmCurrentWait.btnAuditClick(Sender: TObject);
begin
  CallV('APTWL GET AUDIT', [SpecIFN, wlifn, list]);
  ReportBox(RPCBrokerV.Results, 'SCM Audit Trail for ' + PtName, True);
end;

procedure TfrmCurrentWait.lbWaitClick(Sender: TObject);
begin
  ResetTimeOut;
  EnableMenu;
  wlifn       := lbWait.ItemIEN;
  PtName      := piece(lbWait.Items[lbWait.ItemIndex], '^', 3);
  Patient     := TPatient.Create;
  Patient.DFN := piece(lbWait.Items[lbWait.ItemIndex], '^', 11);
  DFN         := Patient.DFN;
  PtProc      := piece(lbWait.Items[lbWait.ItemIndex], '^', 6);
  lastCase    := lbWait.ItemIndex;
end;

procedure TfrmCurrentWait.btnEditClick(Sender: TObject);
begin
  CallV('APTWL GET WL DATA', [SpecIFN, wlifn, list]);
  lbTemp.Items := RPCBrokerV.Results;
  Wait(lbTemp.Items, 2, list);
  RefreshWL;
end;

procedure TfrmCurrentWait.btnCanClick(Sender: TObject);
begin
  DisplayCancel;
  DisplayComm;
  btnOK.Visible   := False;
  btnQuit.Visible := False;
  Act := 'CAN';
end;

procedure TfrmCurrentWait.btnQuitClick(Sender: TObject);
begin
  HideCancel;
end;

procedure TfrmCurrentWait.btnOKClick(Sender: TObject);
var
  Success, Reason: string;
begin
  Reason  := cbCan.Text;
  if Reason = '' then
    begin
      MessageDlg('Please enter a cancellation reason.', mtwarning, [mbOK], 0);
      Exit;
    end;
  Success := sCallV('APTWL PUT WL CANCEL', [SpecIFN, wlifn, list, CanIFN, edComm.Lines]);
  if Success = '1' then
    begin
      ShowMessage(SpecAbbr + ' ' + IntToStr(wlifn) + ' has been cancelled.' + CRLF
        + 'Patient: ' + PtName + CRLF
        + 'Reason:  ' + cbCan.Text);
      RefreshWL;
    end;
  if Success = '0' then
    begin
      ShowMessage('Cancel not successful.');
      Exit;
    end;
  HideCancel;
end;

procedure TfrmCurrentWait.btnNoteClick(Sender: TObject);
begin
  NIFN := StrToInt(sCallV('APTWL GET TIU', [SpecIFN, wlifn]));
  if NIFN = 0 then
    begin
      MessageDlg('There is no Request Note associated with this Wait List entry.', mtinformation, [mbOK], 0);
      Exit;
    end;
  CallV('APTWL GET TEXT', [NIFN]);
  ReportBox(RPCBrokerV.Results, 'Request Note for ' + PtName, False);
end;

procedure TfrmCurrentWait.ColorBar(Sect: integer);
var
  color: TColor;
begin
  if lastsect = Sect then Exit;
  color := clBtnFace;
  SetColor(color, lastsect);
  color := clBlue;
  SetColor(color, Sect);
  lastsect := Sect;
end;

procedure TfrmCurrentWait.SetColor(barcolor: TColor; Sect: integer);
begin
  if Sect = 0 then pnl0.Color := barcolor;
  if Sect = 1 then pnl1.Color := barcolor;
  if Sect = 2 then pnl2.Color := barcolor;
  if Sect = 3 then pnl3.Color := barcolor;
  if Sect = 4 then pnl4.Color := barcolor;
  if Sect = 5 then pnl5.Color := barcolor;
  if Sect = 6 then pnl6.Color := barcolor;
  if Sect = 7 then pnl7.Color := barcolor;
  if Sect = 8 then pnl8.Color := barcolor;
  if Sect = 9 then pnl9.Color := barcolor;
end;

procedure TfrmCurrentWait.btnActClick(Sender: TObject);
begin
  Act := 'AR';
  DisplayComm;
end;

procedure TfrmCurrentWait.DisplayCancel;
begin
  lblCan.Visible  := True;
  cbCan.Visible   := True;
  btnOK.Visible   := True;
  btnQuit.Visible := True;
end;

procedure TfrmCurrentWait.HideCancel;
begin
  lblCan.Visible   := False;
  cbCan.Visible    := False;
  btnOK.Visible    := False;
  btnQuit.Visible  := False;
end;

procedure TfrmCurrentWait.DisplayComm;
begin
  lblComm.Visible     := True;
  edComm.Visible      := True;
  btnCommOK.Visible   := True;
  btnCommQuit.Visible := True;
end;

procedure TfrmCurrentWait.HideComm;
begin
  lblComm.Visible     := False;
  edComm.Visible      := False;
  btnCommOK.Visible   := False;
  btnCommQuit.Visible := False;
end;

procedure TfrmCurrentWait.btnCommOKClick(Sender: TObject);
var
  Success: string;
begin
  if Act = 'AR' then
    begin
      Success := sCallV('APTWL PUT WL TO ACT', [SpecIFN, wlifn, edComm.Lines]);
      if Success = '1' then
        begin
          MessageDlg('The Act/Req List entry, ' + SpecAbbr + ' ' + IntToStr(wlifn) + CRLF +
            'on ' + PtName + CRLF + 'has been moved back to the Act/Req List.', mtinformation, [mbOK], 0);
          RefreshWL;
        end;
      if Success = '0' then ShowMessage('Move not successful.');
    end;
  if Act = 'CAN' then
    begin
      btnOKClick(Self);
      if cbCan.Text = '' then Exit;
    end;
  if (Act = 'WL') or (Act = 'CO')  then Action;
  HideComm;
  HideCancel;
end;

procedure TfrmCurrentWait.btnCommQuitClick(Sender: TObject);
begin
  HideCancel;
  HideComm;
end;

procedure TfrmCurrentWait.DisableMenu;
begin
  btnWReq.Enabled     := False;
  btnDetail.Enabled   := False;
  btnAudit.Enabled    := False;
  btnEdit.Enabled     := False;
  btnCan.Enabled      := False;
  btnNote.Enabled     := False;
  btnAct.Enabled      := False;
  btnOut.Enabled      := False;
  btnSusp.Enabled     := False;
  btnRem.Enabled      := False;
  btnARWait.Enabled   := False;
  btnARReq.Enabled    := False;
  btnARDetail.Enabled := False;
  btnARAudit.Enabled  := False;
  btnARNote.Enabled   := False;
  btnAREdit.Enabled   := False;
  btnARCan.Enabled    := False;
  btnAROut.Enabled    := False;
  btnARPRD.Enabled    := False;
  btnARRem.Enabled    := False;
  btnARSusp.Enabled   := False;
  btnPRD.Enabled      := False;
  btnPatInq.Enabled   := False;
end;

procedure TfrmCurrentWait.EnableMenu;
begin
  btnWReq.Enabled     := True;
  btnDetail.Enabled   := True;
  btnAudit.Enabled    := True;
  btnEdit.Enabled     := True;
  btnCan.Enabled      := True;
  btnNote.Enabled     := True;
  btnAct.Enabled      := True;
  btnOut.Enabled      := True;
  btnSusp.Enabled     := True;
  btnRem.Enabled      := True;
  btnARWait.Enabled   := True;
  btnARReq.Enabled    := True;
  btnARDetail.Enabled := True;
  btnARAudit.Enabled  := True;
  btnARNote.Enabled   := True;
  btnAREdit.Enabled   := True;
  btnARCan.Enabled    := True;
  btnAROut.Enabled    := True;
  btnARPRD.Enabled    := True;
  btnARRem.Enabled    := True;
  btnARSusp.Enabled   := True;
  btnPRD.Enabled      := True;
  btnPatInq.Enabled   := True;
end;

procedure TfrmCurrentWait.RefreshWL;
var
  Count: integer;
begin
  CallV('APTWL GET CURRENT WAIT', [SpecIFN, sort, list, waitsort, ptsort]);
  lbWait.Clear;
  lbWait.Items := RPCBrokerV.Results;
  Count := lbWait.Items.Count;
  if lastCase > Count then lastCase := Count;
  if lastCase > 0 then lbWait.ItemIndex := lastCase;
  if piece(lbWait.Items[0], '^', 1) = '*' then Count := 0;
  frmCurrentWait.Caption := Title + '  (' + IntToStr(Count) + ')';
  DisableMenu;
end;

procedure TfrmCurrentWait.Action;
var
  Success, listype: string;
  MComp: integer;
begin
  if list = 'W' then
    begin
      if Act = 'CO' then
        begin
          Success := sCallV('APTWL PUT WL TO CO', [SpecIFN, wlifn, edComm.Lines]);
          listype := 'Outsourced';
          if Success = '1' then
            begin
              MessageDlg('The Wait List entry for ' + PtName + CRLF +
                SpecAbbr + ' ' + IntToStr(wlifn) + ', has been moved to the ' + listype + ' List.', mtinformation, [mbOK], 0);
              RefreshWL;
            end;
          if Success = '0' then
            begin
              MessageDlg('There is an error preventing the selected action.', mtwarning, [mbOK], 0);
            end;
        end;
      if Act = 'AR' then
        begin
          Success := sCallV('APTWL PUT WL TO ACT', [SpecIFN, wlifn, edComm.Lines]);
          if Success = '1' then
            begin
              MessageDlg('The Act/Req List entry, ' + SpecAbbr + ' ' + IntToStr(wlifn) + CRLF +
                'on ' + PtName + CRLF + 'has been moved back to the Act/Req List.', mtinformation, [mbOK], 0);
              RefreshWL;
            end;
          if Success = '0' then ShowMessage('Move not successful.');
        end;
      if Act = 'CAN' then btnOKClick(Self);
    end;
  if list = 'A' then
    begin
      MComp := IsMedComplete();
      if MComp = 2 then Exit;
      if MComp = 0 then
        begin
          if MessageDlg('This case has Med Issues that are not complete.' + CRLF +
            'Please complete them first before moving this case.', mtwarning, [mbOK, mbIgnore], 0) = mrOK then Exit;
        end;
      if Act = 'WL' then
        begin
          Success := sCallV('APTWL PUT ACT TO WL', [SpecIFN, wlifn, edComm.Lines]);
          listype := 'Wait';
        end;
      if Act = 'CO' then
        begin
          Success := sCallV('APTWL PUT ACT TO CO', [SpecIFN, wlifn, edComm.Lines]);
          listype := 'Outsourced';
        end;
      if Success = '1' then
        begin
          MessageDlg('The Action Required entry for ' + PtName + CRLF +
            SpecAbbr + ' ' + IntToStr(wlifn) + ', has been moved to the ' + listype + ' List.', mtinformation, [mbOK], 0);
          RefreshWL;
        end;
      if Success = '0' then
        begin
          MessageDlg('There is an error preventing the selected action.', mtwarning, [mbOK], 0);
        end;
    end;
  HideComm;
end;

procedure TfrmCurrentWait.btnARReqClick(Sender: TObject);
var
  MComp: integer;
begin
  MComp := IsMedComplete();
  if MComp = 2 then Exit;  // bad data
  if MComp = 0 then
    begin
      if MessageDlg('This case has Med Issues that are not complete.' + CRLF +
        'Please complete them first before moving this case.', mtwarning, [mbOK, mbIgnore], 0) = mrOK then Exit;
    end;
  CallV('APTWL GET WL DATA', [SpecIFN, wlifn, list]);
  lbTemp.Items := RPCBrokerV.Results;
  if lbTemp.Items.Count <1 then
    begin
      MessageDlg('Could not collect data for the Request.' + CRLF + 'Please reselect the Current Wait or AR list and try again.', mterror, [mbOK], 0);
      Exit;
    end;
  Request(lbTemp.Items, 4);
  RefreshWL;
end;

procedure TfrmCurrentWait.cbCanChange(Sender: TObject);
begin
  if cbCan.Text = '' then Exit;
  CallV('APTWL GET CANCEL REASON', [cbCan.Text]);
  cbCan.Items := RPCBrokerV.Results;
  cbCan.DroppedDown := True;
end;

procedure TfrmCurrentWait.btnAROutClick(Sender: TObject);
begin
  Act := 'CO';
  DisplayComm;
end;

procedure TfrmCurrentWait.btnOutClick(Sender: TObject);
begin
  btnAROutClick(Self);
end;

procedure TfrmCurrentWait.btnARWaitClick(Sender: TObject);
begin
  Act := 'WL';
  DisplayComm;
end;

procedure TfrmCurrentWait.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  ResetTimeOut;
end;

procedure TfrmCurrentWait.btnPRDClick(Sender: TObject);
begin
  PatientDelay('WL', wlifn, piece(lbWait.Items[lbWait.ItemIndex], '^', 13));
  RefreshWL;
end;

procedure TfrmCurrentWait.btnARPRDClick(Sender: TObject);
begin
  PatientDelay('AR', wlifn, piece(lbWait.Items[lbWait.ItemIndex], '^', 13));
  RefreshWL;
end;

procedure TfrmCurrentWait.lbWaitMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
  ListType: string;
begin
  if Button = mbLeft then Exit;
  if piece(lbWait.Items[lbWait.ItemIndex], '^', 13) = '' then Exit;
  if list = 'A' then ListType := 'AR';
  if list = 'W' then ListType := 'WL';
  CallV('APTWL GET PRD', [SpecIFN, lbWait.ItemIEN, ListType]);
  ReportBox(RPCBrokerV.Results, 'Patient Requested Delay Data', True);
end;

procedure TfrmCurrentWait.cbCanClick(Sender: TObject);
begin
  CanIFN := cbCan.ItemIEN;
end;

function TfrmCurrentWait.IsMedComplete(): integer;
// are med issues, if any, completed?
var
  Comp: string;
begin
  Comp := sCallV('APTWL IS MED COMPLETE', [SpecIFN, wlifn, list]);
  if (Comp = '1') or (Comp = '3') then Result := 1; // none entered or completed
  if (Comp = '2') or (Comp = '4') then Result := 0; // pending or entered but no status listed
  if Comp = '0' then Result := 2;  // bad data
end;

procedure TfrmCurrentWait.ReadOnly;
begin
  btnWReq.Enabled   := False;
  btnAct.Enabled    := False;
  btnOut.Enabled    := False;
  btnPRD.Enabled    := False;
  btnEdit.Enabled   := False;
  btnCan.Enabled    := False;
  btnRem.Enabled    := False;
  btnSusp.Enabled   := False;
  btnARReq.Enabled  := False;
  btnARWait.Enabled := False;
  btnAROut.Enabled  := False;
  btnARPRD.Enabled  := False;
  btnAREdit.Enabled := False;
  btnARCan.Enabled  := False;
  btnARRem.Enabled  := False;
  btnARSusp.Enabled := False;
end;
procedure TfrmCurrentWait.btnPatInqClick(Sender: TObject);
begin
  PtInq;
end;

procedure TfrmCurrentWait.btnSuspClick(Sender: TObject);
begin
  CreateSuspense;
  RefreshWL;
end;

procedure TfrmCurrentWait.btnARSuspClick(Sender: TObject);
begin
  CreateSuspense;
  RefreshWL;
end;

procedure TfrmCurrentWait.btnARRemClick(Sender: TObject);
begin
  if MessageDlg('Are you sure you want to remove this entry from the ' + ListName + ' list?', mtwarning, [mbYes, mbNo], 0) = mrNo then Exit;
  CallV('APTWL REMOVE ENTRY', [SpecIFN, wlIFN, list]);
  RefreshWL;
end;

end.
