unit fConsults;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ORCtrls, ComCtrls, ORNet, ORFn, ExtCtrls, Buttons;

type
  TfrmConsults = class(TForm)
    hcConsult: THeaderControl;
    lbConsult: TORListBox;
    lbTemp: TORListBox;
    pnlMenu: TPanel;
    btnDetail: TButton;
    btnSelect: TButton;
    btnPrint: TButton;
    btnExit: TBitBtn;
    procedure btnExitClick(Sender: TObject);
    procedure lbConsultDblClick(Sender: TObject);
    procedure btnSelectClick(Sender: TObject);
    procedure btnDetailClick(Sender: TObject);
    procedure btnPrintClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmConsults: TfrmConsults;

procedure CurrentConsult;

implementation

{$R *.dfm}

uses SCMMain, fWait, fRptBox, fGenPrint;

procedure CurrentConsult;
begin
  frmConsults := TfrmConsults.Create(Application);
  try
  with frmConsults do
    begin
      CallV('APTWL GET CONSULTS', [DFN]);
      lbConsult.Items := RPCBrokerV.Results;
      Caption := Caption + PtName;
      ShowModal;
    end;
  finally
    frmConsults.Release;
  end;
end;

procedure TfrmConsults.btnExitClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmConsults.lbConsultDblClick(Sender: TObject);
begin
  CallV('ORWCS REPORT TEXT', [DFN, piece(lbConsult.Items[lbConsult.ItemIndex], '^', 1)]);
  lbTemp.Items := RPCBrokerV.Results;
  ReportBox(lbTemp.Items, 'Consult Details for ' + PtName, False);
end;

procedure TfrmConsults.btnSelectClick(Sender: TObject);
var
  ifn: string;
begin
  ifn := piece(lbConsult.Items[lbConsult.ItemIndex], '^', 1);
  if frmWait.pcMed.ActivePage = frmWait.TabSheet1 then frmWait.edCon1.Text := ifn;
  if frmWait.TabSheet2.Focused = True then frmWait.edCon2.Text := ifn;
  if frmWait.TabSheet3.Focused = True then frmWait.edCon3.Text := ifn;
  if frmWait.TabSheet4.Focused = True then frmWait.edCon4.Text := ifn;
  Exit;
end;

procedure TfrmConsults.btnDetailClick(Sender: TObject);
begin
  lbConsultDblClick(Self);
end;

procedure TfrmConsults.btnPrintClick(Sender: TObject);
var
  Title: string;
  J: integer;
begin
  lbTemp.Items.Clear;
  for J := 0 to hcConsult.Sections.Count-1 do lbTemp.Items.Add(hcConsult.Sections[J].Text);
  Title := frmConsults.Caption;
  GenPrint(lbConsult, Title, lbConsult.Pieces, lbConsult.TabPositions, lbTemp, '');
end;

end.
