unit fCancel;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls, ORCtrls, Buttons, ExtCtrls,
  ORNet, ORFn;

type
  TfrmCancel = class(TForm)
    hcCancel: THeaderControl;
    lbCancel: TORListBox;
    rgCancel: TKeyClickRadioGroup;
    btnExit: TBitBtn;
    pnlMenu: TPanel;
    btnDet: TButton;
    btnAud: TButton;
    btnPrt: TButton;
    pnl0: TPanel;
    pnl1: TPanel;
    pnl2: TPanel;
    pnl3: TPanel;
    pnl4: TPanel;
    pnl5: TPanel;
    lbPTemp: TORListBox;
    pnlMove: TPanel;
    rgReturn: TRadioGroup;
    lblOut: TLabel;
    memOut: TMemo;
    btnOK: TButton;
    btnRet: TButton;
    procedure btnExitClick(Sender: TObject);
    procedure btnDetClick(Sender: TObject);
    procedure btnAudClick(Sender: TObject);
    procedure GetData;
    procedure lbCancelClick(Sender: TObject);
    procedure GetList;
    procedure rgCancelClick(Sender: TObject);
    procedure lbCancelDblClick(Sender: TObject);
    procedure btnPrtClick(Sender: TObject);
    procedure hcCancelSectionClick(HeaderControl: THeaderControl;
      Section: THeaderSection);
    procedure ColorBar(Sect: integer);
    procedure SetColor(barcolor: TColor; Sect: integer);
    procedure btnRetClick(Sender: TObject);
    procedure btnOKClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmCancel: TfrmCancel;
  scmifn, list, status, opcase, listname, PtName, Start: string;
  sort, lastsect, ptsort, datesort, lastCase: integer;
  Title: string;

procedure Cancelled;

implementation

{$R *.dfm}

uses SCMMain, fRptBox, fGenPrint, fRequest, rLocal;

procedure Cancelled;
begin
  frmCancel := TfrmCancel.Create(Application);
  try
  with frmCancel do
    begin
      Caption  := Caption + SpecName;
      Sort     := 1;  // by cancel date
      datesort := 1;  // date sort direction
      ptsort   := 0;  // patient sort direction
      Title    := 'Cancelled cases for ' + SpecName;
      lastCase := 0;
      GetList;
      btnDet.Enabled := False;
      btnAud.Enabled := False;
      btnRet.Enabled := False;
      if piece(lbCancel.Items[0], '^', 1) <> '  The' then
        begin
          pnl1.Color := clBlue;
          lastsect   := 1;
        end;
      if UserFac = 5 then btnRet.Enabled := False;
      ShowModal;
    end;
  finally
    frmCancel.Release;
  end;
end;

procedure TfrmCancel.btnExitClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmCancel.btnDetClick(Sender: TObject);
begin
  GetData;
  if (list = 'A') or (list = 'W') then
    begin
      CallV('APTWL GET WL DETAIL', [SpecIFN, scmifn, list]);
      ReportBox(RPCBrokerV.Results, ListName + ' Detail for ' + PtName, True);
    end
  else
    begin
      CallV('APTWL GET REQ DETAIL', [opcase, list]);
      ReportBox(RPCBrokerV.Results, ListName + ' Detail for ' + PtName, True);
    end;
end;

procedure TfrmCancel.btnAudClick(Sender: TObject);
begin
  GetData;
  if (list = 'A') or (list = 'W') or (list = 'O') then
    begin
      CallV('APTWL GET AUDIT', [SpecIFN, scmifn, list]);
      ReportBox(RPCBrokerV.Results, 'SCM Audit Trail for ' + PtName, True);
    end
  else
    begin
      CallV('APTWL GET AUDIT', [SpecIFN, opcase, list]);
      ReportBox(RPCBrokerV.Results, 'SCM Audit Trail for ' + PtName, True);
    end;
end;

procedure TfrmCancel.GetData;
begin
  status   := piece(lbCancel.Items[lbCancel.ItemIndex], '^', 7);
  scmifn   := piece(lbCancel.Items[lbCancel.ItemIndex], '^', 8);
  opcase   := piece(lbCancel.Items[lbCancel.ItemIndex], '^', 9);
  if (status = '6') or (status = '10') then
    begin
      if (opcase <> '') and (scmifn = '') then scmifn := opcase;
    end;
  listname := piece(lbCancel.Items[lbCancel.ItemIndex], '^', 5);
  PtName   := piece(lbCancel.Items[lbCancel.ItemIndex], '^', 3);
  if status = '9' then list := 'A';
  if status = '5' then list := 'W';
  if status = '6' then list := 'R';
  if status = '10' then list := 'S';
  if status = '14' then list := 'O';
end;

procedure TfrmCancel.lbCancelClick(Sender: TObject);
begin
  ResetTimeOut;
  btnDet.Enabled := True;
  btnAud.Enabled := True;
  btnRet.Enabled := True;
  lastCase := lbCancel.ItemIndex;
end;

procedure TfrmCancel.GetList;
var
  Count: integer;
begin
  Start   := rgCancel.Items[rgCancel.ItemIndex];
  CallV('APTWL GET CANCEL LIST', [Start, SpecIFN, Sort, datesort, ptsort]);
  lbCancel.Items := RPCBrokerV.Results;
  Count := lbCancel.Items.Count;
  if piece(lbCancel.Items[0], '^', 1) = '*' then Count := 0;
  if lastCase > Count then lastCase := Count;
  if lastCase > 0 then lbCancel.ItemIndex := lastCase;
  frmCancel.Caption := Title + '  (' + IntToStr(Count) + ')';
end;

procedure TfrmCancel.rgCancelClick(Sender: TObject);
begin
  GetList;
end;

procedure TfrmCancel.lbCancelDblClick(Sender: TObject);
begin
  btnDetClick(Self);
end;

procedure TfrmCancel.btnPrtClick(Sender: TObject);
var
  Title: string;
  J: integer;
begin
  lbPTemp.Items.Clear;
  for J := 0 to hcCancel.Sections.Count -1 do lbPTemp.Items.Add(hcCancel.Sections[J].Text);
  Title := frmCancel.Caption;
  GenPrint(lbCancel, Title, lbCancel.Pieces, lbCancel.TabPositions, lbPTemp, '');
end;

procedure TfrmCancel.hcCancelSectionClick(HeaderControl: THeaderControl;
  Section: THeaderSection);
var
  i: integer;
begin
  if piece(lbCancel.Items[0], '^',1) = '  The' then Exit;
  if lbCancel.Items.Count = 1 then Exit;
  lbCancel.Clear;
  btnDet.Enabled := False;
  btnAud.Enabled := False;
  for i := 0 to 5 do
    begin
      if(Section = hcCancel.Sections[i]) then
        begin
          Sort := i;
          ColorBar(i);
          break;
        end;
    end;
  // get direction for sort by date
  if Sort = 1 then
    begin
      if datesort = 1 then datesort := 0
      else datesort := 1;
    end;
   // get direction for sort by patient
  if Sort = 2 then
    begin
      if ptsort = 1 then ptsort := 0
      else ptsort := 1;
    end;
  GetList;
end;

procedure TfrmCancel.ColorBar(Sect: integer);
var
  color: TColor;
begin
  if lastsect = Sect then Exit;
  color := clBtnFace;
  SetColor(color, lastsect);
  color := clBlue;
  SetColor(color, Sect);
  lastsect := Sect;
end;

procedure TfrmCancel.SetColor(barcolor: TColor; Sect: integer);
begin
  if Sect = 0 then pnl0.Color := barcolor;
  if Sect = 1 then pnl1.Color := barcolor;
  if Sect = 2 then pnl2.Color := barcolor;
  if Sect = 3 then pnl3.Color := barcolor;
  if Sect = 4 then pnl4.Color := barcolor;
  if Sect = 5 then pnl5.Color := barcolor;
end;

procedure TfrmCancel.btnRetClick(Sender: TObject);
begin
  pnlMove.Visible := True;
end;

procedure TfrmCancel.btnOKClick(Sender: TObject);
var
  Success: string;
begin
  GetData;
  if (list = 'R') or (list = 'S') then
    if scmifn <> opcase then list := 'W';
  if scmifn = opcase then  // add case to scm first if not there
    begin
      Success := sCallV('APTWL PUT REQ TO SCM', [opcase, rgReturn.ItemIndex + 1]);
      if piece(Success, '^', 1) = '1' then scmifn := piece(Success, '^', 2)
      else
        begin
          MessageDlg('Could not move cancelled case.', mterror, [mbOK], 0);
          Exit;
        end;
    end;
  if rgReturn.ItemIndex = 2 then  //  make new request
    begin
      CallV('APTWL GET WL DATA', [SpecIFN, scmifn, 'W']);
      lbPTemp.Items := RPCBrokerV.Results;
      Request(lbPTemp.Items, 4);
      GetList;
    end
  else     // AR or Wait
    begin
      Success := sCallV('APTWL PUT CANC BACK', [SpecIFN, scmifn, memOut.Lines, rgReturn.ItemIndex, list]);
      if Success = '1' then
        begin
          MessageDlg('Cancelled case for ' + PtName +
            CRLF + 'put back on the  ' + rgReturn.Items[rgReturn.ItemIndex], mtinformation, [mbOK], 0);
          GetList;
        end;
      if piece(Success, '^', 1) = '0' then MessageDlg('The move could not be accomplished because of an error.' + CRLF +
        piece(Success, '^', 2), mtwarning, [mbOK], 0);
    end;
  pnlMove.Visible := False;
end;

end.
