CREATE TABLE FACILITIES_TO_AAS
(
  FACILITY_TO_AA_ID       NUMBER,
  FACILITY_ID             NUMBER CONSTRAINT FACILITIES_TO_AAS_NN1 NOT NULL,
  ASSIGNING_AUTHORITY_ID  NUMBER CONSTRAINT FACILITIES_TO_AAS_NN2 NOT NULL
);


CREATE UNIQUE INDEX FACILITIES_TO_AAS_UK1 ON FACILITIES_TO_AAS
(FACILITY_ID, ASSIGNING_AUTHORITY_ID);


CREATE UNIQUE INDEX FACILITIES_TO_ASSIGNING_AUT_PK ON FACILITIES_TO_AAS
(FACILITY_TO_AA_ID);


CREATE OR REPLACE TRIGGER FACILITY_TO_AA_ID_TRG
BEFORE INSERT
ON FACILITIES_TO_AAS 
REFERENCING NEW AS NEW OLD AS OLD
FOR EACH ROW
DECLARE
  N NUMBER;
BEGIN
    if :NEW.FACILITY_TO_AA_ID is null then
        select FACILITY_TO_AA_ID_SEQ.NEXTVAL into N from DUAL;
        :new.FACILITY_TO_AA_ID := N;
    end if;
end FACILITY_TO_AA_ID_TRG;
/


ALTER TABLE FACILITIES_TO_AAS ADD (
  CONSTRAINT FACILITIES_TO_AAS_PK
  PRIMARY KEY
  (FACILITY_TO_AA_ID)
  USING INDEX FACILITIES_TO_ASSIGNING_AUT_PK
  ENABLE VALIDATE,
  CONSTRAINT FACILITIES_TO_AAS_UK1
  UNIQUE (FACILITY_ID, ASSIGNING_AUTHORITY_ID)
  USING INDEX FACILITIES_TO_AAS_UK1
  ENABLE VALIDATE);

ALTER TABLE FACILITIES_TO_AAS ADD (
  CONSTRAINT FACILITIES_TO_AAS_FK1 
  FOREIGN KEY (FACILITY_ID) 
  REFERENCES FACILITIES (FACILITY_ID)
  ENABLE VALIDATE,
  CONSTRAINT FACILITIES_TO_AAS_FK2 
  FOREIGN KEY (ASSIGNING_AUTHORITY_ID) 
  REFERENCES ASSIGNING_AUTHORITIES (ASSIGNING_AUTHORITY_ID)
  ENABLE VALIDATE);
