CREATE TABLE CODESETS
(
  CODESET_ID    NUMBER,
  CODESET       VARCHAR2(255 CHAR) CONSTRAINT CODESETS_NN1 NOT NULL,
  LOOKUP_TABLE  VARCHAR2(255 CHAR) CONSTRAINT CODESETS_NN2 NOT NULL,
  KEY_FIELD     VARCHAR2(255 CHAR) CONSTRAINT CODESETS_NN3 NOT NULL
);


CREATE UNIQUE INDEX CODESETS_PK ON CODESETS
(CODESET_ID);


CREATE UNIQUE INDEX CODESETS_UK1 ON CODESETS
(CODESET);


CREATE OR REPLACE TRIGGER CODESET_ID_TRG
BEFORE INSERT
ON CODESETS
REFERENCING NEW AS NEW OLD AS OLD
FOR EACH ROW
DECLARE
  N NUMBER;
BEGIN
-- For Toad:  Highlight column CODESET_ID
  if :NEW.CODESET_ID is null then
    Select CODESET_ID_SEQ.nextval into n from dual;
    :new.CODESET_ID := N;
  end if;
END CODESET_ID_TRG;
/


ALTER TABLE CODESETS ADD (
  CONSTRAINT CODESETS_PK
  PRIMARY KEY
  (CODESET_ID)
  USING INDEX CODESETS_PK
  ENABLE VALIDATE,
  CONSTRAINT CODESETS_UK1
  UNIQUE (CODESET)
  USING INDEX CODESETS_UK1
  ENABLE VALIDATE);
