CREATE TABLE ASSIGNING_AUTHORITIES
(
  ASSIGNING_AUTHORITY_ID    NUMBER,
  ASSIGNING_AUTHORITY_OID   VARCHAR2(255 BYTE) CONSTRAINT ASSIGNING_AUTHORITIES_NN1 NOT NULL,
  ASSIGNING_AUTHORITY_NAME  VARCHAR2(2048 BYTE)
);


CREATE UNIQUE INDEX ASSIGNING_AUTHORIES_PK ON ASSIGNING_AUTHORITIES
(ASSIGNING_AUTHORITY_ID);


CREATE UNIQUE INDEX ASSIGNING_AUTHORIES_UK1 ON ASSIGNING_AUTHORITIES
(ASSIGNING_AUTHORITY_OID);


CREATE OR REPLACE TRIGGER ASSIGNING_AUTHORITY_ID_TRG
BEFORE INSERT
ON ASSIGNING_AUTHORITIES 
REFERENCING NEW AS NEW OLD AS OLD
FOR EACH ROW
declare
  N NUMBER;
begin
    if :NEW.ASSIGNING_AUTHORITY_ID is null then
        select ASSIGNING_AUTHORITY_ID_SEQ.NEXTVAL into N from DUAL;
        :new.ASSIGNING_AUTHORITY_ID := N;
    end if;
end ASSIGNING_AUTHORITY_ID_TRG;
/


ALTER TABLE ASSIGNING_AUTHORITIES ADD (
  CONSTRAINT ASSIGNING_AUTHORIES_PK
  PRIMARY KEY
  (ASSIGNING_AUTHORITY_ID)
  USING INDEX ASSIGNING_AUTHORIES_PK
  ENABLE VALIDATE,
  CONSTRAINT ASSIGNING_AUTHORIES_UK1
  UNIQUE (ASSIGNING_AUTHORITY_OID)
  USING INDEX ASSIGNING_AUTHORIES_UK1
  ENABLE VALIDATE);
