/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package gov.va.med.nhin.adapter.xmlutils;

import java.util.*;

import javax.xml.namespace.*;
import javax.xml.xpath.*;

import org.w3c.dom.*;

/**
 *
 * @author David Vazquez
 */
public class XMLXPathEvaluationCache
{
    private HashMap<String, Object> cache = new HashMap<String, Object>();
    private HashMap<String, XPathExpression> expressionCache = new HashMap<String, XPathExpression>();

    public Object evaluate(XPath xpath, String expressionString, Node onNode, QName returnType)
    {
        try {
            XPathExpression expression = getExpression(xpath, expressionString);
            return evaluate(expression, onNode, returnType);
        }
        catch (Throwable t) {
            throw new XMLUtilsException("An error occurred when evaluating.", t);
        }
    }

    public Object evaluate(XPathExpression expression, Node onNode, QName returnType)
    {
        try {
            Object ret;
            String key = expression.toString() + onNode.hashCode() + returnType.hashCode();
            ret = cache.get(key);
            if (ret == null) {
                ret = expression.evaluate(onNode, returnType);
                cache.put(key, ret);
            }

            return ret;
        }
        catch (Throwable t) {
            throw new XMLUtilsException("An error occurred when evaluating.", t);
        }
    }

    public void remove(XPath xpath, String expressionString, Node onNode, QName returnType)
    {
        try {
            XPathExpression expression = getExpression(xpath, expressionString);
            remove(expression, onNode, returnType);
        }
        catch (Throwable t) {
            throw new XMLUtilsException("An error occurred when evaluating.", t);
        }
    }

    public void remove(XPathExpression expression, Node onNode, QName returnType)
    {
        try {
            String key = expression.toString() + onNode.hashCode() + returnType.hashCode();
            cache.remove(key);
        }
        catch (Throwable t) {
            throw new XMLUtilsException("An error occurred when evaluating.", t);
        }
    }

    public XPathExpression getExpression(XPath xpath, String expressionString)
        throws XPathExpressionException
    {
        XPathExpression expression = expressionCache.get(expressionString);

        if (expression == null) {
            expression = xpath.compile(expressionString);
            expressionCache.put(expressionString, expression);
        }

        return expression;
    }
}
