/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package gov.va.med.nhin.adapter.utils.socketlistener;

import java.io.*;
import java.net.*;
import java.util.*;
import java.util.concurrent.*;

import gov.va.med.nhin.adapter.utils.*;

/**
 *
 * @author David Vazquez
 */
public class SocketListener implements Runnable
{
    static public final int DEFAULT_BACKLOG = 50;

    private final String address;
    private final int port;
    private final int backlog;
    private final ExecutorService executorService;
    private final Thread thread = new Thread(this);
    private final SocketHandler socketHandler;
    private ServerSocket serverSocket;

    public SocketListener(int port, SocketHandler socketHandler)
    {
        this(null, port, DEFAULT_BACKLOG, socketHandler);
    }

    public SocketListener(String address, int port, SocketHandler socketHandler)
    {
        this(address, port, DEFAULT_BACKLOG, socketHandler);
    }

    public SocketListener(String address, int port, int backlog, SocketHandler socketHandler)
    {
        this.address = address;
        this.port = port;
        this.backlog = backlog;
        this.socketHandler = socketHandler;
        this.executorService = Executors.newFixedThreadPool(5);
    }

    public void start()
    {
        try {
            InetAddress inetAddress = !NullChecker.isNullOrEmpty(address) ? InetAddress.getByName(address) : null;
            serverSocket = new ServerSocket(port, backlog, inetAddress);
            thread.start();
        }
        catch (Throwable t) {
            throw new SocketListenerException("Error!", t);
        }
    }

    public void stop()
    {
        thread.interrupt();
        executorService.shutdown();
        try {
            serverSocket.close();
        }
        catch (IOException ioe) {}
    }

    public void run()
    {
        while (!thread.isInterrupted()) {
            try {
                final Socket s = serverSocket.accept();

                executorService.execute(new Runnable()
                {
                    public void run()
                    {
                        socketHandler.handleSocket(s);
                    }
                });
            }
            catch (SocketException se) {
                break;
            }
            catch (IOException ioe) {
                // TODO: make this nicer.
                ioe.printStackTrace();
            }
        }
    }
}
