/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package gov.va.med.nhin.adapter.utils;

import org.apache.commons.beanutils.*;

/**
 *
 * @author David Vazquez
 */
public class Comparator
{
    static public boolean equals(Object left, Object right)
    {
        return !NullChecker.isNullOrEmpty(left)
               && !NullChecker.isNullOrEmpty(right)
               && ((Utils.isCollection(left) && Utils.isCollection(right)
                    && equalCollections(left, right))
                  ||
                   (!(Utils.isCollection(left) || Utils.isCollection(right))
                    && left.toString().equalsIgnoreCase(right.toString()))
                  );
    }

    static public boolean equalCollections(Object left, Object right)
    {
        boolean ret = true;

        if (Utils.getCollectionLength(left) != Utils.getCollectionLength(right)) {
            ret = false;
        }
        else {
            try {
                for (int i = 0;  i < Utils.getCollectionLength(left);  ++i) {
                    Object leftValue = PropertyUtils.getIndexedProperty(left, "", i);
                    Object rightValue = PropertyUtils.getIndexedProperty(right, "", i);
                    if (!leftValue.toString().equalsIgnoreCase(rightValue.toString())) {
                        ret = false;
                        break;
                    }
                }
            }
            catch (Throwable t) {
                ret = false;
            }
        }

        return ret;
    }
}
