/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package gov.va.med.nhin.adapter.datamanager.translators;

import gov.va.med.nhin.adapter.datamanager.*;
import gov.va.med.nhin.adapter.utils.*;

/**
 *
 * @author David Vazquez
 */
public class PrefixDataTranslator implements DataTranslator
{
    public Object translate(Object input, Object result, Reference translationType, DataQuery dataQuery)
    {
        String prefix = translationType.getProperty("prefix");
        
        if (NullChecker.isNullOrEmpty(prefix)) {
            throw new DataManagerException("Property prefix is required.");
        }
        
        return prefix + (NullChecker.isNotNullOrEmpty(input) ? input.toString() : "");
    }
}
