/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.datamanager.translators;

import java.util.*;

import gov.va.med.nhin.adapter.datamanager.*;

/**
 *
 * @author       VAZQUD
 */
public class LatestDateDataTranslator implements DataTranslator
{
    public Object translate(Object input, Object result, Reference translation, DataQuery dataQuery)
    {
        Date ret = null;
        String propertyNames = translation.getProperty("propertyNames");
        
        for (String propertyName : propertyNames.split(",")) {
            try {
                Object value = translation.getValue(propertyName);
                if (value != null) {
                    Date dateValue = (Date)value;
                    if (ret == null || dateValue.after(ret)) {
                        ret = dateValue;
                    }
                }
            }
            catch (ClassCastException cce) {
                throw new DataManagerException("Only properties of type java.util.Date are supported.");
            }
        }
        
        return ret;
    }
}
