/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package gov.va.med.nhin.adapter.datamanager.translators;

import java.util.logging.*;
import java.util.regex.*;

import gov.va.med.nhin.adapter.datamanager.*;

/**
 *
 * @author David Vazquez
 */
public class InstringDataTranslator implements DataTranslator
{
    static private final Logger logger = Logger.getLogger(InstringDataTranslator.class.getName());

    public Object translate(Object input, Object result, Reference translationType, DataQuery dataQuery)
    {
        String ret = null;
        
        if (input != null) {
            if (!(input instanceof String)) {
                throw new DataManagerException("input must be of type java.lang.String.");
            }

            String delimiter = translationType.getProperty("delimiter");
            String index = translationType.getProperty("index");

            String[] parts = ((String)input).split(delimiter);

            if (parts.length > 0) {
                if (index.equals("last")) {
                    ret = parts[parts.length-1];
                }
                else if (index.equals("notLast")) {
                    StringBuffer buffer = new StringBuffer();
                    for (int i = 0;  i < parts.length-1;  ++i) {
                        if (buffer.length() > 0) {
                            buffer.append(delimiter);
                        }
                        buffer.append(parts[i]);
                    }
                    ret = buffer.toString();
                }
                else {
                    int i = Integer.parseInt(index);

                    if (i < parts.length) {
                        ret = parts[i];
                    }
                    else {
                        ret = parts[0];
                    }
                }
            }
            else {
                ret = "";
            }
        }
        
        return ret;
    }
}
