/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.datamanager.translators;

import gov.va.med.nhin.adapter.datamanager.*;
import gov.va.med.nhin.adapter.utils.*;

/**
 *
 * @author       VAZQUD
 */
public class FirstNotBlankDataTranslator implements DataTranslator
{
    public Object translate(Object input, Object result, Reference translation, DataQuery dataQuery)
    {
        Object ret = null;
        String propertyNames = translation.getProperty("propertyNames");
        
        if (NullChecker.isNullOrEmpty(propertyNames)) {
            throw new DataManagerException("proertyNames property must be set.");
        }
        
        for (String propertyName : propertyNames.split(",")) {
            Object value = translation.getValue(propertyName);
            if (NullChecker.isNotNullOrEmpty(value)) {
                ret = value;
                break;
            }
        }
        
        return ret;
    }
}
