/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package gov.va.med.nhin.adapter.datamanager.translators;

import java.io.*;

import javax.xml.transform.*;
import javax.xml.transform.dom.*;
import javax.xml.transform.stream.*;

import org.w3c.dom.*;

import gov.va.med.nhin.adapter.datamanager.*;

/**
 *
 * @author David Vazquez
 */
public class DOMToByteArrayDataTranslator implements DataTranslator
{
    public Object translate(Object input, Object result, Reference translation, DataQuery dataQuery)
    {
        byte[] ret = null;

        if (input != null) {
            if (!(input instanceof Document)) {
                throw new DataManagerException("input must be of type org.w3c.dom.Document.");
            }

            Source source = new DOMSource((Document)input);

            ByteArrayOutputStream output = new ByteArrayOutputStream();
            Result rslt = new StreamResult(output);

            try {
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.transform(source, rslt);
                ret = output.toByteArray();
            }
            catch (Throwable t) {
                throw new DataManagerException("An error occurred translating DOM to byte array.", t);
            }
        }
        
        return ret;
    }
}
