/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package gov.va.med.nhin.adapter.datamanager.translators;

import org.apache.commons.beanutils.*;

import gov.va.med.nhin.adapter.datamanager.*;
import gov.va.med.nhin.adapter.utils.*;

/**
 *
 * @author David Vazquez
 */
public class CollectionToStringDataTranslator implements DataTranslator
{
    public Object translate(Object input, Object result, Reference translation, DataQuery dataQuery)
    {
        String ret = null;
        
        if (input != null) {
            if (!Utils.isCollection(input)) {
                throw new DataManagerException("input must be a collection");
            }

            ret = "";
            String property = translation.getProperty("property");
            String separator = translation.getProperty("separator");

            for (int i = 0;  i < Utils.getCollectionLength(input);  ++i) {
                String str = null;

                try {
                    Object obj = PropertyUtils.getIndexedProperty(input, "", i);
                    if (obj != null) {
                        if (NullChecker.isNotNullOrEmpty(property)) {
                            obj = PropertyUtils.getProperty(obj, property);
                            if (obj != null) {
                                str = obj.toString();
                            }
                        }
                        else {
                            str = obj.toString();
                        }
                    }
                }
                catch (Throwable t) {
                    throw new DataManagerException("An error occurred retrieving item from collection.", t);
                }

                if (NullChecker.isNotNullOrEmpty(str)) {
                    if (i > 0 && NullChecker.isNotNullOrEmpty(separator)) {
                        ret += separator;
                    }
                    ret += str;
                }
            }
        }
        
        return ret;
    }
}
