/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.datamanager.translators;

import org.apache.commons.codec.binary.*;

import gov.va.med.nhin.adapter.datamanager.*;
import gov.va.med.nhin.adapter.utils.*;

/**
 *
 * @author David Vazquez
 */
public class Base64EncodeDataTranslator implements DataTranslator
{
    public Object translate(Object input, Object result, Reference translation, DataQuery dataQuery)
    {
        Object ret = null;
        
        if (NullChecker.isNotNullOrEmpty(input)) {
            if (!(input instanceof String)) {
                throw new DataManagerException("input must be of type java.lang.String.");
            }

            byte[] inputAsBytes = ((String)input).getBytes();
            ret = Base64.encodeBase64String(inputAsBytes);
        }
        
        return ret;
    }
}
