/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.datamanager.parsers;

import java.util.*;

import gov.va.med.nhin.adapter.datamanager.*;
import gov.va.med.nhin.adapter.results.*;

/**
 *
 * @author David Vazquez
 */
public class VitalsPostProcessingDataParser implements DataParser
{
    static private final String VUID_BLOOD_PRESSURE = "4500634";
    static private final String VUID_BLOOD_PRESSURE_ORIG = "~-1";
    static private final String VUID_BLOOD_PRESSURE_SYSTOLIC = "~1";
    static private final String VUID_BLOOD_PRESSURE_DIASTOLIC = "~2";
    static private final String VUID_BLOOD_PRESSURE_MEAN = "~3";
    static private final String NAME_BLOOD_PRESSURE_SYSTOLIC = "SYSTOLIC";
    static private final String NAME_BLOOD_PRESSURE_DIASTOLIC = "DIASTOLIC";
    static private final String NAME_BLOOD_PRESSURE_MEAN = "MEAN ARTERIAL";
    static private final String SPLIT_CHARACTER = "/";

    public List parse(List dataResults, Reference parser, DataQuery dataQuery)
    {
        for (Object result : dataResults) {
            if (result instanceof VitalType) {
                VitalType vital = (VitalType)result;
                List<MeasurementType> measurements = vital.getMeasurements().getMeasurement();
                List<MeasurementType> addMeasurements = new ArrayList<MeasurementType>();

                for (MeasurementType measurement : measurements) {
                    if (measurement.getVuid().equals(VUID_BLOOD_PRESSURE)) {
                        String[] values = measurement.getValue().split(SPLIT_CHARACTER);
                        switch (values.length) {
                            case 1:
                                addMeasurements.add(makeSystolic(measurement, values[0]));
                                break;
                                
                            case 2:
                                addMeasurements.add(makeSystolic(measurement, values[0]));
                                addMeasurements.add(makeDiastolic(measurement, values[1]));
                                break;
                                
                            case 3:
                                addMeasurements.add(makeSystolic(measurement, values[0]));
                                addMeasurements.add(makeMeanArterial(measurement, values[1]));
                                addMeasurements.add(makeDiastolic(measurement, values[2]));
                                break;
                                
                            default:
                                break;
                        }
                        
                        measurement.setId(measurement.getId() + VUID_BLOOD_PRESSURE_ORIG);
                        measurement.setVuid(VUID_BLOOD_PRESSURE + VUID_BLOOD_PRESSURE_ORIG);
                    }
                }

                measurements.addAll(addMeasurements);
            }
        }

        return dataResults;
    }

    private MeasurementType makeSystolic(MeasurementType measurement, String value)
    {
        return makeBPMeasurement(measurement, value, VUID_BLOOD_PRESSURE_SYSTOLIC, NAME_BLOOD_PRESSURE_SYSTOLIC);
    }

    private MeasurementType makeDiastolic(MeasurementType measurement, String value)
    {
        return makeBPMeasurement(measurement, value, VUID_BLOOD_PRESSURE_DIASTOLIC, NAME_BLOOD_PRESSURE_DIASTOLIC);
    }

    private MeasurementType makeMeanArterial(MeasurementType measurement, String value)
    {
        return makeBPMeasurement(measurement, value, VUID_BLOOD_PRESSURE_MEAN, NAME_BLOOD_PRESSURE_MEAN);
    }
    
    private MeasurementType makeBPMeasurement(MeasurementType measurement, String value, String suffix, String prefix)
    {
        MeasurementType ret = new MeasurementType();

        ret.setId(measurement.getId() + suffix);
        ret.setVuid(measurement.getVuid() + suffix);
        ret.setName(prefix + " " + measurement.getName());
        ret.setValue(value);
        ret.setHigh(measurement.getHigh());
        ret.setLow(measurement.getLow());
        ret.setUnits(measurement.getUnits());
        ret.setMetricValue(measurement.getMetricValue());
        ret.setMetricUnits(measurement.getMetricUnits());

        return ret;
    }
}
