/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package gov.va.med.nhin.adapter.datamanager.parsers;

import java.util.*;
import java.util.regex.*;

import gov.va.med.nhin.adapter.datamanager.*;

/**
 *
 * @author David Vazquez
 */
public class ReportDataParser implements DataParser
{
    public List parse(List dataResults, Reference parserType, DataQuery dataQuery)
    {
        List ret = new ArrayList<Map>();
        String delimiter = parserType.getProperty("delimiter");
        int keyOffset = Integer.parseInt(parserType.getProperty("keyOffset"));
        int limit = keyOffset + 2;

        HashMap<String, String> record = new HashMap<String, String>();
        String results = (String)dataResults.get(0);
        String[] lines = results.split("\n");
        HashSet<String> keys = new HashSet<String>();
        String currentKey = null;
        StringBuffer currentValue = new StringBuffer();
        for (String line : lines) {
            String[] parts = line.split(delimiter, limit);
            if (parts.length >= limit) {
                String key = parts[keyOffset];
                String value = parts[keyOffset + 1];

                if (currentKey != null && !key.equals(currentKey)) {
                    if (keys.contains(currentKey)) {
                        ret.add(record);
                        record = new HashMap<String, String>();
                        keys.clear();
                    }

                    record.put(currentKey, currentValue.toString());
                    keys.add(currentKey);
                    currentValue.delete(0, currentValue.length());
                }

                currentKey = key;
                if (currentValue.length() > 0) {
                    currentValue.append('\n');
                }
                currentValue.append(value);
            }
        }

        if (record != null && !keys.isEmpty()) {
            record.put(currentKey, currentValue.toString());
            ret.add(record);
        }

        return ret;
    }
}
