/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package gov.va.med.nhin.adapter.datamanager.filters;

import java.util.*;

import org.apache.commons.beanutils.*;

import gov.va.med.nhin.adapter.datamanager.*;
import gov.va.med.nhin.adapter.utils.*;

/**
 *
 * @author David Vazquez
 */
public class InDataFilter implements DataFilter
{
    public boolean test(Object result, List results, Reference filterType, DataQuery dataQuery)
    {
        try {
            boolean ret = false;
            String valueName = filterType.getProperty("valueName");
            String inList = filterType.getProperty("inList");
            String startsWith = filterType.getProperty("startsWith");
            boolean doStartsWith = !NullChecker.isNullOrEmpty(startsWith) && startsWith.toUpperCase().equals("TRUE");
            String value = BeanUtils.getProperty(result, valueName);
            StringBuffer workingList = new StringBuffer();

            for (String item : inList.split(",")) {
                String addItem = null;
                if (item.startsWith("'") && item.endsWith("'")) {
                    addItem = item.substring(1, item.length()-1);
                }
                else {
                    Object v = dataQuery.getParameter(item);
                    if (v != null) {
                        addItem = v.toString();
                    }
                }

                if (addItem != null) {
                    if (workingList.length() != 0) {
                        workingList.append(",");
                    }
                    workingList.append(addItem);
                }
            }

            for (String item : workingList.toString().split(",")) {
                if ((doStartsWith && item.startsWith(value)) || item.equals(value)) {
                    ret = true;
                    break;
                }
            }

            return ret;
        }
        catch (Throwable t) {
            throw new RuntimeException("An error occurred when processing filter.", t);
        }
    }
}
