/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package gov.va.med.nhin.adapter.datamanager.filters;

import java.util.*;

import org.apache.commons.beanutils.*;

import gov.va.med.nhin.adapter.datamanager.*;
import gov.va.med.nhin.adapter.utils.*;
import gov.va.med.nhin.adapter.utils.Comparator;

/**
 *
 * @author David Vazquez
 */
public class ExtendedMatchDataFilter implements DataFilter
{
    public boolean test(Object result, List results, Reference filterType, DataQuery dataQuery)
    {
        boolean ret = true;
        String queryName = filterType.getProperty("queryName");
        DataManager dataManager = dataQuery.getDataManager();
        DataQuery dq = dataManager.getQuery(queryName);
        fillParameters(result, dq);
        List dqResults = dq.getResults();

        if (!dqResults.isEmpty()) {
            String[] matchFields = dataQuery.getParameterNames();
            try {
                for (String matchField : matchFields) {
                    Object leftValue = dataQuery.getParameter(matchField);
                    Object rightValue = PropertyUtils.getProperty(dqResults.get(0), matchField);

                    if (!NullChecker.isNullOrEmpty(leftValue)
                        && dq.isResult(matchField)
                        && !Comparator.equals(leftValue, rightValue)) {
                        ret = false;
                        break;
                    }
                }
            }
            catch (Throwable t) {
                ret = false;
            }
        }
        else {
            ret = false;
        }

        return ret;
    }

    private void fillParameters(Object result, DataQuery dataQuery)
    {
        String[] paramNames = dataQuery.getParameterNames();

        for (String paramName : paramNames) {
            Object value = null;
            try {
                value = PropertyUtils.getProperty(result, paramName);
            }
            catch (Throwable t) {}

            if (!NullChecker.isNullOrEmpty(value)) {
                dataQuery.setParameter(paramName, value);
            }
        }
    }
}
