/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.datamanager.adapters;

import java.util.*;
import java.util.logging.*;

import javax.naming.*;
import javax.security.auth.login.*;

import gov.va.med.vistalink.adapter.cci.*;
import gov.va.med.vistalink.adapter.record.*;
import gov.va.med.vistalink.rpc.*;
import gov.va.med.exception.*;
import gov.va.med.vistalink.security.*;

import gov.va.med.nhin.adapter.datamanager.*;
import gov.va.med.nhin.adapter.utils.*;

/**
 *
 * @author David Vazquez
 */
public class VistADataAdapter implements DataAdapter
{
    static public final Logger logger = Logger.getLogger(VistADataAdapter.class.getName());

    public List getData(DataQuery dataQuery)
    {
        List ret = null;
        VistaLinkConnection connection = null;

        logger.entering(getClass().getName(), "getData");
        
        try {
            connection = getConnection(dataQuery);
            setConnectionAttributes(connection);
            RpcRequest rpcRequest = buildRpcRequest(dataQuery);
            RpcResponse rpcResponse = executeRpcRequest(connection, rpcRequest);
            ret = processRpcResponse(rpcResponse);
        }
        catch (Throwable t) {
            throw new DataManagerException("An error occurred.", t);
        }
        finally {
            if (connection != null) {
                try {
                    closeConnection(dataQuery, connection);
                }
                catch (Throwable t) {}
            }
            logger.exiting(getClass().getName(), "getData");
        }

        return ret;
    }

    private VistaLinkConnection getConnection(DataQuery dataQuery)
        throws Exception
    {
        VistaLinkConnection ret;

        logger.entering(getClass().getName(), "getConnection");

        String connectionFilename = dataQuery.getProperty("connectionFilename");
        String connection = dataQuery.getProperty("connection");
        Properties propertiesCollection =
            PropertiesCollectionFactory.getPropertiesCollection(connectionFilename);
        Properties connectionProperties = (Properties)propertiesCollection.get(connection);
        int connectionPropertiesSize = connectionProperties.size();

        try {
            if (!NullChecker.isNullOrEmpty(connectionProperties.getProperty("JNDIName"))) {
                ret = getJNDIConnection(connectionProperties);
                if (connectionProperties.size() != connectionPropertiesSize) {
                    PropertiesCollectionFactory.storeProperties(connectionFilename, propertiesCollection);
                }
            }
            else {
                ret = getJAASConnection(connectionProperties);
            }
        }
        finally {
            logger.exiting(getClass().getName(), "getConnection");
        }

        return ret;
    }

    private VistaLinkConnection getJNDIConnection(Properties connectionProperties)
        throws Exception
    {
        VistaLinkConnectionSpec connectionSpec;

        if (NullChecker.isNullOrEmpty(connectionProperties.getProperty("username"))) {
            // this is a hack to get a DUZ until our RPCs are tagged as
            // ok for use by APPLICATION PROXY.
            connectionSpec = getDUZConnectionSpec(connectionProperties);
        }
        else {
            connectionSpec = getAppProxyConnectionSpec(connectionProperties);
        }

        Context ctx = new InitialContext();
        VistaLinkConnectionFactory connectionFactory =
            (VistaLinkConnectionFactory)ctx.lookup(connectionProperties.getProperty("JNDIName"));
        return (VistaLinkConnection)connectionFactory.getConnection(connectionSpec);
    }

    private VistaLinkConnectionSpec getDUZConnectionSpec(Properties connectionProperties)
        throws Exception
    {
        String duz = connectionProperties.getProperty("DUZ");
        if (NullChecker.isNullOrEmpty(duz)) {
            duz = getDUZ(connectionProperties);
            connectionProperties.setProperty("DUZ", duz);
        }
        return new VistaLinkDuzConnectionSpec(connectionProperties.getProperty("division"), duz);
    }

    private synchronized String getDUZ(Properties connectionProperties)
        throws Exception
    {
        String jaasConfigName = connectionProperties.getProperty("JAASConfigName");
        String accessCode = connectionProperties.getProperty("accessCode");
        String verifyCode = connectionProperties.getProperty("verifyCode");
        String division = connectionProperties.getProperty("division");

        CallbackHandlerUnitTest chut = new CallbackHandlerUnitTest(accessCode, verifyCode, division);
        LoginContext loginContext = new LoginContext(jaasConfigName, chut);
        loginContext.login();
        VistaKernelPrincipalImpl userPrincipal =
            VistaKernelPrincipalImpl.getKernelPrincipal(loginContext.getSubject());
        String ret = userPrincipal.getUserDemographicValue(VistaKernelPrincipalImpl.KEY_DUZ);
        loginContext.logout();

        return ret;
    }

    private VistaLinkConnectionSpec getAppProxyConnectionSpec(Properties connectionProperties)
        throws Exception
    {
        return new VistaLinkAppProxyConnectionSpec(connectionProperties.getProperty("division"),
                                                   connectionProperties.getProperty("username"));
    }

    static private final Map<String, List<VistaLinkConnection>> connectionCache = new HashMap<String, List<VistaLinkConnection>>();
    
    private VistaLinkConnection getJAASConnection(Properties connectionProperties)
        throws Exception
    {
        VistaLinkConnection ret;
        String JAASConfigName = connectionProperties.getProperty("JAASConfigName");
        String accessCode = connectionProperties.getProperty("accessCode");
        String verifyCode = connectionProperties.getProperty("verifyCode");
        String division = connectionProperties.getProperty("division");
        String key = JAASConfigName + accessCode + verifyCode + division;
        
        synchronized (connectionCache) {
            if (!NullChecker.isNullOrEmpty(connectionCache.get(key))) {
                ret = connectionCache.get(key).remove(0);
            }
            else {
                CallbackHandlerUnitTest chut = new CallbackHandlerUnitTest(accessCode, verifyCode, division);
                LoginContext loginContext = new LoginContext(JAASConfigName, chut);
                loginContext.login();
                VistaKernelPrincipalImpl userPrincipal =
                    VistaKernelPrincipalImpl.getKernelPrincipal(loginContext.getSubject());
                ret = userPrincipal.getAuthenticatedConnection();
            }
        }
        
        return ret;
    }

    private void setConnectionAttributes(VistaLinkConnection connection)
    {
        connection.setTimeOut(60 * 10000);
    }

    private RpcRequest buildRpcRequest(DataQuery dataQuery)
        throws FoundationsException
    {
        String rpcContext = dataQuery.getProperty("rpcContext");
        String rpcName = dataQuery.getProperty("rpcName");
        RpcRequest rpcRequest = RpcRequestFactory.getRpcRequest(rpcContext, rpcName);
        ArrayList params = new ArrayList();

        for (String paramName : dataQuery.getParameterNames()) {
            Object parameter = dataQuery.getParameter(paramName);
            params.add(parameter != null ? parameter : "");
        }

        rpcRequest.setParams(params);

        return rpcRequest;
    }

    private RpcResponse executeRpcRequest(VistaLinkConnection connection,
                                          RpcRequest rpcRequest)
        throws FoundationsException, VistaLinkFaultException
    {
        RpcResponse rpcResponse;

        logger.entering(getClass().getName(), "executeRpcRequest");

        try {
            rpcResponse = connection.executeRPC(rpcRequest);
        }
        finally {
            logger.exiting(getClass().getName(), "executeRpcRequest");
        }

        return rpcResponse;
    }

    private List processRpcResponse(RpcResponse rpcResponse)
        throws DataManagerException
    {
        List ret = new ArrayList<String>();
        ret.add(rpcResponse.getResults());
        return ret;
    }

    private void closeConnection(DataQuery dataQuery, VistaLinkConnection vistaLinkConnection)
        throws Exception
    {
        String connectionFilename = dataQuery.getProperty("connectionFilename");
        String connection = dataQuery.getProperty("connection");
        Properties propertiesCollection =
            PropertiesCollectionFactory.getPropertiesCollection(connectionFilename);
        Properties connectionProperties = (Properties)propertiesCollection.get(connection);
        
        if (!NullChecker.isNullOrEmpty(connectionProperties.getProperty("JNDIName"))) {
            vistaLinkConnection.close();
        }
        else {
            closeJAASConnection(connectionProperties, vistaLinkConnection);
        }
    }
    
    private void closeJAASConnection(Properties connectionProperties, VistaLinkConnection vistaLinkConnection)
    {
        String JAASConfigName = connectionProperties.getProperty("JAASConfigName");
        String accessCode = connectionProperties.getProperty("accessCode");
        String verifyCode = connectionProperties.getProperty("verifyCode");
        String division = connectionProperties.getProperty("division");
        String key = JAASConfigName + accessCode + verifyCode + division;
        
        synchronized (connectionCache) {
            List<VistaLinkConnection> connectionsList = connectionCache.get(key);
            if (connectionsList == null) {
                connectionsList = new ArrayList<VistaLinkConnection>();
                connectionCache.put(key, connectionsList);
            }
            connectionsList.add(vistaLinkConnection);
        }
    }
}
