/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package gov.va.med.nhin.adapter.datamanager.adapters;

import java.util.*;

import gov.va.med.nhin.adapter.datamanager.*;
import gov.va.med.nhin.adapter.utils.*;
import gov.va.med.nhin.adapter.utils.transceiver.*;

/**
 *
 * @author David Vazquez
 */
public class HL7MLLPDataAdapter extends HL7DataAdapter
{
    @Override
    String sendMessage(DataQuery dataQuery, String message)
        throws Exception
    {
        String ret;
        String connectionFilename = dataQuery.getProperty("connectionFilename");
        String connection = dataQuery.getProperty("connection");
        Properties propertiesCollection =
            PropertiesCollectionFactory.getPropertiesCollection(connectionFilename);
        Properties connectionProperties = (Properties)propertiesCollection.get(connection);

        if (!NullChecker.isNullOrEmpty(connectionProperties)) {
            String host = connectionProperties.getProperty("host");
            int port = Integer.parseInt(connectionProperties.getProperty("port"));
            int timeout = Integer.parseInt(connectionProperties.getProperty("timeout"));

            HL7MLLPSocketTransceiver transceiver = new HL7MLLPSocketTransceiver(host, port, timeout);
            ret = transceiver.transceive(message);
        }
        else {
            throw new RuntimeException("Error getting connection properties for " + connection + " in file " + connectionFilename + ".");
        }

        return ret;
    }
}
