/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package gov.va.med.nhin.adapter.datamanager.adapters;

import java.text.*;
import java.util.*;

import ca.uhn.hl7v2.model.*;
import ca.uhn.hl7v2.model.v24.datatype.*;
import ca.uhn.hl7v2.model.v24.segment.*;
import ca.uhn.hl7v2.model.v24.message.*;
import ca.uhn.hl7v2.parser.*;

import gov.va.med.nhin.adapter.datamanager.*;

/**
 *
 * @author David Vazquez
 */
public class HL7ADT24DataAdapter extends HL7MLLPDataAdapter
{
    @Override
    String buildMessage(DataQuery dataQuery) throws Exception
    {
        String template = dataQuery.getProperty("template").trim();

        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddhhmmss");
        Date currentTime = new Date();

        Parser parser = new GenericParser();
        ADT_A24 message = (ADT_A24)parser.parse(template);

        MSH msh = message.getMSH();
        msh.getDateTimeOfMessage().getTimeOfAnEvent().setValue(formatter.format(currentTime));
        msh.getMessageControlID().setValue(Long.toString(currentTime.getTime()));
        msh.getProcessingID().getProcessingID().setValue(dataQuery.getProperty("processingId"));
        msh.getSendingFacility().getNamespaceID().setValue((String)dataQuery.getParameter("correlatedFacilityNumber"));

        EVN evn = message.getEVN();
        evn.getRecordedDateTime().getTimeOfAnEvent().setValue(formatter.format(currentTime));
        evn.getEventFacility().getNamespaceID().setValue((String)dataQuery.getParameter("correlatedFacilityNumber"));

        PID pid = message.getPID();
        CX p = pid.getPatientIdentifierList(0);
        p.getID().setValue((String)dataQuery.getParameter("patientId"));
        p.getAssigningAuthority().getNamespaceID().setValue("USVHA");
        p.getAssigningAuthority().getUniversalIDType().setValue("0363");
        p.getAssigningFacility().getNamespaceID().setValue("VA FACILITY ID");
        p.getAssigningFacility().getUniversalID().setValue("200M");
        p.getAssigningFacility().getUniversalIDType().setValue("L");
        p.getIdentifierTypeCode().setValue("NI");
        p = pid.getPatientIdentifierList(1);
        p.getID().setValue((String)dataQuery.getParameter("correlatedPatientId"));
        p.getAssigningAuthority().getNamespaceID().setValue("USVHA");
        //p.getAssigningAuthority().getUniversalID().setValue("OID");
        p.getAssigningAuthority().getUniversalIDType().setValue("0363");
        p.getAssigningFacility().getNamespaceID().setValue("VA FACILITY ID");
        p.getAssigningFacility().getUniversalID().setValue((String)dataQuery.getParameter("correlatedFacilityNumber"));
        p.getAssigningFacility().getUniversalIDType().setValue("L");
        p.getIdentifierTypeCode().setValue("PI");

        XPN xpn = pid.getPatientName(0);
        xpn.getFamilyName().getSurname().setValue((String)dataQuery.getParameter("familyName"));
        xpn.getGivenName().setValue((String)dataQuery.getParameter("givenName"));
        xpn.getNameTypeCode().setValue("L");

        pid = message.getPID2();
        p = pid.getPatientIdentifierList(0);
        p.getID().setValue((String)dataQuery.getParameter("patientId"));
        p.getAssigningAuthority().getNamespaceID().setValue("USVHA");
        p.getAssigningAuthority().getUniversalIDType().setValue("0363");
        p.getAssigningFacility().getNamespaceID().setValue("VA FACILITY ID");
        p.getAssigningFacility().getUniversalID().setValue("200M");
        p.getAssigningFacility().getUniversalIDType().setValue("L");
        p.getIdentifierTypeCode().setValue("NI");
        p = pid.getPatientIdentifierList(1);
        p.getID().setValue((String)dataQuery.getParameter("correlatedPatientId"));
        p.getAssigningAuthority().getNamespaceID().setValue("USVHA");
        //p.getAssigningAuthority().getUniversalID().setValue("OID");
        p.getAssigningAuthority().getUniversalIDType().setValue("0363");
        p.getAssigningFacility().getNamespaceID().setValue("VA FACILITY ID");
        p.getAssigningFacility().getUniversalID().setValue((String)dataQuery.getParameter("correlatedFacilityNumber"));
        p.getAssigningFacility().getUniversalIDType().setValue("L");
        p.getIdentifierTypeCode().setValue("PI");

        xpn = pid.getPatientName(0);
        xpn.getFamilyName().getSurname().setValue((String)dataQuery.getParameter("familyName"));
        xpn.getGivenName().setValue((String)dataQuery.getParameter("givenName"));
        xpn.getNameTypeCode().setValue("L");

        return parser.encode(message);
    }

    @Override
    List processResponse(DataQuery dataQuery, String response) throws Exception
    {
        return new ArrayList();
    }
}
